/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountImpl;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountRole;
import de.rcenvironment.core.embedded.ssh.internal.SshConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshConfiguration {
    protected static final int DEFAULT_PORT = 31005;
    protected static final String DEFAULT_HOST = "127.0.0.1";
    protected static final Integer DEFAULT_IDLE_TIMEOUT_SECONDS = 60;
    private static final String CONFIG_PROPERTY_IDLE_TIMEOUT_SECONDS = "idleTimeoutSeconds";
    private static final String STATIC_ACCOUNT_DATA_SOURCE_INFO = "the main configuration file";
    private static final String DYNAMIC_ACCOUNTS_FILENAME = "accounts.json";
    private boolean enabled = false;
    private String host;
    private int port;
    private Integer idleTimeoutSeconds;
    private List<SshAccountImpl> staticAccounts = new ArrayList<SshAccountImpl>();
    private List<SshAccountImpl> dynamicAccounts = new ArrayList<SshAccountImpl>();
    private Map<String, SshAccountImpl> currentAccountMap = new HashMap<String, SshAccountImpl>();
    private final List<SshAccountRole> roles;
    private final Log log = LogFactory.getLog(this.getClass());
    private String accountDataOriginInfo;

    public SshConfiguration() {
        this.host = DEFAULT_HOST;
        this.port = 31005;
        this.roles = this.createPredefinedRoles();
    }

    public SshConfiguration(ConfigurationSegment configurationSegment) throws ConfigurationException, IOException {
        this.roles = this.createPredefinedRoles();
        this.enabled = configurationSegment.getBoolean("enabled", Boolean.valueOf(false));
        this.idleTimeoutSeconds = configurationSegment.getInteger(CONFIG_PROPERTY_IDLE_TIMEOUT_SECONDS, DEFAULT_IDLE_TIMEOUT_SECONDS);
        if (this.idleTimeoutSeconds <= 0) {
            LogFactory.getLog(this.getClass()).warn((Object)("Invalid value for SSH server setting 'idleTimeoutSeconds' - using default of " + DEFAULT_IDLE_TIMEOUT_SECONDS));
            this.idleTimeoutSeconds = DEFAULT_IDLE_TIMEOUT_SECONDS;
        }
        String oldHostSetting = configurationSegment.getString("host");
        String newHostSetting = configurationSegment.getString("ip");
        if (oldHostSetting != null) {
            LogFactory.getLog(this.getClass()).warn((Object)"Deprecated SSH server configuration parameter \"host\" used - use \"ip\" instead");
            this.host = oldHostSetting;
        }
        if (newHostSetting != null) {
            if (oldHostSetting != null) {
                LogFactory.getLog(this.getClass()).error((Object)"Both \"host\" and \"ip\" settings of SSH server used; ignoring deprecated \"host\" setting");
            }
            this.host = newHostSetting;
        }
        if (this.host == null) {
            this.host = DEFAULT_HOST;
        }
        this.port = configurationSegment.getInteger("port", Integer.valueOf(31005));
        Map staticAccountData = configurationSegment.listElements("accounts");
        try {
            this.staticAccounts = this.parseAccountData(staticAccountData, STATIC_ACCOUNT_DATA_SOURCE_INFO);
        }
        catch (ConfigurationException configurationException) {
            this.log.warn((Object)"Failed to parse the list of SSH accounts; the SSH server will remain disabled");
            this.staticAccounts = new ArrayList<SshAccountImpl>();
        }
        this.dynamicAccounts = new ArrayList<SshAccountImpl>();
        this.accountDataOriginInfo = "static";
        this.updateEffectiveAccountLookup();
        if (configurationSegment.getSubSegment("roles").isPresentInCurrentConfiguration()) {
            this.log.warn((Object)"Deprecated \"roles\" configuration used. The roles will not be applied. Only predefined roles can be used. A list of available roles can be found in the configuration reference or the user guide.");
        }
    }

    private List<SshAccountRole> createPredefinedRoles() {
        ArrayList<SshAccountRole> predefRoles = new ArrayList<SshAccountRole>();
        String[] stringArray = SshConstants.PREDEFINED_ROLE_NAMES;
        int n = SshConstants.PREDEFINED_ROLE_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            predefRoles.add(new SshAccountRole(roleName));
            ++n2;
        }
        return predefRoles;
    }

    public synchronized boolean validateConfiguration(Log logger) {
        boolean isValid = true;
        ArrayList<SshAccountImpl> valUsers = new ArrayList<SshAccountImpl>();
        if (this.host == null || this.host.isEmpty()) {
            logger.warn((Object)"SSH server host can not be empty");
        }
        if (this.port < 0 || this.port > 65535) {
            logger.warn((Object)"sshContactPoint must be between 0 and 65535");
            isValid = false;
        }
        if (this.staticAccounts != null && !this.staticAccounts.isEmpty()) {
            for (SshAccountImpl user : this.staticAccounts) {
                boolean bl = isValid = user.validate(this.roles, logger) && isValid;
                if (valUsers.contains(user)) {
                    logger.warn((Object)("User names must be distinct. Found two users with name: " + user.getLoginName()));
                    isValid = false;
                    continue;
                }
                valUsers.add(user);
            }
        }
        if (!isValid) {
            logger.error((Object)"Embedded SSH server will not be started due to an error in the configuration.");
        }
        return isValid;
    }

    public synchronized void applyDynamicSshAccountData(Map<String, ConfigurationSegment> sshAccounts) {
        try {
            this.dynamicAccounts = this.parseAccountData(sshAccounts, DYNAMIC_ACCOUNTS_FILENAME);
            this.updateEffectiveAccountLookup();
        }
        catch (ConfigurationException configurationException) {
            this.log.warn((Object)"Failed to read the dynamic list of SSH accounts from accounts.json; no changes applied");
            return;
        }
    }

    public synchronized void injectAccount(SshAccountImpl account) {
        this.currentAccountMap.put(account.getLoginName(), account);
    }

    public synchronized SshAccount getAccountByName(String loginName, boolean allowDisabled) {
        SshAccount account = this.currentAccountMap.get(loginName);
        if (account == null) {
            return null;
        }
        if (account.isEnabled()) {
            return account;
        }
        if (allowDisabled) {
            this.log.debug((Object)("Returning disabled account '" + account.getLoginName() + "' on explicit query"));
            return account;
        }
        this.log.debug((Object)("Default query for disabled account '" + account.getLoginName() + "'; responding as if it did not exist"));
        return null;
    }

    public SshAccountRole getRoleByName(String roleName) {
        SshAccountRole curRole = null;
        for (SshAccountRole role : this.roles) {
            if (!role.getRoleName().equals(roleName)) continue;
            curRole = role;
            break;
        }
        if (curRole == null) {
            curRole = this.getRoleByName("default");
        }
        return curRole;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean startSshConsole) {
        this.enabled = startSshConsole;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Integer getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public void setIdleTimeoutSeconds(Integer idleTimeoutSeconds) {
        this.idleTimeoutSeconds = idleTimeoutSeconds;
    }

    public void setPort(int sshContactPoint) {
        this.port = sshContactPoint;
    }

    protected synchronized List<SshAccountImpl> listAccounts() {
        return Collections.unmodifiableList(new ArrayList<SshAccountImpl>(this.currentAccountMap.values()));
    }

    protected synchronized void setStaticAccounts(List<SshAccountImpl> users) {
        this.staticAccounts = users;
        if (this.staticAccounts == null) {
            this.staticAccounts = new ArrayList<SshAccountImpl>();
        }
        this.updateEffectiveAccountLookup();
    }

    public List<SshAccountRole> getRoles() {
        return this.roles;
    }

    public synchronized int getCurrentNumberOfAccouts() {
        return this.currentAccountMap.size();
    }

    public synchronized String getAccountDataOriginInfo() {
        return this.accountDataOriginInfo;
    }

    public synchronized List<SshAccountImpl> getStaticAccounts() {
        return Collections.unmodifiableList(new ArrayList<SshAccountImpl>(this.staticAccounts));
    }

    private List<SshAccountImpl> parseAccountData(Map<String, ConfigurationSegment> accountData, String dataSourceInfo) throws ConfigurationException {
        ArrayList<SshAccountImpl> tempAccountList = new ArrayList<SshAccountImpl>();
        if (accountData == null) {
            return tempAccountList;
        }
        for (Map.Entry<String, ConfigurationSegment> entry : accountData.entrySet()) {
            try {
                SshAccountImpl account = (SshAccountImpl)entry.getValue().mapToObject(SshAccountImpl.class);
                account.setLoginName(entry.getKey());
                tempAccountList.add(account);
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Error parsing the SSH account entry \"" + entry.getKey() + "\" loaded from " + dataSourceInfo);
            }
        }
        return tempAccountList;
    }

    private void updateEffectiveAccountLookup() {
        SshAccountImpl replaced;
        HashMap<String, SshAccountImpl> tempMap = new HashMap<String, SshAccountImpl>();
        if (!this.staticAccounts.isEmpty()) {
            if (!this.dynamicAccounts.isEmpty()) {
                this.log.warn((Object)("Merging " + this.staticAccounts.size() + " initial SSH accounts with " + this.dynamicAccounts.size() + " loaded from " + DYNAMIC_ACCOUNTS_FILENAME + "; accounts from the latter take precedence"));
                this.accountDataOriginInfo = "merged";
            } else {
                this.accountDataOriginInfo = "static";
            }
        } else {
            this.accountDataOriginInfo = "dynamic";
        }
        for (SshAccountImpl account : this.staticAccounts) {
            replaced = tempMap.put(account.getLoginName(), account);
            if (replaced == null) continue;
            this.log.warn((Object)("Found multiple static SSH accounts with login name '" + account.getLoginName() + "'"));
            if (account.isEnabled() == replaced.isEnabled()) continue;
            this.log.warn((Object)("The SSH accounts with the same login name '" + account.getLoginName() + "' have different 'enabled' settings (current account: " + account.isEnabled() + "). Unless this is intentional, it is highly recommended to check your configuration!"));
        }
        for (SshAccountImpl account : this.dynamicAccounts) {
            replaced = tempMap.put(account.getLoginName(), account);
            if (replaced == null) continue;
            this.log.warn((Object)("SSH account '" + account.getLoginName() + "' loaded from " + DYNAMIC_ACCOUNTS_FILENAME + " replaces a previous account with the same login name"));
            if (account.isEnabled() == replaced.isEnabled()) continue;
            this.log.warn((Object)("The SSH accounts with the same login name '" + account.getLoginName() + "' have different 'enabled' settings (current account: " + account.isEnabled() + "). Unless this is intentional, it is highly recommended to check your configuration!"));
        }
        this.currentAccountMap = tempMap;
    }
}

