/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.SystemMonitoringDataService;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.monitoring.system.internal.RingBufferOfDouble;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.utils.common.TimeSource;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemLoadInformationCollector
implements Runnable {
    private final SystemMonitoringDataService dataSource;
    private final TimeSource timeSource;
    private final int minimumTimeDelta;
    private final int maximumTimeDelta;
    private final RingBufferOfDouble cpuLoadRingBuffer;
    private double latestCpuLoad = Double.NaN;
    private long latestAvailableRam = -1L;
    private int failureCount = 0;
    private long lastUpdateTime = Integer.MIN_VALUE;
    private int ignoredUpdateTriggers;
    private final Log log = LogFactory.getLog(this.getClass());

    public SystemLoadInformationCollector(SystemMonitoringDataService systemDataService, int bufferCapacity, TimeSource timeSource, int minimumTimeDelta, int maximumTimeDelta) {
        Objects.requireNonNull(systemDataService);
        Objects.requireNonNull(timeSource);
        this.dataSource = systemDataService;
        this.cpuLoadRingBuffer = new RingBufferOfDouble(bufferCapacity);
        this.timeSource = timeSource;
        this.minimumTimeDelta = minimumTimeDelta;
        this.maximumTimeDelta = maximumTimeDelta;
    }

    @Override
    public synchronized void run() {
        try {
            long time = this.timeSource.getCurrentTimeMillis();
            if (time < this.lastUpdateTime + (long)this.minimumTimeDelta) {
                ++this.ignoredUpdateTriggers;
                return;
            }
            this.lastUpdateTime = time;
            if (this.ignoredUpdateTriggers > 0) {
                this.log.debug((Object)StringUtils.format((String)"Ignored %s delayed system monitoring update trigger(s) that arrived faster than the configured minimum time of %d msec; this may be caused by the host system resuming after being suspended, or a very high number of concurrent tasks", (Object[])new Object[]{this.ignoredUpdateTriggers, this.minimumTimeDelta}));
                this.ignoredUpdateTriggers = 0;
            }
            this.latestCpuLoad = this.dataSource.getTotalCPUUsage();
            this.latestAvailableRam = this.dataSource.getFreeRAM();
            this.cpuLoadRingBuffer.add(this.latestCpuLoad);
            this.failureCount = 0;
        }
        catch (OperatingSystemException e) {
            ++this.failureCount;
            this.log.error((Object)("Error retrieving system load information (sequential failure count: " + this.failureCount + ")"), (Throwable)e);
        }
    }

    public synchronized SystemLoadInformation getSystemLoadInformation(int maxSamples) {
        return new SystemLoadInformation(this.cpuLoadRingBuffer.getAverageOfLatest(maxSamples), this.latestCpuLoad, this.latestAvailableRam);
    }
}

