/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DOEUtils {
    protected static final Log LOGGER = LogFactory.getLog(DOEUtils.class);

    private DOEUtils() {
    }

    public static boolean writeTableToCSVFile(Object[][] tableValues, String path, List<String> header) {
        if (path != null && !path.endsWith(".csv")) {
            path = String.valueOf(path) + ".csv";
        }
        try {
            if (path != null) {
                FileWriter fw = new FileWriter(new File(path));
                BufferedWriter bw = new BufferedWriter(fw);
                CSVPrinter printer = CSVFormat.newFormat((char)';').withIgnoreSurroundingSpaces().withAllowMissingColumnNames().withRecordSeparator("\n").print((Appendable)bw);
                for (String head : header) {
                    printer.print((Object)head);
                }
                printer.println();
                int i = 0;
                while (i < tableValues.length) {
                    printer.printRecord(tableValues[i]);
                    ++i;
                }
                printer.flush();
                printer.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return false;
        }
        return true;
    }

    public static boolean writeResultToCSVFile(Object[][] tableValues, Map<Integer, Map<String, Double>> results, String path, int currentRun, List<String> outputs) {
        if (path != null && !path.endsWith(".csv")) {
            path = String.valueOf(path) + ".csv";
        }
        try {
            if (path != null && !results.isEmpty() && results.get(0) != null && !results.get(0).isEmpty()) {
                LinkedList<String> orderedInputs = new LinkedList<String>(results.get(0).keySet());
                Collections.sort(orderedInputs);
                FileWriter fw = new FileWriter(new File(path));
                BufferedWriter bw = new BufferedWriter(fw);
                CSVPrinter printer = CSVFormat.newFormat((char)';').withIgnoreSurroundingSpaces().withAllowMissingColumnNames().withRecordSeparator("\n").print((Appendable)bw);
                for (String outputName : outputs) {
                    printer.print((Object)outputName);
                }
                for (String input : orderedInputs) {
                    printer.print((Object)input);
                }
                printer.println();
                int i = 0;
                while (i < currentRun) {
                    if (results.get(i) != null) {
                        int j = 0;
                        while (j < tableValues[i].length) {
                            printer.print(tableValues[i][j]);
                            ++j;
                        }
                        for (String input : orderedInputs) {
                            printer.print((Object)results.get(i).get(input));
                        }
                    }
                    printer.println();
                    ++i;
                }
                printer.flush();
                printer.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return false;
        }
        return true;
    }
}

