/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.relay.internal;

import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptor;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptorListUpdate;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationRequest;
import de.rcenvironment.core.communication.uplink.entities.ChannelCreationResponse;
import de.rcenvironment.core.communication.uplink.network.channel.internal.AbstractChannelEndpoint;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkEndpointService;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSession;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ServerSideUplinkEndpointServiceImpl
implements ServerSideUplinkEndpointService {
    private static final String FROM_SESSION = " from session ";
    private final UplinkProtocolMessageConverter messageConverter = new UplinkProtocolMessageConverter("server endpoint");
    private final AtomicInteger sessionCounter = new AtomicInteger(0);
    private final Set<ServerSideUplinkSession> activeSessions = new HashSet<ServerSideUplinkSession>();
    private final Map<String, MessageBlock> cachedToolDescriptorUpdatesByDestinationId = new HashMap<String, MessageBlock>();
    private final Map<ServerSideUplinkSession, ServerSideSessionHandler> sessionHandlers = new HashMap<ServerSideUplinkSession, ServerSideSessionHandler>();
    private ConcurrencyUtilsFactory concurrencyUtilsFactory;
    private final Object crossSessionStateLock = new Object();
    private final Log log = LogFactory.getLog(this.getClass());
    private final AtomicLong channelIdCounter = new AtomicLong(0L);
    private final Map<Long, ChannelData> channelDataMap = new HashMap<Long, ChannelData>();
    private final Map<String, ServerSideUplinkSession> namespacesToSessionsMap = new HashMap<String, ServerSideUplinkSession>();

    @Override
    public String assignSessionId(ServerSideUplinkSession session) {
        return "s" + this.sessionCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionActiveState(ServerSideUplinkSession session, boolean active) {
        this.log.debug((Object)StringUtils.format((String)"[%s] Setting active state of session to %s", (Object[])new Object[]{session.getLogDescriptor(), active}));
        Object object = this.crossSessionStateLock;
        synchronized (object) {
            if (active) {
                this.activeSessions.add(session);
                this.sessionHandlers.put(session, new ServerSideSessionHandler(session));
                try {
                    this.provideCachedToolDescriptorsToNewSession(session);
                }
                catch (IOException iOException) {
                    this.log.warn((Object)("Error while sending cached tool descriptors to new session " + session));
                }
            } else {
                Optional<String> assignedNamespaceId = session.getAssignedNamespaceIdIfAvailable();
                if (assignedNamespaceId.isPresent()) {
                    ServerSideUplinkSession mappedSessionForNamespaceId = this.namespacesToSessionsMap.get(assignedNamespaceId.get());
                    if (mappedSessionForNamespaceId == session) {
                        this.log.warn((Object)("[" + session + "] Session still had a namespace assigned when resetting its 'active' state"));
                        this.releaseNamespaceId(assignedNamespaceId.get(), session);
                    } else if (mappedSessionForNamespaceId != null) {
                        this.log.warn((Object)("Unusual state: Namespace id " + assignedNamespaceId.get() + " has been assigned to another session (" + mappedSessionForNamespaceId + ") before the previous one (" + session + ") has been deactivated"));
                    }
                }
                this.activeSessions.remove(session);
                this.sessionHandlers.remove(session);
                this.deregisterCachedToolDescriptorsOfClosedSession(session);
            }
        }
    }

    @Override
    public void onMessageBlock(ServerSideUplinkSession receivingSession, long channelId, MessageBlock messageBlock) throws ProtocolException {
        ServerSideSessionHandler sessionHandler = this.sessionHandlers.get(receivingSession);
        if (sessionHandler == null) {
            this.log.debug((Object)("Discarding a message of type " + (Object)((Object)messageBlock.getType()) + " that arrived after session " + receivingSession + " was deactivated"));
            return;
        }
        sessionHandler.processMessageblock(channelId, messageBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean attemptToAssignNamespaceId(String namespaceId, ServerSideUplinkSession newSession) {
        Map<String, ServerSideUplinkSession> map = this.namespacesToSessionsMap;
        synchronized (map) {
            block4: {
                ServerSideUplinkSession existingSession = this.namespacesToSessionsMap.get(namespaceId);
                if (existingSession == null) break block4;
                this.log.warn((Object)("Refusing session " + newSession + " from using namespace " + namespaceId + " as it is already in use by session " + existingSession));
                return false;
            }
            this.namespacesToSessionsMap.put(namespaceId, newSession);
            this.log.debug((Object)StringUtils.format((String)"[%s] Assigning namespace '%s'", (Object[])new Object[]{newSession.getLogDescriptor(), namespaceId}));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseNamespaceId(String namespaceId, ServerSideUplinkSession session) {
        Map<String, ServerSideUplinkSession> map = this.namespacesToSessionsMap;
        synchronized (map) {
            ServerSideUplinkSession existingSession = this.namespacesToSessionsMap.get(namespaceId);
            if (existingSession == null) {
                this.log.debug((Object)("Ignoring request to release namespace " + namespaceId + FROM_SESSION + session + " as it is not registered for any session"));
                return;
            }
            if (existingSession != session) {
                this.log.warn((Object)("Ignoring request to release namespace " + namespaceId + FROM_SESSION + session + " as it is bound to session " + existingSession + " instead"));
                return;
            }
            this.namespacesToSessionsMap.remove(namespaceId);
            this.log.debug((Object)StringUtils.format((String)"[%s] Releasing namespace '%s'", (Object[])new Object[]{session.getLogDescriptor(), namespaceId}));
        }
    }

    @Reference
    public void bindConcurrencyUtilsFactory(ConcurrencyUtilsFactory newInstance) {
        this.concurrencyUtilsFactory = newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncomingToolDescriptorUpdate(ToolDescriptorListUpdate update, ServerSideUplinkSession sourceSession, MessageBlock messageBlock) throws IOException {
        this.log.debug((Object)("Forwarding a tool descriptor update from session " + sourceSession + " to " + this.activeSessions.size() + " session(s)"));
        Object object = this.crossSessionStateLock;
        synchronized (object) {
            if (!update.getToolDescriptors().isEmpty()) {
                this.cachedToolDescriptorUpdatesByDestinationId.put(update.getDestinationId(), messageBlock);
            } else {
                MessageBlock previousEntry = this.cachedToolDescriptorUpdatesByDestinationId.remove(update.getDestinationId());
                if (previousEntry != null) {
                    this.log.debug((Object)("Removed cached tool descriptor list for destination id '" + update.getDestinationId() + "' as its session sent an empty list update"));
                } else {
                    this.log.warn((Object)("Received an empty tool descriptor list update for destination id '" + update.getDestinationId() + "', but there was no previous cached entry to remove?"));
                }
            }
            for (ServerSideUplinkSession session : this.activeSessions) {
                if (session == sourceSession) continue;
                session.enqueueMessageBlockForSending(0L, messageBlock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void provideCachedToolDescriptorsToNewSession(ServerSideUplinkSession session) throws IOException {
        Object object = this.crossSessionStateLock;
        synchronized (object) {
            for (Map.Entry<String, MessageBlock> entry : this.cachedToolDescriptorUpdatesByDestinationId.entrySet()) {
                String destinationId = entry.getKey();
                MessageBlock cachedMessageBlock = entry.getValue();
                this.log.debug((Object)("Forwarding a cached tool descriptor list update for destination " + destinationId + " to new session " + session));
                session.enqueueMessageBlockForSending(0L, cachedMessageBlock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterCachedToolDescriptorsOfClosedSession(ServerSideUplinkSession closedSession) {
        String destinationIdPrefix = closedSession.getDestinationIdPrefix();
        ArrayList<String> destinationIdsToRemove = new ArrayList<String>();
        Object object = this.crossSessionStateLock;
        synchronized (object) {
            for (Map.Entry<String, MessageBlock> entry : this.cachedToolDescriptorUpdatesByDestinationId.entrySet()) {
                String destinationId = entry.getKey();
                if (!destinationId.startsWith(destinationIdPrefix)) continue;
                destinationIdsToRemove.add(destinationId);
            }
            for (String destinationId : destinationIdsToRemove) {
                MessageBlock emptyToolDescriptorListUpdateMessageBlock;
                this.log.debug((Object)("Removing a cached tool descriptor list update for destination " + destinationId + " as its session " + closedSession + " is closing"));
                this.cachedToolDescriptorUpdatesByDestinationId.remove(destinationId);
                try {
                    emptyToolDescriptorListUpdateMessageBlock = this.messageConverter.encodeToolDescriptorListUpdate(new ToolDescriptorListUpdate(destinationId, "", new ArrayList<ToolDescriptor>()));
                }
                catch (ProtocolException protocolException) {
                    throw new IllegalStateException();
                }
                for (ServerSideUplinkSession sessionToInform : this.activeSessions) {
                    if (sessionToInform == closedSession) {
                        throw new IllegalStateException("The closing session should have been unregisterd at this point");
                    }
                    try {
                        sessionToInform.enqueueMessageBlockForSending(0L, emptyToolDescriptorListUpdateMessageBlock);
                    }
                    catch (IOException iOException) {
                        this.log.warn((Object)("Error while sending a tool removal update to session " + sessionToInform));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long createAndRegisterChannel(ServerSideUplinkSession initiatingSession, ServerSideUplinkSession destinationSession, String channelType) {
        Long channelId = this.generateChannelId(channelType);
        if (initiatingSession == destinationSession) {
            throw new IllegalArgumentException();
        }
        ChannelData channelData = new ChannelData(initiatingSession, destinationSession, channelId);
        Map<Long, ChannelData> map = this.channelDataMap;
        synchronized (map) {
            this.channelDataMap.put(channelId, channelData);
        }
        return channelId;
    }

    private Optional<ServerSideUplinkSession> findSessionForDestinationIdWithRetry(String destinationId, int numAttempts, int intervalMsec) {
        Optional<ServerSideUplinkSession> result;
        if (numAttempts < 1) {
            throw new IllegalArgumentException();
        }
        int attempt = 1;
        do {
            if (attempt <= true) continue;
            this.log.debug((Object)("Waiting " + intervalMsec + " msec for a matching session to become available"));
            try {
                Thread.sleep(intervalMsec);
            }
            catch (InterruptedException interruptedException) {
                this.log.debug((Object)"Interrupted while waiting for retry; most likely, the application is shutting down");
                return Optional.empty();
            }
        } while (!(result = this.findSessionForDestinationId(destinationId)).isPresent() && attempt < numAttempts);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ServerSideUplinkSession> findSessionForDestinationId(String destinationId) {
        Set<ServerSideUplinkSession> set = this.activeSessions;
        synchronized (set) {
            for (ServerSideUplinkSession session : this.activeSessions) {
                if (!destinationId.startsWith(session.getDestinationIdPrefix())) continue;
                return Optional.of(session);
            }
            this.log.debug((Object)("Received a destination id, but found no matching active session among " + Arrays.toString(this.activeSessions.toArray())));
        }
        return Optional.empty();
    }

    private Long generateChannelId(String type) {
        Long id = this.channelIdCounter.incrementAndGet();
        this.log.debug((Object)StringUtils.format((String)"Creating channel %s (type '%s')", (Object[])new Object[]{id, type}));
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardChannelMessage(ServerSideUplinkSession sourceSession, long channelId, MessageBlock messageBlock) throws IOException {
        ChannelData channelData;
        Map<Long, ChannelData> map = this.channelDataMap;
        synchronized (map) {
            channelData = this.channelDataMap.get(channelId);
        }
        if (channelData == null) {
            this.log.warn((Object)("Received a message for non-existing channel " + channelId + "; it may have been closed in the meantime"));
            return;
        }
        if (sourceSession == channelData.getInitiatorSession()) {
            channelData.getDestinationSession().enqueueMessageBlockForSending(channelId, messageBlock);
        } else if (sourceSession == channelData.getDestinationSession()) {
            channelData.getInitiatorSession().enqueueMessageBlockForSending(channelId, messageBlock);
        } else {
            this.log.error((Object)("Detected an attempt to send a message block to an unauthorized channel: source session " + sourceSession + ", message type " + (Object)((Object)messageBlock.getType()) + ",  channel id " + channelId));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNamespaceAssigned(String namespace) {
        Map<String, ServerSideUplinkSession> map = this.namespacesToSessionsMap;
        synchronized (map) {
            return this.namespacesToSessionsMap.containsKey(namespace);
        }
    }

    private final class ChannelData {
        private ServerSideUplinkSession initiatorSession;
        private ServerSideUplinkSession destinationSession;
        private Long channelId;

        private ChannelData(ServerSideUplinkSession initiatorSession, ServerSideUplinkSession destinationSession, Long sourceChannelId) {
            this.initiatorSession = initiatorSession;
            this.destinationSession = destinationSession;
            this.channelId = sourceChannelId;
        }

        public ServerSideUplinkSession getInitiatorSession() {
            return this.initiatorSession;
        }

        public ServerSideUplinkSession getDestinationSession() {
            return this.destinationSession;
        }

        public Long getChannelId() {
            return this.channelId;
        }
    }

    private final class DefaultChannelRelayEndpoint
    extends AbstractChannelEndpoint {
        private static final int DEFAULT_CHANNEL_MATCH_ATTEMPTS = 3;
        private static final int DEFAULT_CHANNEL_MATCH_RETRY_INTERVAL = 500;
        private ServerSideUplinkSession initiatingSession;

        private DefaultChannelRelayEndpoint(ServerSideUplinkSession session) {
            super(session, session.getLocalSessionId(), 0L);
            this.initiatingSession = session;
        }

        @Override
        protected boolean processMessageInternal(MessageBlock messageBlock) throws IOException {
            MessageType messageType = messageBlock.getType();
            switch (messageType) {
                case TOOL_DESCRIPTOR_LIST_UPDATE: {
                    return this.handleToolDescriptorListUpdate(messageBlock);
                }
                case CHANNEL_INIT: {
                    return this.handleChannelInit(messageBlock);
                }
                case CHANNEL_INIT_RESPONSE: {
                    return this.handleChannelInitResponse(messageBlock);
                }
            }
            this.log.debug((Object)("Received other message from client, mirroring back (DEVELOPMENT ONLY): " + new String(messageBlock.getData(), Charsets.UTF_8)));
            this.enqueueMessageBlockForSending(messageBlock);
            return true;
        }

        @Override
        public void dispose() {
        }

        private boolean handleChannelInit(MessageBlock messageBlock) throws ProtocolException, IOException {
            ChannelCreationRequest request = this.messageConverter.decodeChannelCreationRequest(messageBlock);
            String channelType = request.getType();
            Optional optionalDestinationSession = ServerSideUplinkEndpointServiceImpl.this.findSessionForDestinationIdWithRetry(request.getDestinationId(), 3, 500);
            if (!optionalDestinationSession.isPresent()) {
                this.log.warn((Object)("Received a channel creation request for destination id '" + request.getDestinationId() + "', but there was no client session matching its destination prefix"));
                ChannelCreationResponse failureResponse = new ChannelCreationResponse(-1L, request.getRequestId(), false);
                this.enqueueMessageBlockForSending(this.messageConverter.encodeChannelCreationResponse(failureResponse));
                return true;
            }
            ServerSideUplinkSession destinationSession = (ServerSideUplinkSession)optionalDestinationSession.get();
            if (destinationSession == this.initiatingSession) {
                this.log.warn((Object)("Received a request to create a channel where both endpoints are session " + this.initiatingSession + "; this is not allowed"));
                ChannelCreationResponse failureResponse = new ChannelCreationResponse(-1L, request.getRequestId(), false);
                this.enqueueMessageBlockForSending(this.messageConverter.encodeChannelCreationResponse(failureResponse));
                return true;
            }
            Long channelId = ServerSideUplinkEndpointServiceImpl.this.createAndRegisterChannel(this.initiatingSession, destinationSession, channelType);
            ChannelCreationRequest channelOffer = new ChannelCreationRequest(request.getType(), request.getDestinationId(), channelId, request.getRequestId());
            this.log.debug((Object)("Forwarding a channel request from session " + this.initiatingSession + " to session " + destinationSession + "; assigned channel id " + channelId));
            destinationSession.enqueueMessageBlockForSending(0L, this.messageConverter.encodeChannelCreationRequest(channelOffer));
            return true;
        }

        private boolean handleChannelInitResponse(MessageBlock messageBlock) throws IOException {
            ChannelCreationResponse receivedResponse = this.messageConverter.decodeChannelCreationResponse(messageBlock);
            long channelId = receivedResponse.getChannelId();
            ChannelData channelData = (ChannelData)ServerSideUplinkEndpointServiceImpl.this.channelDataMap.get(channelId);
            if (channelData.getDestinationSession() != this.initiatingSession) {
                this.log.error((Object)("Received a channel creation response from a different session (" + this.initiatingSession + ") than the expected one (" + channelData.getDestinationSession() + "); ignoring this message"));
                return true;
            }
            this.log.debug((Object)("Forwarding a channel acceptance message for channel " + channelId + ServerSideUplinkEndpointServiceImpl.FROM_SESSION + this.initiatingSession + " to the initiating session " + channelData.getInitiatorSession()));
            ChannelCreationResponse forwardedResponse = new ChannelCreationResponse(channelId, receivedResponse.getRequestId(), true);
            channelData.getInitiatorSession().enqueueMessageBlockForSending(0L, this.messageConverter.encodeChannelCreationResponse(forwardedResponse));
            return true;
        }

        private boolean handleToolDescriptorListUpdate(MessageBlock messageBlock) throws IOException {
            ToolDescriptorListUpdate update = this.messageConverter.decodeToolDescriptorListUpdate(messageBlock);
            ServerSideUplinkEndpointServiceImpl.this.processIncomingToolDescriptorUpdate(update, this.initiatingSession, messageBlock);
            return true;
        }
    }

    private final class ServerSideSessionHandler {
        private final ServerSideUplinkSession session;
        private final DefaultChannelRelayEndpoint defaultChannelEndpoint;

        private ServerSideSessionHandler(ServerSideUplinkSession session) {
            this.session = session;
            this.defaultChannelEndpoint = new DefaultChannelRelayEndpoint(session);
        }

        public void processMessageblock(long channelId, MessageBlock messageBlock) {
            try {
                if (channelId == 0L) {
                    this.defaultChannelEndpoint.processMessage(messageBlock);
                } else {
                    ServerSideUplinkEndpointServiceImpl.this.forwardChannelMessage(this.session, channelId, messageBlock);
                }
            }
            catch (IOException e) {
                ServerSideUplinkEndpointServiceImpl.this.log.error((Object)"Error while processing a received message", (Throwable)e);
            }
        }
    }
}

