/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui;

import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.TerminalPosition;

public interface Interactable {
    public Result keyboardInteraction(Key var1);

    public void onEnterFocus(FocusChangeDirection var1);

    public void onLeaveFocus(FocusChangeDirection var1);

    public TerminalPosition getHotspot();

    public static enum FocusChangeDirection {
        DOWN,
        RIGHT,
        UP,
        LEFT;

    }

    public static enum Result {
        EVENT_HANDLED,
        EVENT_NOT_HANDLED,
        NEXT_INTERACTABLE_DOWN,
        NEXT_INTERACTABLE_RIGHT,
        PREVIOUS_INTERACTABLE_UP,
        PREVIOUS_INTERACTABLE_LEFT;


        boolean isNextInteractable() {
            return this == NEXT_INTERACTABLE_DOWN || this == NEXT_INTERACTABLE_RIGHT;
        }

        boolean isPreviousInteractable() {
            return this == PREVIOUS_INTERACTABLE_LEFT || this == PREVIOUS_INTERACTABLE_UP;
        }

        FocusChangeDirection asFocusChangeDirection() {
            if (this == NEXT_INTERACTABLE_DOWN) {
                return FocusChangeDirection.DOWN;
            }
            if (this == NEXT_INTERACTABLE_RIGHT) {
                return FocusChangeDirection.RIGHT;
            }
            if (this == PREVIOUS_INTERACTABLE_LEFT) {
                return FocusChangeDirection.LEFT;
            }
            if (this == PREVIOUS_INTERACTABLE_UP) {
                return FocusChangeDirection.UP;
            }
            return null;
        }
    }
}

