/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java.picocontainer;

import cucumber.api.java.ObjectFactory;
import cucumber.runtime.Utils;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoBuilder;

public class PicoFactory
implements ObjectFactory {
    private MutablePicoContainer pico;
    private final Set<Class<?>> classes = new HashSet();

    public void start() {
        this.pico = new PicoBuilder().withCaching().withLifecycle().build();
        for (Class<?> clazz : this.classes) {
            this.pico.addComponent(clazz);
        }
        this.pico.start();
    }

    public void stop() {
        this.pico.stop();
        this.pico.dispose();
    }

    public boolean addClass(Class<?> clazz) {
        if (Utils.isInstantiable(clazz) && this.classes.add(clazz)) {
            this.addConstructorDependencies(clazz);
        }
        return true;
    }

    public <T> T getInstance(Class<T> type) {
        return (T)this.pico.getComponent(type);
    }

    private void addConstructorDependencies(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            for (Class<?> paramClazz : constructor.getParameterTypes()) {
                this.addClass(paramClazz);
            }
        }
    }
}

