/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.management.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.component.authorization.api.ComponentAuthorizationSelector;
import de.rcenvironment.core.component.authorization.impl.ComponentAuthorizationSelectorImpl;
import de.rcenvironment.core.component.management.internal.ComponentPermissionStorage;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class JsonFileComponentPermissionStorage
implements ComponentPermissionStorage {
    private static final String PROFILE_RELATIVE_FILENAME = "configuration/components.json";
    private static final String BACKUP_FILE_1_SUFFIX = ".1.bak";
    private static final String BACKUP_FILE_2_SUFFIX = ".2.bak";
    private static final String AUTHORIZATION_JSON_NODE_PATH = "authorization";
    private AuthorizationService authorizationService;
    private AuthorizationPermissionSet permissionSetPublicAccess;
    private String permissionSetPublicAccessSignature;
    private ConfigurationService configurationService;
    private final ObjectMapper jsonMapper;
    private boolean initialized;
    private File storageFile;
    private File backupFile1;
    private File backupFile2;
    private JsonNode currentJsonData;
    private final Log log = LogFactory.getLog(this.getClass());

    public JsonFileComponentPermissionStorage() {
        this.jsonMapper = JsonUtils.getDefaultObjectMapper();
    }

    @Activate
    protected void activate() {
        this.storageFile = new File(this.configurationService.getProfileDirectory(), PROFILE_RELATIVE_FILENAME);
        try {
            if (!this.storageFile.exists()) {
                FileUtils.writeStringToFile((File)this.storageFile, (String)"{}");
            }
            if (!this.storageFile.isFile() || !this.storageFile.canWrite()) {
                this.log.error((Object)("Failed to initialize component authorization storage " + this.storageFile.getAbsolutePath() + ": the file could not be created or is not writable"));
            }
            this.currentJsonData = this.jsonMapper.readTree(this.storageFile);
            this.backupFile1 = new File(this.storageFile.getParentFile(), String.valueOf(this.storageFile.getName()) + BACKUP_FILE_1_SUFFIX);
            this.backupFile2 = new File(this.storageFile.getParentFile(), String.valueOf(this.storageFile.getName()) + BACKUP_FILE_2_SUFFIX);
            this.initialized = true;
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to initialize component authorization storage " + this.storageFile.getAbsolutePath() + ": " + e.toString()));
        }
    }

    @Reference
    protected synchronized void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    @Reference
    protected synchronized void bindAuthorizationService(AuthorizationService newInstance) {
        this.authorizationService = newInstance;
        this.permissionSetPublicAccess = this.authorizationService.getDefaultAuthorizationObjects().permissionSetPublicInLocalNetwork();
        this.permissionSetPublicAccessSignature = this.permissionSetPublicAccess.getSignature();
    }

    @Override
    public synchronized void persistAssignment(ComponentAuthorizationSelector selector, AuthorizationPermissionSet permissions) throws OperationFailureException {
        if (!this.initialized) {
            this.log.warn((Object)("Authorization storage is disabled - the new data for component-group assignment for selector " + selector.getId() + " will not be saved, and previous settings may return after restarting!"));
            return;
        }
        if (this.backupFile2.exists() && !this.backupFile2.delete()) {
            throw new OperationFailureException("Failed to delete backup file " + this.backupFile2.getAbsolutePath());
        }
        if (this.backupFile1.exists() && !this.backupFile1.renameTo(this.backupFile2)) {
            throw new OperationFailureException("Failed to move backup file " + this.backupFile1.getAbsolutePath() + " to " + this.backupFile2.getAbsolutePath());
        }
        if (!this.storageFile.renameTo(this.backupFile1)) {
            throw new OperationFailureException("Failed to move " + this.storageFile.getAbsolutePath() + " to backup location " + this.backupFile1.getAbsolutePath());
        }
        ObjectNode authNode = this.getAuthorizationDataJsonNode();
        if (!permissions.isLocalOnly()) {
            authNode.put(selector.getId(), permissions.getSignature());
        } else {
            authNode.remove(selector.getId());
        }
        try {
            FileUtils.writeStringToFile((File)this.storageFile, (String)this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.currentJsonData));
        }
        catch (IOException e) {
            throw new OperationFailureException("Failed to save updated component-group assignment data: " + e.toString());
        }
    }

    @Override
    public synchronized Map<ComponentAuthorizationSelector, AuthorizationPermissionSet> restorePersistedAssignments() {
        ObjectNode authNode;
        HashMap<ComponentAuthorizationSelector, AuthorizationPermissionSet> resultMap = new HashMap<ComponentAuthorizationSelector, AuthorizationPermissionSet>();
        if (!this.initialized) {
            this.log.warn((Object)"Error loading access group data from secure storage - not initializing component permissions to avoid erronous deletion");
            return resultMap;
        }
        try {
            authNode = this.getAuthorizationDataJsonNode();
        }
        catch (OperationFailureException e) {
            this.log.warn((Object)("Error loading persisted component permissions from secure storage (disabling further write operations to prevent accidental deletion): " + e.toString()));
            this.initialized = false;
            return resultMap;
        }
        Iterator i = authNode.fields();
        int count = 0;
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String id = (String)entry.getKey();
            String permSetSignature = ((JsonNode)entry.getValue()).asText();
            this.restorePersistedAssignment(id, permSetSignature, resultMap);
            ++count;
        }
        this.log.debug((Object)("Restored " + count + " persisted component-group assignment(s)"));
        return resultMap;
    }

    private void restorePersistedAssignment(String id, String permSetSignature, Map<ComponentAuthorizationSelector, AuthorizationPermissionSet> resultMap) {
        AuthorizationPermissionSet restoredPermSet;
        if (permSetSignature == null || permSetSignature.length() == 0) {
            this.log.error((Object)("Ignoring invalid (empty) stored permission data for component selector " + id));
            return;
        }
        if (this.permissionSetPublicAccessSignature.equals(permSetSignature)) {
            restoredPermSet = this.permissionSetPublicAccess;
        } else {
            ArrayList<AuthorizationAccessGroup> groups = new ArrayList<AuthorizationAccessGroup>();
            String[] stringArray = permSetSignature.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                try {
                    groups.add(this.authorizationService.representRemoteGroupId(part.trim()));
                }
                catch (OperationFailureException e) {
                    this.log.error((Object)("Ignoring invalid stored group id " + part + " for component " + id + "; reason: " + e.getMessage()));
                }
                ++n2;
            }
            restoredPermSet = this.authorizationService.buildPermissionSet(groups);
        }
        if (!restoredPermSet.isLocalOnly()) {
            resultMap.put(new ComponentAuthorizationSelectorImpl(id), restoredPermSet);
            this.log.debug((Object)("Restored permission set " + restoredPermSet.getSignature() + " for component selector " + id));
        }
    }

    private ObjectNode getAuthorizationDataJsonNode() throws OperationFailureException {
        JsonNode authNode = this.currentJsonData.get(AUTHORIZATION_JSON_NODE_PATH);
        if (authNode == null || authNode.isNull()) {
            authNode = this.jsonMapper.createObjectNode();
            ((ObjectNode)this.currentJsonData).set(AUTHORIZATION_JSON_NODE_PATH, authNode);
        }
        if (!(authNode instanceof ObjectNode)) {
            throw new OperationFailureException("Unexpected data node type at path: authorization");
        }
        return (ObjectNode)authNode;
    }
}

