/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.internal;

import de.rcenvironment.core.component.api.DistributedNodeComponentKnowledge;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class DistributedNodeComponentKnowledgeImpl
implements DistributedNodeComponentKnowledge {
    private Map<String, DistributedComponentEntry> accessibleComponents;
    private Map<String, DistributedComponentEntry> inaccessibleComponents;

    private DistributedNodeComponentKnowledgeImpl(Map<String, DistributedComponentEntry> accessibleComponentsParam, Map<String, DistributedComponentEntry> inaccessibleComponentsParam) {
        this.accessibleComponents = new HashMap<String, DistributedComponentEntry>(accessibleComponentsParam);
        this.inaccessibleComponents = new HashMap<String, DistributedComponentEntry>(inaccessibleComponentsParam);
    }

    public static DistributedNodeComponentKnowledge createEmpty() {
        return new DistributedNodeComponentKnowledgeImpl(new HashMap<String, DistributedComponentEntry>(), new HashMap<String, DistributedComponentEntry>());
    }

    public static DistributedNodeComponentKnowledge fromMap(Map<String, DistributedComponentEntry> accessibleComponentsParam, Map<String, DistributedComponentEntry> inaccessibleComponentsParam) {
        return new DistributedNodeComponentKnowledgeImpl(accessibleComponentsParam, inaccessibleComponentsParam);
    }

    @Override
    public DistributedNodeComponentKnowledge putAccessibleComponent(String componentId, DistributedComponentEntry entry) {
        HashMap<String, DistributedComponentEntry> newInaccessibleComponents = new HashMap<String, DistributedComponentEntry>(this.inaccessibleComponents);
        if (newInaccessibleComponents.containsKey(componentId)) {
            newInaccessibleComponents.remove(componentId);
        }
        HashMap<String, DistributedComponentEntry> newAccessibleComponents = new HashMap<String, DistributedComponentEntry>(this.accessibleComponents);
        newAccessibleComponents.put(componentId, entry);
        return new DistributedNodeComponentKnowledgeImpl(newAccessibleComponents, newInaccessibleComponents);
    }

    @Override
    public DistributedNodeComponentKnowledge putInaccessibleComponent(String componentId, DistributedComponentEntry entry) {
        HashMap<String, DistributedComponentEntry> newAccessibleComponents = new HashMap<String, DistributedComponentEntry>(this.accessibleComponents);
        if (newAccessibleComponents.containsKey(componentId)) {
            newAccessibleComponents.remove(componentId);
        }
        HashMap<String, DistributedComponentEntry> newInaccessibleComponents = new HashMap<String, DistributedComponentEntry>(this.inaccessibleComponents);
        newInaccessibleComponents.put(componentId, entry);
        return new DistributedNodeComponentKnowledgeImpl(newAccessibleComponents, newInaccessibleComponents);
    }

    @Override
    public DistributedComponentEntry getAccessibleComponent(String componentId) {
        return this.accessibleComponents.get(componentId);
    }

    @Override
    public DistributedComponentEntry getInaccessibleComponent(String componentId) {
        return this.inaccessibleComponents.get(componentId);
    }

    @Override
    public DistributedNodeComponentKnowledge removeComponent(String componentId) {
        HashMap<String, DistributedComponentEntry> newAccessibleComponents = new HashMap<String, DistributedComponentEntry>(this.accessibleComponents);
        newAccessibleComponents.remove(componentId);
        HashMap<String, DistributedComponentEntry> newInaccessibleComponents = new HashMap<String, DistributedComponentEntry>(this.inaccessibleComponents);
        newInaccessibleComponents.remove(componentId);
        return new DistributedNodeComponentKnowledgeImpl(newAccessibleComponents, newInaccessibleComponents);
    }

    @Override
    public boolean isComponentAccessible(String componentId) {
        return this.accessibleComponents.containsKey(componentId);
    }

    @Override
    public boolean isComponentInaccessible(String componentId) {
        return this.inaccessibleComponents.containsKey(componentId);
    }

    @Override
    public Collection<DistributedComponentEntry> getComponents() {
        HashSet<DistributedComponentEntry> returnValue = new HashSet<DistributedComponentEntry>();
        returnValue.addAll(this.accessibleComponents.values());
        returnValue.addAll(this.inaccessibleComponents.values());
        return returnValue;
    }

    @Override
    public Collection<DistributedComponentEntry> getAccessibleComponents() {
        return new HashSet<DistributedComponentEntry>(this.accessibleComponents.values());
    }

    @Override
    public Collection<DistributedComponentEntry> getInaccessibleComponents() {
        return new HashSet<DistributedComponentEntry>(this.inaccessibleComponents.values());
    }

    @Override
    public Map<String, DistributedComponentEntry> getAccessibleComponentMap() {
        return new HashMap<String, DistributedComponentEntry>(this.accessibleComponents);
    }

    @Override
    public Map<String, DistributedComponentEntry> getInaccessibleComponentMap() {
        return new HashMap<String, DistributedComponentEntry>(this.inaccessibleComponents);
    }
}

