/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamodel.types.internal;

import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.internal.TypedDatumServiceImpl;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.datamodel.types.internal.AbstractTypedDatum;
import de.rcenvironment.core.datamodel.types.internal.MatrixTDImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.LogFactory;

public class VectorTDImpl
extends AbstractTypedDatum
implements VectorTD {
    private static final String COMMA = ",";
    private static final String OUT_OF_RANGE_ERROR_MESSAGE = "index out of range: ";
    private MatrixTD matrix;

    public VectorTDImpl(FloatTD[] vectorEntries) {
        super(DataType.Vector);
        this.matrix = new MatrixTDImpl(this.toTwoDimensionalArray(vectorEntries));
    }

    @Override
    public FloatTD getFloatTDOfElement(int rowIndex) {
        return this.matrix.getFloatTDOfElement(rowIndex, 0);
    }

    @Override
    public void setFloatTDForElement(FloatTD number, int rowIndex) {
        this.matrix.setFloatTDForElement(number, rowIndex, 0);
    }

    @Override
    public int getRowDimension() {
        return this.matrix.getRowDimension();
    }

    @Override
    public VectorTD getSubVector(int endRowIndex) {
        if (endRowIndex < 0 || endRowIndex >= this.getRowDimension()) {
            throw new IllegalArgumentException(OUT_OF_RANGE_ERROR_MESSAGE + endRowIndex);
        }
        TypedDatumConverter converter = new TypedDatumServiceImpl().getConverter();
        try {
            return converter.castOrConvert((TypedDatum)this.matrix.getSubMatrix(endRowIndex, 1), VectorTD.class);
        }
        catch (DataTypeException e) {
            LogFactory.getLog(this.getClass()).error((Object)"conversion failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public VectorTD getSubVector(int beginRowIndex, int endRowIndex) {
        if (beginRowIndex < 0 || beginRowIndex >= this.getRowDimension()) {
            throw new IllegalArgumentException(OUT_OF_RANGE_ERROR_MESSAGE + beginRowIndex);
        }
        if (endRowIndex < 0 || endRowIndex >= this.getRowDimension()) {
            throw new IllegalArgumentException(OUT_OF_RANGE_ERROR_MESSAGE + endRowIndex);
        }
        if (beginRowIndex > endRowIndex) {
            throw new IllegalArgumentException("begin index must lower than end index: " + beginRowIndex + " - " + endRowIndex);
        }
        TypedDatumConverter converter = new TypedDatumServiceImpl().getConverter();
        try {
            return converter.castOrConvert((TypedDatum)this.matrix.getSubMatrix(beginRowIndex, 0, endRowIndex, 1), VectorTD.class);
        }
        catch (DataTypeException e) {
            LogFactory.getLog(this.getClass()).error((Object)"conversion failed", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof VectorTD) {
            VectorTD other = (VectorTD)obj;
            return this.matrix.equals(new MatrixTDImpl(this.toTwoDimensionalArray(other.toArray())));
        }
        return false;
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    @Override
    public FloatTD[] toArray() {
        FloatTD[][] matrixEntries = this.matrix.toArray();
        FloatTD[] vectorEntries = new FloatTD[this.getRowDimension()];
        int i = 0;
        while (i < this.getRowDimension()) {
            vectorEntries[i] = matrixEntries[i][0];
            ++i;
        }
        return vectorEntries;
    }

    private FloatTD[][] toTwoDimensionalArray(FloatTD[] vector) {
        FloatTD[][] matrixEntries = new FloatTD[vector.length][1];
        int i = 0;
        while (i < vector.length) {
            matrixEntries[i][0] = vector[i];
            ++i;
        }
        return matrixEntries;
    }

    @Override
    public String toLengthLimitedString(int maxLength) {
        StringBuilder strBuilder = new StringBuilder("[");
        FloatTD[] floatTDArray = this.toArray();
        int n = floatTDArray.length;
        int n2 = 0;
        while (n2 < n) {
            FloatTD f = floatTDArray[n2];
            strBuilder.append(f.toString());
            strBuilder.append(COMMA);
            if (strBuilder.length() > maxLength) break;
            ++n2;
        }
        strBuilder.setLength(strBuilder.length() - 1);
        if (strBuilder.length() > maxLength) {
            strBuilder.setLength(maxLength);
            strBuilder.append("...");
        }
        strBuilder.append("]");
        strBuilder.append(StringUtils.format((String)" (%d-dim)", (Object[])new Object[]{this.getRowDimension()}));
        return strBuilder.toString();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        FloatTD[] floatTDArray = this.toArray();
        int n = floatTDArray.length;
        int n2 = 0;
        while (n2 < n) {
            FloatTD f = floatTDArray[n2];
            strBuilder.append(f.toString());
            strBuilder.append(", ");
            ++n2;
        }
        strBuilder.setLength(strBuilder.length() - 2);
        return strBuilder.toString();
    }
}

