/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ComponentExecutionException;
import de.rcenvironment.core.component.execution.api.ComponentExecutionIdentifier;
import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.EndpointDatumSerializer;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.execution.api.WorkflowGraphHop;
import de.rcenvironment.core.component.execution.api.WorkflowGraphNode;
import de.rcenvironment.core.component.execution.api.WorkflowGraphPath;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionPermitsService;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionRelatedInstances;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionStatsService;
import de.rcenvironment.core.component.execution.internal.ComponentExecutionUtils;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEvent;
import de.rcenvironment.core.component.execution.internal.ComponentStateMachineEventType;
import de.rcenvironment.core.component.execution.internal.InternalTDImpl;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.FinalComponentRunState;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComponentExecutor {
    protected static final int DEAFULT_WAIT_INTERVAL_AFTER_CANCELLED_MSEC = 60000;
    protected static final int DEAFULT_WAIT_INTERVAL_NOT_RUN_MSEC = 120000;
    protected static int waitIntervalAfterCacelledCalledMSec = 60000;
    protected static int waitIntervalNotRunMSec = 120000;
    private static final Log LOG = LogFactory.getLog(ComponentExecutor.class);
    private static TypedDatumService typedDatumService;
    private static ComponentExecutionPermitsService componentExecutionPermitService;
    private static EndpointDatumSerializer endpointDatumSerializer;
    private static ComponentExecutionStatsService compExeStatsService;
    private static boolean sendInputsProcessedToWfCtrl;
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final AsyncOrderedExecutionQueue executionQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    private ComponentExecutionRelatedInstances compExeRelatedInstances;
    private ComponentExecutionType compExeType;
    private boolean isVerificationRequired;
    private boolean treatAsRun;
    private boolean isTearDown;
    private boolean writesCompRunRelatedDataToDM;
    private AtomicReference<Future<Boolean>> aquirePermissionTask = new AtomicReference<Object>(null);
    private AtomicReference<Future<ComponentException>> executeTask = new AtomicReference<Object>(null);
    private AtomicBoolean isDone = new AtomicBoolean(false);
    private AtomicBoolean isCancelled = new AtomicBoolean(false);
    private CountDownLatch executionLatch = new CountDownLatch(1);
    private boolean executionPermissionAcquired = false;

    @Deprecated
    public ComponentExecutor() {
    }

    protected ComponentExecutor(ComponentExecutionRelatedInstances compExeRelatedInstances, ComponentExecutionType compExeType) {
        this.compExeRelatedInstances = compExeRelatedInstances;
        this.compExeType = compExeType;
        this.isVerificationRequired = ComponentExecutionUtils.isManualOutputVerificationRequired(compExeRelatedInstances.compExeCtx.getComponentDescription().getConfigurationDescription());
        this.writesCompRunRelatedDataToDM = this.treatAsRun = compExeType == ComponentExecutionType.StartAsRun || compExeType == ComponentExecutionType.ProcessInputs;
        this.isTearDown = compExeType == ComponentExecutionType.TearDown;
    }

    protected void executeByConsideringLimitations() throws ComponentException, ComponentExecutionException {
        this.acquireExecutionPermission();
        this.performExecutionAndReleasePermission();
    }

    protected void acquireExecutionPermission() {
        if (this.treatAsRun && !this.isCancelled.get()) {
            try {
                this.aquirePermissionTask.set(componentExecutionPermitService.acquire(this.compExeRelatedInstances.compExeCtx.getComponentDescription().getIdentifier(), this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier()));
                this.executionPermissionAcquired = this.aquirePermissionTask.get().get();
            }
            catch (CancellationException e) {
                if (this.isCancelled.get()) {
                    this.compExeRelatedInstances.compExeRelatedStates.isComponentCancelled.set(true);
                    return;
                }
                this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(this.compExeType.compStateMachineEventTypeOnFailure, e));
            }
            catch (InterruptedException | ExecutionException e) {
                this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(this.compExeType.compStateMachineEventTypeOnFailure, e));
            }
        }
    }

    protected void performExecutionAndReleasePermission() throws ComponentExecutionException, ComponentException {
        try {
            FinalComponentRunState finalState = FinalComponentRunState.FAILED;
            if (this.isCancelled.get()) {
                this.compExeRelatedInstances.compExeRelatedStates.isComponentCancelled.set(true);
                finalState = FinalComponentRunState.CANCELLED;
                return;
            }
            if (!this.isTearDown) {
                if (this.compExeType.compStateOnSuccess != null) {
                    this.compExeRelatedInstances.compStateMachine.postEvent(new ComponentStateMachineEvent(ComponentStateMachineEventType.RUNNING, this.compExeType.compStateOnSuccess));
                }
                if (this.treatAsRun) {
                    this.compExeRelatedInstances.compExeStorageBridge.addComponentExecution(this.compExeRelatedInstances.compExeCtx, this.compExeRelatedInstances.compExeRelatedStates.executionCount.get());
                    this.storeInputs();
                    compExeStatsService.addStatsAtComponentRunStart(this.compExeRelatedInstances.compExeCtx);
                }
            }
            try {
                try {
                    this.executeAsync();
                    this.awaitExecution();
                    finalState = this.compExeType.finalCompRunState == null ? FinalComponentRunState.FINISHED : this.compExeType.finalCompRunState;
                    if (this.compExeRelatedInstances.compExeRelatedStates.compHasSentConsoleRowLogMessages.get()) {
                        this.writesCompRunRelatedDataToDM = true;
                        this.prepareDmForComponentRunRelatedDataIfNeeded();
                    }
                }
                catch (ComponentException e) {
                    this.writesCompRunRelatedDataToDM = true;
                    this.prepareDmForComponentRunRelatedDataIfNeeded();
                    this.handleComponentExecutionFailure(e);
                    finalState = FinalComponentRunState.FAILED;
                    if (this.treatAsRun) {
                        compExeStatsService.addStatsAtComponentRunTermination(this.compExeRelatedInstances.compExeCtx);
                    }
                    if (this.treatAsRun && !this.compExeRelatedInstances.compExeScheduler.isLoopResetRequested() && !this.isVerificationRequired) {
                        this.finishExecutionFromDataManagementPerpective(finalState);
                    } else if (this.compExeType.equals((Object)ComponentExecutionType.Reset) && (this.compExeRelatedInstances.compExeStorageBridge.hasUnfinishedComponentExecution() || this.writesCompRunRelatedDataToDM)) {
                        this.finishExecutionFromDataManagementPerpective(finalState);
                    } else if (this.compExeType.equals((Object)ComponentExecutionType.CompleteVerification)) {
                        this.finishExecutionFromDataManagementPerpective(finalState);
                    } else if (this.writesCompRunRelatedDataToDM && !this.compExeRelatedInstances.compExeScheduler.isLoopResetRequested() && !this.compExeType.equals((Object)ComponentExecutionType.HandleVerificationToken) && !this.isVerificationRequired) {
                        this.finishExecutionFromDataManagementPerpective(finalState);
                    }
                    if (this.isCancelled.get()) {
                        this.compExeRelatedInstances.compExeRelatedStates.isComponentCancelled.set(true);
                    }
                    this.executeTask.set(null);
                }
            }
            finally {
                if (this.treatAsRun) {
                    compExeStatsService.addStatsAtComponentRunTermination(this.compExeRelatedInstances.compExeCtx);
                }
                if (this.treatAsRun && !this.compExeRelatedInstances.compExeScheduler.isLoopResetRequested() && !this.isVerificationRequired) {
                    this.finishExecutionFromDataManagementPerpective(finalState);
                } else if (this.compExeType.equals((Object)ComponentExecutionType.Reset) && (this.compExeRelatedInstances.compExeStorageBridge.hasUnfinishedComponentExecution() || this.writesCompRunRelatedDataToDM)) {
                    this.finishExecutionFromDataManagementPerpective(finalState);
                } else if (this.compExeType.equals((Object)ComponentExecutionType.CompleteVerification)) {
                    this.finishExecutionFromDataManagementPerpective(finalState);
                } else if (this.writesCompRunRelatedDataToDM && !this.compExeRelatedInstances.compExeScheduler.isLoopResetRequested() && !this.compExeType.equals((Object)ComponentExecutionType.HandleVerificationToken) && !this.isVerificationRequired) {
                    this.finishExecutionFromDataManagementPerpective(finalState);
                }
                if (this.isCancelled.get()) {
                    this.compExeRelatedInstances.compExeRelatedStates.isComponentCancelled.set(true);
                }
                this.executeTask.set(null);
            }
        }
        finally {
            if (this.executionPermissionAcquired) {
                componentExecutionPermitService.release(this.compExeRelatedInstances.compExeCtx.getComponentDescription().getIdentifier());
            }
        }
    }

    private void finishExecutionFromDataManagementPerpective(FinalComponentRunState finalState) throws ComponentExecutionException {
        this.compExeRelatedInstances.consoleRowsSender.sendLogFileWriteTriggerAsConsoleRow();
        this.compExeRelatedInstances.compExeStorageBridge.setComponentExecutionFinished(finalState);
    }

    private void awaitExecution() throws ComponentException {
        ComponentException exception = null;
        try {
            if (this.compExeType == ComponentExecutionType.StartAsInit || this.compExeType == ComponentExecutionType.StartAsRun || this.compExeType == ComponentExecutionType.ProcessInputs || this.compExeType == ComponentExecutionType.HandleVerificationToken) {
                try {
                    exception = this.executeTask.get().get();
                }
                catch (CancellationException cancellationException) {
                    LOG.debug((Object)StringUtils.format((String)"Task was cancelled that was executing '%s' of %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}));
                }
            } else {
                try {
                    exception = this.executeTask.get().get(waitIntervalNotRunMSec, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    this.executeTask.get().cancel(true);
                    exception = new ComponentException(StringUtils.format((String)"Task didn't terminate in time and is cancelled; it is executing '%s' of %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}), e);
                }
            }
        }
        catch (InterruptedException e) {
            this.executeTask.get().cancel(true);
            exception = new ComponentException(StringUtils.format((String)"Waiting for task to terminate was interrupted; it is cancelled now; it is executing '%s' of %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}), e);
        }
        catch (ExecutionException e) {
            exception = new ComponentException("Unexpected error during component execution", e.getCause());
        }
        try {
            if (!this.executionLatch.await(waitIntervalAfterCacelledCalledMSec, TimeUnit.MILLISECONDS)) {
                exception = new ComponentException(StringUtils.format((String)"Task didn't terminate in time after it was cancelled; it was executing '%s' of %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}));
            }
        }
        catch (InterruptedException interruptedException) {
            exception = new ComponentException(StringUtils.format((String)"Interrupted when waiting for the task that was executing '%s' of %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}));
        }
        this.isDone.set(true);
        if (exception != null) {
            throw exception;
        }
    }

    private void executeAsync() {
        this.executeTask.set(this.threadPool.submit((Callable)new Callable<ComponentException>(){

            @Override
            @TaskDescription(value="Execute component life-cycle method")
            public ComponentException call() throws Exception {
                try {
                    try {
                        ComponentExecutor.this.execute();
                    }
                    catch (ComponentException e) {
                        ComponentException componentException = e;
                        ComponentExecutor.this.executionLatch.countDown();
                        return componentException;
                    }
                    catch (RuntimeException e) {
                        ComponentException componentException = new ComponentException("Unexpected error during execution", e);
                        ComponentExecutor.this.executionLatch.countDown();
                        return componentException;
                    }
                }
                finally {
                    ComponentExecutor.this.executionLatch.countDown();
                }
                return null;
            }
        }));
    }

    protected void execute() throws ComponentException, ComponentExecutionException {
        block18: {
            if (this.compExeType == ComponentExecutionType.StartAsInit || this.compExeType == ComponentExecutionType.StartAsRun || this.compExeType == ComponentExecutionType.ProcessInputs) {
                try {
                    if (this.compExeType == ComponentExecutionType.ProcessInputs) {
                        this.compExeRelatedInstances.component.get().processInputs();
                        break block18;
                    }
                    this.compExeRelatedInstances.component.get().start();
                }
                catch (ComponentException | RuntimeException e) {
                    this.checkForThreadInterrupted();
                    if (!this.isDone.get()) {
                        this.callCompleteStartOrProcessInputsOnFailure();
                        throw e;
                    }
                    LOG.error((Object)StringUtils.format((String)"Ignored error in %s of %s as the task was already considered as done (most likely, it was interupted before): %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx), e.getMessage()}));
                }
            } else if (this.compExeType == ComponentExecutionType.Reset) {
                Component component = this.compExeRelatedInstances.component.get();
                if (component != null) {
                    component.reset();
                }
            } else if (this.compExeType == ComponentExecutionType.TearDown) {
                Component component = this.compExeRelatedInstances.component.get();
                if (component != null) {
                    component.tearDown(this.compExeType.finalCompStateAfterTearedDown);
                }
            } else if (this.compExeType == ComponentExecutionType.HandleVerificationToken) {
                Component component = this.compExeRelatedInstances.component.get();
                if (component != null) {
                    component.handleVerificationToken(this.compExeType.verificationToken);
                }
            } else if (this.compExeType == ComponentExecutionType.CompleteVerification) {
                Component component = this.compExeRelatedInstances.component.get();
                if (component != null) {
                    this.compExeRelatedInstances.component.get().completeStartOrProcessInputsAfterVerificationDone();
                }
            } else {
                throw new ComponentExecutionException("Given component execution type not supported: " + (Object)((Object)this.compExeType));
            }
        }
    }

    private void checkForThreadInterrupted() {
        if (Thread.interrupted()) {
            LOG.warn((Object)StringUtils.format((String)"Task (thread) was interrupted after executing '%s' of %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}));
        }
    }

    private void prepareDmForComponentRunRelatedDataIfNeeded() throws ComponentExecutionException {
        if (!this.compExeRelatedInstances.compExeStorageBridge.hasUnfinishedComponentExecution()) {
            if (this.isTearDown) {
                this.compExeRelatedInstances.compExeStorageBridge.addComponentExecution(this.compExeRelatedInstances.compExeCtx, -1);
            } else {
                this.compExeRelatedInstances.compExeStorageBridge.addComponentExecution(this.compExeRelatedInstances.compExeCtx, this.compExeRelatedInstances.compExeRelatedStates.executionCount.get());
            }
        }
    }

    private void handleComponentExecutionFailure(Exception e) throws ComponentException, ComponentExecutionException {
        String errId = LogUtils.logExceptionWithStacktraceAndAssignUniqueMarker((Log)LOG, (String)StringUtils.format((String)"Executing %s failed", (Object[])new Object[]{ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}), (Throwable)e);
        String errorConsoleRow = ComponentUtils.createErrorLogMessage(e, errId);
        this.compExeRelatedInstances.consoleRowsSender.sendLogMessageAsConsoleRow(ConsoleRow.Type.COMPONENT_ERROR, errorConsoleRow, this.compExeRelatedInstances.compExeRelatedStates.executionCount.get());
        WorkflowGraphNode loopDriver = this.compExeRelatedInstances.compExeCtx.getWorkflowGraph().getLoopDriver(new ComponentExecutionIdentifier(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier()));
        if (loopDriver == null || !loopDriver.isDrivingFaultTolerantLoop()) {
            throw new ComponentException(errId);
        }
        this.writeFailureOutputData();
    }

    private void writeFailureOutputData() throws ComponentExecutionException {
        Map<String, Set<WorkflowGraphPath>> hopsToTraverseOnFailure = this.compExeRelatedInstances.compExeCtx.getWorkflowGraph().getHopsToTraverseOnFailure(new ComponentExecutionIdentifier(this.compExeRelatedInstances.compExeCtx.getExecutionIdentifier()));
        for (String outputName : hopsToTraverseOnFailure.keySet()) {
            for (WorkflowGraphPath hops : hopsToTraverseOnFailure.get(outputName)) {
                WorkflowGraphHop firstHop = hops.poll();
                NotAValueTD notAValue = typedDatumService.getFactory().createNotAValue(UUID.randomUUID().toString(), NotAValueTD.Cause.Failure);
                Long outputDmId = this.compExeRelatedInstances.compExeStorageBridge.addOutput(outputName, typedDatumService.getSerializer().serialize((TypedDatum)notAValue));
                this.compExeRelatedInstances.compExeScheduler.addNotAValueDatumSent(notAValue.getIdentifier());
                InternalTDImpl failureDatum = new InternalTDImpl(InternalTDImpl.InternalTDType.FailureInLoop, notAValue.getIdentifier(), hops, String.valueOf(outputDmId));
                this.compExeRelatedInstances.typedDatumToOutputWriter.writeTypedDatumToOutputConsideringOnlyCertainInputs(outputName, (TypedDatum)failureDatum, firstHop.getTargetExecutionIdentifier().toString(), firstHop.getTargetInputName());
            }
        }
    }

    private void storeInputs() throws ComponentExecutionException {
        for (final Map.Entry<String, EndpointDatum> entry : this.compExeRelatedInstances.compCtxBridge.getEndpointDatumsForExecution().entrySet()) {
            if (entry.getValue().getDataManagementId() == null) continue;
            this.compExeRelatedInstances.compExeStorageBridge.addInput(entry.getKey(), entry.getValue().getDataManagementId());
            if (!sendInputsProcessedToWfCtrl) continue;
            this.executionQueue.enqueue(new Runnable(){

                @Override
                public void run() {
                    ((ComponentExecutor)ComponentExecutor.this).compExeRelatedInstances.wfExeCtrlBridgeDelegator.onInputProcessed(endpointDatumSerializer.serializeEndpointDatum((EndpointDatum)entry.getValue()));
                }
            });
        }
    }

    protected void onCancelled() {
        this.isCancelled.set(true);
        if (this.aquirePermissionTask.get() != null && !this.aquirePermissionTask.get().isDone()) {
            this.aquirePermissionTask.get().cancel(true);
        } else if (this.executeTask.get() != null && !this.executeTask.get().isDone()) {
            try {
                switch (this.compExeType) {
                    case StartAsInit: 
                    case StartAsRun: {
                        this.compExeRelatedInstances.component.get().onStartInterrupted(new ThreadHandler(this.executeTask.get()));
                        break;
                    }
                    case ProcessInputs: {
                        this.compExeRelatedInstances.component.get().onProcessInputsInterrupted(new ThreadHandler(this.executeTask.get()));
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.error((Object)StringUtils.format((String)"Failed to interrupt task that is executing '%s' of %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowLowerCase(this.compExeRelatedInstances.compExeCtx)}), (Throwable)e);
            }
        }
    }

    private void callCompleteStartOrProcessInputsOnFailure() {
        try {
            this.compExeRelatedInstances.component.get().completeStartOrProcessInputsAfterFailure();
        }
        catch (ComponentException | RuntimeException e) {
            LOG.error((Object)StringUtils.format((String)"Error in 'completeStartOrProcessInputsAfterFailure' after executing %s", (Object[])new Object[]{this.compExeType.name(), ComponentExecutionUtils.getStringWithInfoAboutComponentAndWorkflowUpperCase(this.compExeRelatedInstances.compExeCtx)}), (Throwable)e);
        }
    }

    protected void bindTypedDatumService(TypedDatumService newService) {
        typedDatumService = newService;
    }

    protected void bindComponentExecutionPermitsService(ComponentExecutionPermitsService newService) {
        componentExecutionPermitService = newService;
    }

    protected void bindEndpointDatumSerializer(EndpointDatumSerializer newService) {
        endpointDatumSerializer = newService;
    }

    protected void bindComponentExecutionStatsService(ComponentExecutionStatsService newService) {
        compExeStatsService = newService;
    }

    protected void bindConfigurationService(ConfigurationService newService) {
        sendInputsProcessedToWfCtrl = newService.getConfigurationSegment("general").getBoolean("enableDeprecatedInputTab", Boolean.valueOf(false));
    }

    protected static enum ComponentExecutionType {
        StartAsInit(ComponentState.STARTING, ComponentStateMachineEventType.START_FAILED),
        StartAsRun(ComponentState.STARTING, ComponentStateMachineEventType.START_FAILED),
        ProcessInputs(ComponentState.PROCESSING_INPUTS, ComponentStateMachineEventType.PROCESSING_INPUTS_FAILED),
        Reset(ComponentState.RESETTING),
        TearDown,
        HandleVerificationToken,
        CompleteVerification;

        private final ComponentState compStateOnSuccess;
        private final ComponentStateMachineEventType compStateMachineEventTypeOnFailure;
        private Component.FinalComponentState finalCompStateAfterTearedDown;
        private FinalComponentRunState finalCompRunState;
        private String verificationToken;

        private ComponentExecutionType() {
            this.compStateOnSuccess = null;
            this.compStateMachineEventTypeOnFailure = null;
        }

        private ComponentExecutionType(ComponentState compStateOnSuccess) {
            this.compStateOnSuccess = compStateOnSuccess;
            this.compStateMachineEventTypeOnFailure = null;
        }

        private ComponentExecutionType(ComponentState compStateOnSuccess, ComponentStateMachineEventType compStateMachineEventTypeOnFailure) {
            this.compStateOnSuccess = compStateOnSuccess;
            this.compStateMachineEventTypeOnFailure = compStateMachineEventTypeOnFailure;
        }

        protected void setFinalComponentStateAfterTearedDown(Component.FinalComponentState finalState) {
            this.finalCompStateAfterTearedDown = finalState;
        }

        protected void setFinalComponentStateAfterRun(FinalComponentRunState finalState) {
            this.finalCompRunState = finalState;
        }

        protected void setVerificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
        }
    }
}

