/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.utils.common.StringUtils;
import java.net.ProtocolException;
import javax.jms.JMSException;
import javax.jms.Session;

public class RequestResponseQueuesManager {
    private String c2bRequestQueue;
    private String c2bResponseQueue;
    private String b2cRequestQueue;
    private String b2cResponseQueue;

    public String initClientSide(Session initialSession) throws JMSException {
        this.c2bResponseQueue = initialSession.createTemporaryQueue().getQueueName();
        this.b2cRequestQueue = initialSession.createTemporaryQueue().getQueueName();
        return StringUtils.escapeAndConcat((String[])new String[]{this.c2bResponseQueue, this.b2cRequestQueue});
    }

    public String initServerSide(Session serverSession, String clientInfo) throws JMSException, ProtocolException {
        if (clientInfo == null) {
            throw new ProtocolException("The client side did not send the expected temporary queue information");
        }
        String[] clientTempQueues = StringUtils.splitAndUnescape((String)clientInfo);
        this.c2bResponseQueue = clientTempQueues[0];
        this.b2cRequestQueue = clientTempQueues[1];
        this.c2bRequestQueue = "requests/c2b/common";
        this.b2cResponseQueue = serverSession.createTemporaryQueue().getQueueName();
        return StringUtils.escapeAndConcat((String[])new String[]{this.c2bRequestQueue, this.b2cResponseQueue});
    }

    public void finishClientSide(String serverInfo) throws ProtocolException {
        if (serverInfo == null) {
            throw new ProtocolException("The server side did not send the expected temporary queue information");
        }
        String[] serverTempQueues = StringUtils.splitAndUnescape((String)serverInfo);
        this.c2bRequestQueue = serverTempQueues[0];
        this.b2cResponseQueue = serverTempQueues[1];
    }

    public String getC2BRequestQueue() {
        return this.c2bRequestQueue;
    }

    public String getC2BResponseQueue() {
        return this.c2bResponseQueue;
    }

    public String getB2CRequestQueue() {
        return this.b2cRequestQueue;
    }

    public String getB2CResponseQueue() {
        return this.b2cResponseQueue;
    }
}

