/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.embedded.ssh.api.TemporarySshAccount;
import de.rcenvironment.core.embedded.ssh.api.TemporarySshAccountControl;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountImpl;
import de.rcenvironment.core.embedded.ssh.internal.SshAccountRole;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.embedded.ssh.internal.TemporarySshAccountImpl;
import de.rcenvironment.core.utils.common.AuditLog;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.mindrot.jbcrypt.BCrypt;

public class SshAuthenticationManager
implements PasswordAuthenticator,
TemporarySshAccountControl,
PublickeyAuthenticator {
    private static final String REFUSAL_REASON_NO_SUCH_USER = "account not found or disabled";
    private static final String REFUSAL_REASON_AUTH_FAILURE = "auth failure";
    private static final String REFUSAL_REASON_UNDEFINED = "<undefined>";
    private static final String EVENT_LOG_KEY_CONNECTION_TYPE = "type";
    private static final String EVENT_LOG_KEY_REFUSAL_REASON = "reason";
    private static final String EVENT_LOG_VALUE_CONNECTION_TYPE = "ssh/uplink";
    private SshConfiguration configuration;
    private List<TemporarySshAccount> temporaryAccounts;
    private final Log log = LogFactory.getLog(this.getClass());

    public SshAuthenticationManager(SshConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean authenticate(String loginName, String passwordParam, ServerSession session) {
        boolean success = false;
        String refusalReason = REFUSAL_REASON_UNDEFINED;
        if (passwordParam == null || passwordParam.isEmpty()) {
            refusalReason = "empty password";
        } else if (loginName == null || loginName.isEmpty()) {
            refusalReason = "empty login name";
        } else if (loginName.startsWith("t_")) {
            refusalReason = "unsupported temp user";
        } else {
            SshAccount account = this.configuration.getAccountByName(loginName, false);
            if (account != null) {
                if (this.checkPassword(account, passwordParam)) {
                    success = true;
                } else {
                    refusalReason = REFUSAL_REASON_AUTH_FAILURE;
                }
            } else {
                refusalReason = REFUSAL_REASON_NO_SUCH_USER;
            }
        }
        this.writeAuditLogEntry(session, loginName, "password", success, refusalReason);
        return success;
    }

    public boolean authenticate(String loginName, PublicKey key, ServerSession session) {
        boolean success = false;
        String refusalReason = REFUSAL_REASON_UNDEFINED;
        SshAccount account = this.configuration.getAccountByName(loginName, false);
        if (account != null) {
            PublicKey knownKey = account.getPublicKeyObj();
            if (knownKey != null) {
                success = key.equals(knownKey);
            }
            if (!success) {
                refusalReason = REFUSAL_REASON_AUTH_FAILURE;
            }
        } else {
            refusalReason = REFUSAL_REASON_NO_SUCH_USER;
        }
        this.writeAuditLogEntry(session, loginName, "publickey", success, refusalReason);
        return success;
    }

    public boolean isAllowedToExecuteConsoleCommand(String username, String command) {
        boolean isAllowed = false;
        SshAccountRole userRole = this.getRoleForUser(username);
        try {
            if (userRole != null) {
                boolean commandIsOnWhitelist = command.matches(userRole.getAllowedCommandRegEx());
                boolean commandIsOnBlacklist = command.matches(userRole.getDisallowedCommandRegEx());
                if (commandIsOnWhitelist && !commandIsOnBlacklist) {
                    isAllowed = true;
                }
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.log.error((Object)("Could not verify if user " + username + " is allowed to execute command " + command + ". Probable cause: The allowed commands pattern is invalid."));
        }
        return isAllowed;
    }

    public boolean isAllowedToUseScpDestination(String username, String destination) {
        boolean isAllowed = false;
        TemporarySshAccount tempUser = this.getTemporaryAccountByName(username);
        if (tempUser != null) {
            isAllowed = destination != null && destination.startsWith(tempUser.getVirtualScpRootPath()) && !destination.contains("../") && !destination.contains("..\\");
        }
        return isAllowed;
    }

    public boolean isAllowedToOpenShell(String username) {
        return this.getRoleForUser(username).isAllowedToOpenShell();
    }

    public boolean isAllowedToUseUplink(String username) {
        return this.getRoleForUser(username).isAllowedToUseUplink();
    }

    @Deprecated
    public boolean isTemporaryAccountName(String username) {
        return this.getTemporaryAccountByName(username) != null;
    }

    private SshAccountRole getRoleForUser(String userName) {
        SshAccount user = this.configuration.getAccountByName(userName, true);
        SshAccountRole role = null;
        if (user != null) {
            role = this.configuration.getRoleByName(user.getRole());
        }
        return role;
    }

    public SshAccount getAccountByLoginName(String loginName, boolean allowDisabled) {
        return this.configuration.getAccountByName(loginName, allowDisabled);
    }

    public SortedMap<String, SshAccount> getStaticAccountsByLoginName() {
        TreeMap<String, SshAccount> result = new TreeMap<String, SshAccount>();
        for (SshAccountImpl a : this.configuration.getStaticAccounts()) {
            result.put(a.getLoginName(), a);
        }
        return result;
    }

    @Deprecated
    public TemporarySshAccount getTemporaryAccountByName(String name) {
        TemporarySshAccount result = null;
        if (this.temporaryAccounts != null) {
            for (TemporarySshAccount tempUser : this.temporaryAccounts) {
                if (!tempUser.getLoginName().equals(name)) continue;
                result = tempUser;
            }
        }
        return result;
    }

    @Deprecated
    public List<TemporarySshAccount> getTemporaryAccounts() {
        return this.temporaryAccounts;
    }

    @Deprecated
    public void setTemporaryAccounts(List<TemporarySshAccount> tempUsers) {
        this.temporaryAccounts = tempUsers;
    }

    @Override
    @Deprecated
    public TemporarySshAccount createTemporarySshAccount() {
        if (this.temporaryAccounts == null) {
            this.temporaryAccounts = new CopyOnWriteArrayList<TemporarySshAccount>();
        }
        TemporarySshAccountImpl tempAccount = new TemporarySshAccountImpl();
        String randomAccountNamePart = RandomStringUtils.randomAlphanumeric((int)6);
        String username = "t_" + randomAccountNamePart;
        tempAccount.setLoginName(username);
        tempAccount.setPassword(RandomStringUtils.randomAlphanumeric((int)6));
        tempAccount.setVirtualScpRootPath("/temp/" + username);
        try {
            tempAccount.setLocalScpRootPath(TempFileServiceAccess.getInstance().createManagedTempDir("temp-scp-" + randomAccountNamePart));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary SCP directory", e);
        }
        this.log.debug((Object)StringUtils.format((String)"Created temporary SCP account '%s' with virtual SCP path '%s' mapped to local path '%s'", (Object[])new Object[]{tempAccount.getLoginName(), tempAccount.getVirtualScpRootPath(), tempAccount.getLocalScpRootPath().getAbsolutePath()}));
        this.temporaryAccounts.add(tempAccount);
        return tempAccount;
    }

    @Override
    @Deprecated
    public void discardTemporarySshAccount(String name) {
        int i = 0;
        while (i < this.temporaryAccounts.size()) {
            TemporarySshAccount tempUser = this.temporaryAccounts.get(i);
            if (tempUser.getLoginName().equals(name)) {
                this.temporaryAccounts.remove(i);
            }
            ++i;
        }
    }

    private boolean checkPassword(SshAccount account, String password) {
        if (account.getPasswordHash() != null) {
            boolean result = BCrypt.checkpw((String)password, (String)account.getPasswordHash());
            this.log.debug((Object)StringUtils.format((String)"Used password hash to check login attempt for user \"%s\" - accepted = %s", (Object[])new Object[]{account.getLoginName(), result}));
            return result;
        }
        if (account.getPassword() != null) {
            boolean result = account.getPassword().equals(password);
            this.log.warn((Object)StringUtils.format((String)"Used clear-text password to check login attempt for user \"%s\" - accepted = %s", (Object[])new Object[]{account.getLoginName(), result}));
            return result;
        }
        this.log.error((Object)("Consistency error: SSH login attempt with a password for user \"" + account.getLoginName() + "\", but the local account has neither a clear-text nor a hashed password"));
        return false;
    }

    private void writeAuditLogEntry(ServerSession session, String usernameParam, String authMethod, boolean success, String refusalReason) {
        if (session == null) {
            if (!RuntimeDetection.isTestEnvironment()) {
                throw new IllegalStateException("SSH session is null while apparently not in a test context");
            }
            return;
        }
        String sshSessionLogId = Integer.toString(System.identityHashCode(session));
        InetSocketAddress remoteAddressAndPort = (InetSocketAddress)session.getRemoteAddress();
        AuditLog.LogEntry auditLogEntry = success ? AuditLog.newEntry((String)"connection.incoming.accept") : AuditLog.newEntry((String)"connection.incoming.refuse");
        auditLogEntry.set(EVENT_LOG_KEY_CONNECTION_TYPE, EVENT_LOG_VALUE_CONNECTION_TYPE).set("login_name", usernameParam).set("auth_method", authMethod).set("remote_ip", remoteAddressAndPort.getAddress().getHostAddress()).set("remote_port", remoteAddressAndPort.getPort()).set("server_port", this.configuration.getPort()).set("ssh_session_id", sshSessionLogId);
        if (!success) {
            auditLogEntry.set(EVENT_LOG_KEY_REFUSAL_REASON, refusalReason);
        }
        AuditLog.append((AuditLog.LogEntry)auditLogEntry);
    }
}

