/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.communication.uplink.relay.api.ServerSideUplinkSessionService;
import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.embedded.ssh.api.EmbeddedSshServerControl;
import de.rcenvironment.core.embedded.ssh.api.ScpContextManager;
import de.rcenvironment.core.embedded.ssh.internal.CustomSshCommandFactory;
import de.rcenvironment.core.embedded.ssh.internal.SshAuthenticationManager;
import de.rcenvironment.core.embedded.ssh.internal.SshConfiguration;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.AuditLog;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ShellFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class EmbeddedSshServerImpl
implements EmbeddedSshServerControl {
    private static final int DYNAMIC_ACCOUNT_FILE_MODIFICATION_CHECK_INTERVAL_MSEC = 10000;
    private static final String HOST_KEY_STORAGE_FILE_NAME = "ssh_host_key.dat";
    private static final String EVENT_LOG_KEY_CONNECTION_TYPE = "type";
    private static final String EVENT_LOG_VALUE_CONNECTION_TYPE = "ssh/uplink";
    private ConfigurationService configurationService;
    private CommandExecutionService commandExecutionService;
    private SshConfiguration sshConfiguration;
    private File hostKeyStorageDirectory;
    private ScpContextManager scpContextManager;
    private ServerSideUplinkSessionService uplinkSessionService;
    private SshServer sshd;
    private boolean sshServerEnabled = false;
    private boolean sshServerRunning = false;
    private final Map<String, String> announcedVersionEntries = new HashMap<String, String>();
    private final Set<Session> openSshSessions = Collections.synchronizedSet(new HashSet());
    private final Log logger = LogFactory.getLog(this.getClass());
    private Path dynamicAccountsFilePath;
    private AsyncTaskService asyncTaskService;
    private FileTime dynamicAccountsFileLastModified;

    @Activate
    public void activate() {
        this.asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
        if (!CommandLineArguments.isConfigurationShellRequested()) {
            ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("sshServer");
            try {
                this.sshConfiguration = new SshConfiguration(configurationSegment);
            }
            catch (ConfigurationException | IOException e) {
                this.sshConfiguration = new SshConfiguration();
                this.logger.error((Object)e.getMessage());
            }
            this.hostKeyStorageDirectory = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA);
            this.dynamicAccountsFilePath = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_CONFIGURATION_DATA).toPath().resolve("accounts.json");
            this.asyncTaskService.execute("Embedded SSH server startup", this::performStartup);
        }
    }

    public void applyMockConfigurationAndStart(SshConfiguration configuration, Path customAccountsFilePath, File hostKeyStorageDir, ServerSideUplinkSessionService serverSideUplinkSessionService) {
        this.sshConfiguration = configuration;
        this.dynamicAccountsFilePath = customAccountsFilePath;
        this.hostKeyStorageDirectory = hostKeyStorageDir;
        this.uplinkSessionService = serverSideUplinkSessionService;
        this.performStartup();
    }

    public boolean isRunning() {
        return this.sshServerRunning;
    }

    @Deactivate
    public void deactivate() {
        this.performShutdown();
    }

    @Override
    public synchronized void setAnnouncedVersionOrProperty(String key, String value) {
        this.announcedVersionEntries.put(key, value);
        if (this.sshServerEnabled) {
            this.updateServerBannerWithAnnouncementData(this.sshd);
        }
    }

    private synchronized void performStartup() {
        this.sshServerEnabled = this.getActivationSettingFromConfig(this.sshConfiguration);
        if (!this.sshServerEnabled) {
            this.logger.debug((Object)"Not running an SSH server as there is either no SSH configuration at all, or the \"enabled\" property is not \"true\", or the configuration data (including account settings) has errors");
            return;
        }
        this.sshd = this.createSSHServerAndApplySettings();
        SshAuthenticationManager authenticationManager = new SshAuthenticationManager(this.sshConfiguration);
        if (this.dynamicAccountsFilePath != null && Files.exists(this.dynamicAccountsFilePath, new LinkOption[0])) {
            try {
                this.dynamicAccountsFileLastModified = Files.getLastModifiedTime(this.dynamicAccountsFilePath, new LinkOption[0]);
                Map<String, ConfigurationSegment> sshAccounts = this.attemptToLoadDynamicAccountData();
                this.applyDynamicSshAccounts(sshAccounts);
            }
            catch (IOException e) {
                this.logger.error((Object)("Error loading account file " + this.dynamicAccountsFilePath + ": " + e.toString()));
            }
            this.initiateMonitoringOfDynamicAccountsFile(this.dynamicAccountsFileLastModified);
        } else {
            this.logger.debug((Object)"No custom account file found, using data from main configuration file");
        }
        this.writeStatusToAuditLog("accounts.initialized");
        this.sshd.setPasswordAuthenticator((PasswordAuthenticator)authenticationManager);
        this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)authenticationManager);
        this.sshd.setShellFactory((ShellFactory)new CustomSshCommandFactory(authenticationManager, this.scpContextManager, this.commandExecutionService, this.uplinkSessionService, this.sshConfiguration));
        this.sshd.setCommandFactory((CommandFactory)new CustomSshCommandFactory(authenticationManager, this.scpContextManager, this.commandExecutionService, this.uplinkSessionService, this.sshConfiguration));
        this.registerConnectionLifecycleListeners(this.sshd);
        try {
            this.sshd.start();
            this.logSuccessfulServerStartup();
            this.sshServerRunning = true;
        }
        catch (IOException e) {
            this.logger.error((Object)StringUtils.format((String)"Failed to start embedded SSH server on port %s (attempted to bind to IP address %s): %s", (Object[])new Object[]{this.sshConfiguration.getPort(), this.sshConfiguration.getHost(), e.toString()}));
        }
    }

    private void initiateMonitoringOfDynamicAccountsFile(FileTime lastModifiedTime) {
        this.asyncTaskService.scheduleAtFixedInterval("Check dynamic accounts file for modification", this::reloadDynamicAccountsFileIfModified, 10000L);
    }

    private synchronized void reloadDynamicAccountsFileIfModified() {
        try {
            FileTime newModifiedTime = Files.getLastModifiedTime(this.dynamicAccountsFilePath, new LinkOption[0]);
            if (newModifiedTime.equals(this.dynamicAccountsFileLastModified)) {
                return;
            }
            Map<String, ConfigurationSegment> sshAccounts = this.attemptToLoadDynamicAccountData();
            if (this.checkForPotentialConcurrentModification(newModifiedTime)) {
                return;
            }
            this.logger.debug((Object)("Detected modification of " + this.dynamicAccountsFilePath + ", reloading SSH account data"));
            this.applyDynamicSshAccounts(sshAccounts);
            this.writeStatusToAuditLog("accounts.updated");
            this.dynamicAccountsFileLastModified = newModifiedTime;
        }
        catch (IOException e) {
            this.logger.error((Object)("Error checking or reloading account file " + this.dynamicAccountsFilePath + ": " + e.toString()));
        }
    }

    private boolean checkForPotentialConcurrentModification(FileTime newModifiedTime) throws IOException {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            this.logger.error((Object)"Interrupted; most likely, the application is shutting down");
            return true;
        }
        if (!newModifiedTime.equals(Files.getLastModifiedTime(this.dynamicAccountsFilePath, new LinkOption[0]))) {
            this.logger.debug((Object)("It seems as if " + this.dynamicAccountsFilePath + " has been modified while it was being reloaded; postponing the reload"));
            return true;
        }
        return false;
    }

    private void applyDynamicSshAccounts(Map<String, ConfigurationSegment> sshAccounts) {
        if (!sshAccounts.isEmpty()) {
            this.logger.debug((Object)("Read " + sshAccounts.size() + " SSH account(s) from " + this.dynamicAccountsFilePath));
        } else {
            this.logger.debug((Object)("Read account configuration file " + this.dynamicAccountsFilePath + ", but it contained no SSH accounts; using SSH accounts from the main configuration file (if any)"));
        }
        this.sshConfiguration.applyDynamicSshAccountData(sshAccounts);
    }

    private Map<String, ConfigurationSegment> attemptToLoadDynamicAccountData() throws IOException {
        ConfigurationSegment data = this.configurationService.loadCustomConfigurationFile(this.dynamicAccountsFilePath);
        Map sshAccounts = data.listElements("ssh");
        return sshAccounts;
    }

    private SshServer createSSHServerAndApplySettings() {
        SshServer serverInstance = SshServer.setUpDefaultServer();
        this.updateServerBannerWithAnnouncementData(serverInstance);
        Path hostKeyFilePath = new File(this.hostKeyStorageDirectory, HOST_KEY_STORAGE_FILE_NAME).getAbsoluteFile().toPath();
        this.logger.debug((Object)("Using SSH server key storage " + hostKeyFilePath));
        serverInstance.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(hostKeyFilePath));
        serverInstance.setHost(this.sshConfiguration.getHost());
        serverInstance.setPort(this.sshConfiguration.getPort());
        this.logger.debug((Object)("Configuring SSH session idle timeout of " + this.sshConfiguration.getIdleTimeoutSeconds() + " seconds"));
        serverInstance.getProperties().put("idle-timeout", TimeUnit.SECONDS.toMillis(this.sshConfiguration.getIdleTimeoutSeconds().intValue()));
        return serverInstance;
    }

    private synchronized void performShutdown() {
        this.sshServerEnabled = false;
        this.sshServerRunning = false;
        if (this.sshd != null) {
            try {
                this.sshd.stop(true);
                AuditLog.append((AuditLog.LogEntry)AuditLog.newEntry((String)"serverport.close").set(EVENT_LOG_KEY_CONNECTION_TYPE, EVENT_LOG_VALUE_CONNECTION_TYPE).set("bind_ip", this.sshConfiguration.getHost()).set("port", this.sshConfiguration.getPort()));
                this.logger.debug((Object)"Embedded SSH server shut down");
            }
            catch (IOException e) {
                this.logger.error((Object)"Exception during shutdown of embedded SSH server", (Throwable)e);
            }
        }
    }

    private void updateServerBannerWithAnnouncementData(SshServer sshServer) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("RCE");
        for (Map.Entry<String, String> entry : this.announcedVersionEntries.entrySet()) {
            buffer.append(" ");
            buffer.append(entry.getKey());
            buffer.append("/");
            buffer.append(entry.getValue());
        }
        sshServer.getProperties().put("server-identification", buffer.toString());
    }

    private void registerConnectionLifecycleListeners(SshServer serverInstance) {
        serverInstance.addSessionListener(new SessionListener(){

            public void sessionEstablished(Session session) {
                if (!EmbeddedSshServerImpl.this.openSshSessions.add(session)) {
                    EmbeddedSshServerImpl.this.logger.error((Object)"SSH session registered more than once");
                }
                InetSocketAddress remoteAddressAndPort = (InetSocketAddress)session.getRemoteAddress();
                AuditLog.append((AuditLog.LogEntry)AuditLog.newEntry((String)"connection.incoming.open").set(EmbeddedSshServerImpl.EVENT_LOG_KEY_CONNECTION_TYPE, EmbeddedSshServerImpl.EVENT_LOG_VALUE_CONNECTION_TYPE).set("remote_ip", remoteAddressAndPort.getAddress().getHostAddress()).set("remote_port", remoteAddressAndPort.getPort()).set("server_port", EmbeddedSshServerImpl.this.sshConfiguration.getPort()).set("ssh_session_id", System.identityHashCode(session)));
            }
        });
        serverInstance.addChannelListener(new ChannelListener(){

            public void channelStateChanged(Channel channel, String hint) {
                if ("SSH_MSG_CHANNEL_EOF".equals(hint)) {
                    this.logConnectionShutdown(channel, "EOF");
                }
            }

            public void channelClosed(Channel channel, Throwable reason) {
                this.logConnectionShutdown(channel, "regular");
            }

            private void logConnectionShutdown(Channel channel, String closeTrigger) {
                Session session = channel.getSession();
                String sshSessionLogId = Integer.toString(System.identityHashCode(session));
                if (!EmbeddedSshServerImpl.this.openSshSessions.remove(session)) {
                    EmbeddedSshServerImpl.this.logger.debug((Object)("Received additional close event with trigger '" + closeTrigger + "' for SSH session " + sshSessionLogId));
                    return;
                }
                InetSocketAddress remoteAddressAndPort = (InetSocketAddress)session.getRemoteAddress();
                AuditLog.append((AuditLog.LogEntry)AuditLog.newEntry((String)"connection.incoming.close").set(EmbeddedSshServerImpl.EVENT_LOG_KEY_CONNECTION_TYPE, EmbeddedSshServerImpl.EVENT_LOG_VALUE_CONNECTION_TYPE).set("login_name", session.getUsername()).set("remote_ip", remoteAddressAndPort.getAddress().getHostAddress()).set("remote_port", remoteAddressAndPort.getPort()).set("server_port", EmbeddedSshServerImpl.this.sshConfiguration.getPort()).set("ssh_session_id", sshSessionLogId).set("close_trigger", closeTrigger));
            }
        });
    }

    private void logSuccessfulServerStartup() {
        AuditLog.append((AuditLog.LogEntry)AuditLog.newEntry((String)"serverport.open").set(EVENT_LOG_KEY_CONNECTION_TYPE, EVENT_LOG_VALUE_CONNECTION_TYPE).set("bind_ip", this.sshConfiguration.getHost()).set("port", this.sshConfiguration.getPort()));
        this.logger.info((Object)StringUtils.format((String)"SSH server started on port %s (bound to IP %s)", (Object[])new Object[]{this.sshConfiguration.getPort(), this.sshConfiguration.getHost()}));
    }

    private boolean getActivationSettingFromConfig(SshConfiguration currentConfig) {
        boolean result = false;
        if (currentConfig != null && currentConfig.isEnabled()) {
            result = currentConfig.validateConfiguration(this.logger);
        }
        return result;
    }

    @Reference
    protected void bindScpContextManager(ScpContextManager newInstance) {
        this.scpContextManager = newInstance;
    }

    @Reference
    protected void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    @Reference
    protected void bindCommandExecutionService(CommandExecutionService newInstance) {
        this.commandExecutionService = newInstance;
    }

    @Reference
    protected void bindServerSideUplinkSessionService(ServerSideUplinkSessionService newInstance) {
        this.uplinkSessionService = newInstance;
    }

    private void writeStatusToAuditLog(String eventType) {
        AuditLog.append((AuditLog.LogEntry)AuditLog.newEntry((String)eventType).set(EVENT_LOG_KEY_CONNECTION_TYPE, "ssh").set("number_of_accounts", this.sshConfiguration.getCurrentNumberOfAccouts()).set("origin", this.sshConfiguration.getAccountDataOriginInfo()));
    }
}

