/*
 * Decompiled with CFR 0.152.
 */
package cucumber.java.runtime.osgi;

import cucumber.api.osgi.Filter;
import cucumber.api.osgi.ServiceNotFoundException;
import cucumber.api.osgi.TimeoutException;
import cucumber.java.runtime.osgi.OsgiObjectFactoryBase;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OsgiObjectFactory
extends OsgiObjectFactoryBase {
    private BundleContext bundleContext;

    public OsgiObjectFactory(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    protected void prepareGlueInstance(Object instance) {
        this.injectFields(instance);
    }

    public void injectFields(Object target) {
        for (Class<?> targetClass = target.getClass(); targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            this.injectDeclaredFields(target, targetClass);
        }
    }

    private void injectDeclaredFields(Object target, Class<?> targetClass) {
        for (Field field : targetClass.getDeclaredFields()) {
            if (field.getAnnotation(Inject.class) == null) continue;
            this.injectField(target, targetClass, field);
        }
    }

    private void injectField(Object target, Class<?> targetClass, Field field) {
        Class<?> type = field.getType();
        long timeout = 500L;
        String filterString = "";
        Filter filter = field.getAnnotation(Filter.class);
        if (filter != null) {
            filterString = filter.value();
            if (filter.timeout() != 0L) {
                timeout = filter.timeout();
            }
        }
        BundleContext service = BundleContext.class == type ? this.bundleContext : this.getService(type, timeout, filterString);
        this.setField(target, field, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(Object target, Field field, Object service) {
        try {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            try {
                field.set(target, service);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object getService(Class<?> type, long timeout, String filter) {
        String serviceName = type.getName() + " " + filter;
        try {
            long tryUntil = System.currentTimeMillis() + timeout;
            Object service = null;
            while (service == null) {
                Collection serviceReferences = this.bundleContext.getServiceReferences(type, filter.isEmpty() ? null : filter);
                Iterator iterator = serviceReferences.iterator();
                if (iterator.hasNext()) {
                    Object serviceReference = iterator.next();
                    service = this.bundleContext.getService((ServiceReference)serviceReference);
                    break;
                }
                if (tryUntil < System.currentTimeMillis()) break;
                Thread.sleep(20L);
            }
            if (service == null) {
                throw new ServiceNotFoundException(serviceName);
            }
            return service;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InterruptedException e) {
            throw new TimeoutException(serviceName);
        }
    }
}

