/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.dialog;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Border;
import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.gui.Window;
import com.googlecode.lanterna.gui.component.Button;
import com.googlecode.lanterna.gui.component.EmptySpace;
import com.googlecode.lanterna.gui.component.Label;
import com.googlecode.lanterna.gui.component.Panel;
import com.googlecode.lanterna.gui.dialog.DialogButtons;
import com.googlecode.lanterna.gui.dialog.DialogResult;
import com.googlecode.lanterna.gui.layout.LayoutParameter;

public class MessageBox
extends Window {
    private DialogResult dialogResult = DialogResult.CANCEL;

    protected MessageBox(String title, String message, DialogButtons buttons) {
        super(title);
        Label messageBoxLabel = new Label(message);
        this.addComponent(messageBoxLabel, new LayoutParameter[0]);
        this.addEmptyLine();
        Button okButton = new Button("OK", new Action(){

            @Override
            public void doAction() {
                MessageBox.this.dialogResult = DialogResult.OK;
                MessageBox.this.close();
            }
        });
        Button cancelButton = new Button("Cancel", new Action(){

            @Override
            public void doAction() {
                MessageBox.this.dialogResult = DialogResult.CANCEL;
                MessageBox.this.close();
            }
        });
        Button yesButton = new Button("Yes", new Action(){

            @Override
            public void doAction() {
                MessageBox.this.dialogResult = DialogResult.YES;
                MessageBox.this.close();
            }
        });
        Button noButton = new Button("No", new Action(){

            @Override
            public void doAction() {
                MessageBox.this.dialogResult = DialogResult.NO;
                MessageBox.this.close();
            }
        });
        int labelWidth = messageBoxLabel.getPreferredSize().getColumns();
        if (buttons == DialogButtons.OK) {
            Panel buttonPanel = new Panel(new Border.Invisible(), Panel.Orientation.HORISONTAL);
            int leftPadding = 0;
            int buttonsWidth = okButton.getPreferredSize().getColumns();
            if (buttonsWidth < labelWidth) {
                leftPadding = (labelWidth - buttonsWidth) / 2;
            }
            if (leftPadding > 0) {
                buttonPanel.addComponent(new EmptySpace(leftPadding, 1), new LayoutParameter[0]);
            }
            buttonPanel.addComponent(okButton, new LayoutParameter[0]);
            this.addComponent(buttonPanel, new LayoutParameter[0]);
        } else if (buttons == DialogButtons.OK_CANCEL) {
            Panel buttonPanel = new Panel(new Border.Invisible(), Panel.Orientation.HORISONTAL);
            int leftPadding = 0;
            int buttonsWidth = okButton.getPreferredSize().getColumns() + cancelButton.getPreferredSize().getColumns() + 1;
            if (buttonsWidth < labelWidth) {
                leftPadding = (labelWidth - buttonsWidth) / 2;
            }
            if (leftPadding > 0) {
                buttonPanel.addComponent(new EmptySpace(leftPadding, 1), new LayoutParameter[0]);
            }
            buttonPanel.addComponent(okButton, new LayoutParameter[0]);
            buttonPanel.addComponent(cancelButton, new LayoutParameter[0]);
            this.addComponent(buttonPanel, new LayoutParameter[0]);
            this.setFocus(cancelButton);
        } else if (buttons == DialogButtons.YES_NO) {
            Panel buttonPanel = new Panel(new Border.Invisible(), Panel.Orientation.HORISONTAL);
            int leftPadding = 0;
            int buttonsWidth = yesButton.getPreferredSize().getColumns() + noButton.getPreferredSize().getColumns() + 1;
            if (buttonsWidth < labelWidth) {
                leftPadding = (labelWidth - buttonsWidth) / 2;
            }
            if (leftPadding > 0) {
                buttonPanel.addComponent(new EmptySpace(leftPadding, 1), new LayoutParameter[0]);
            }
            buttonPanel.addComponent(yesButton, new LayoutParameter[0]);
            buttonPanel.addComponent(noButton, new LayoutParameter[0]);
            this.addComponent(buttonPanel, new LayoutParameter[0]);
            this.setFocus(noButton);
        } else if (buttons == DialogButtons.YES_NO_CANCEL) {
            Panel buttonPanel = new Panel(new Border.Invisible(), Panel.Orientation.HORISONTAL);
            int leftPadding = 0;
            int buttonsWidth = yesButton.getPreferredSize().getColumns() + noButton.getPreferredSize().getColumns() + 1 + cancelButton.getPreferredSize().getColumns();
            if (buttonsWidth < labelWidth) {
                leftPadding = (labelWidth - buttonsWidth) / 2;
            }
            if (leftPadding > 0) {
                buttonPanel.addComponent(new EmptySpace(leftPadding, 1), new LayoutParameter[0]);
            }
            buttonPanel.addComponent(yesButton, new LayoutParameter[0]);
            buttonPanel.addComponent(noButton, new LayoutParameter[0]);
            buttonPanel.addComponent(cancelButton, new LayoutParameter[0]);
            this.addComponent(buttonPanel, new LayoutParameter[0]);
            this.setFocus(cancelButton);
        }
    }

    public static DialogResult showMessageBox(GUIScreen owner, String title, String message) {
        return MessageBox.showMessageBox(owner, title, message, DialogButtons.OK);
    }

    public static DialogResult showMessageBox(GUIScreen owner, String title, String message, DialogButtons buttons) {
        MessageBox messageBox = new MessageBox(title, message, buttons);
        owner.showWindow(messageBox, GUIScreen.Position.CENTER);
        return messageBox.dialogResult;
    }
}

