/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractInteractableComponent;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;

public class TextBox
extends AbstractInteractableComponent {
    private final int forceWidth;
    private String backend;
    private int editPosition;
    private int visibleLeftPosition;
    private int lastKnownWidth;
    private char fillCharacter;

    public TextBox() {
        this("");
    }

    public TextBox(String initialContent) {
        this(initialContent, 0);
    }

    public TextBox(String initialContent, int width) {
        if (initialContent == null) {
            initialContent = "";
        }
        if (width <= 0) {
            width = initialContent.length() > 10 ? initialContent.length() : 10;
        }
        this.forceWidth = width;
        this.backend = initialContent;
        this.editPosition = initialContent.length();
        this.visibleLeftPosition = 0;
        this.lastKnownWidth = 0;
        this.fillCharacter = (char)32;
    }

    public String getText() {
        return this.backend;
    }

    public void setText(String text) {
        this.backend = text;
        this.editPosition = this.backend.length();
        this.invalidate();
    }

    public void setEditPosition(int editPosition) {
        if (editPosition < 0) {
            editPosition = 0;
        }
        if (editPosition > this.backend.length()) {
            editPosition = this.backend.length();
        }
        this.editPosition = editPosition;
        this.invalidate();
    }

    public int getEditPosition() {
        return this.editPosition;
    }

    protected String prerenderTransformation(String textboxString) {
        return textboxString;
    }

    public char getFillCharacter() {
        return this.fillCharacter;
    }

    public void setFillCharacter(char fillCharacter) {
        this.fillCharacter = fillCharacter;
    }

    @Override
    public void repaint(TextGraphics graphics) {
        if (this.hasFocus()) {
            graphics.applyTheme(Theme.Category.TEXTBOX_FOCUSED);
        } else {
            graphics.applyTheme(Theme.Category.TEXTBOX);
        }
        if (this.visibleLeftPosition >= this.backend.length()) {
            this.visibleLeftPosition = this.backend.length() - 1;
            if (this.visibleLeftPosition < 0) {
                this.visibleLeftPosition = 0;
            }
        }
        graphics.fillArea(this.fillCharacter);
        String displayString = this.prerenderTransformation(this.backend).substring(this.visibleLeftPosition);
        if (displayString.length() > graphics.getWidth()) {
            displayString = displayString.substring(0, graphics.getWidth() - 1);
        }
        graphics.drawString(0, 0, displayString, new ScreenCharacterStyle[0]);
        this.setHotspot(graphics.translateToGlobalCoordinates(new TerminalPosition(this.editPosition - this.visibleLeftPosition, 0)));
        this.lastKnownWidth = graphics.getWidth();
    }

    @Override
    protected TerminalSize calculatePreferredSize() {
        return new TerminalSize(this.forceWidth, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable.Result keyboardInteraction(Key key) {
        try {
            switch (key.getKind()) {
                case Tab: 
                case Enter: {
                    Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_RIGHT;
                    return result;
                }
                case ArrowDown: {
                    Interactable.Result result = Interactable.Result.NEXT_INTERACTABLE_DOWN;
                    return result;
                }
                case ReverseTab: {
                    Interactable.Result result = Interactable.Result.PREVIOUS_INTERACTABLE_LEFT;
                    return result;
                }
                case ArrowUp: {
                    Interactable.Result result = Interactable.Result.PREVIOUS_INTERACTABLE_UP;
                    return result;
                }
                case ArrowRight: {
                    if (this.editPosition == this.backend.length()) break;
                    ++this.editPosition;
                    if (this.editPosition - this.visibleLeftPosition < this.lastKnownWidth) break;
                    ++this.visibleLeftPosition;
                    break;
                }
                case ArrowLeft: {
                    if (this.editPosition == 0) break;
                    --this.editPosition;
                    if (this.editPosition - this.visibleLeftPosition >= 0) break;
                    --this.visibleLeftPosition;
                    break;
                }
                case End: {
                    this.editPosition = this.backend.length();
                    if (this.editPosition - this.visibleLeftPosition < this.lastKnownWidth) break;
                    this.visibleLeftPosition = this.editPosition - this.lastKnownWidth + 1;
                    break;
                }
                case Home: {
                    this.editPosition = 0;
                    this.visibleLeftPosition = 0;
                    break;
                }
                case Delete: {
                    if (this.editPosition == this.backend.length()) break;
                    this.backend = this.backend.substring(0, this.editPosition) + this.backend.substring(this.editPosition + 1);
                    break;
                }
                case Backspace: {
                    if (this.editPosition == 0) break;
                    --this.editPosition;
                    if (this.editPosition - this.visibleLeftPosition < 0) {
                        --this.visibleLeftPosition;
                    }
                    this.backend = this.backend.substring(0, this.editPosition) + this.backend.substring(this.editPosition + 1);
                    break;
                }
                case NormalKey: {
                    if (Character.isISOControl(key.getCharacter())) break;
                    this.backend = this.backend.substring(0, this.editPosition) + key.getCharacter() + this.backend.substring(this.editPosition);
                    ++this.editPosition;
                    if (this.editPosition - this.visibleLeftPosition < this.lastKnownWidth) break;
                    ++this.visibleLeftPosition;
                    break;
                }
                default: {
                    Interactable.Result result = Interactable.Result.EVENT_NOT_HANDLED;
                    return result;
                }
            }
            Interactable.Result result = Interactable.Result.EVENT_HANDLED;
            return result;
        }
        finally {
            this.invalidate();
        }
    }
}

