/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentState;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.LocalExecutionControllerUtilsService;
import de.rcenvironment.core.component.execution.api.WorkflowExecutionControllerCallbackService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionController;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.service.component.ComponentContext;

public class WorkflowExecutionControllerCallbackServiceImpl
implements WorkflowExecutionControllerCallbackService {
    private LocalExecutionControllerUtilsService exeWfCtrlUtilsService;
    private BundleContext bundleContext;

    @AllowRemoteAccess
    public void onComponentStateChanged(String executionId, String compExeId, ComponentState newState, Integer executionCount, String executionCountOnResets) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeWfCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).onComponentStateChanged(compExeId, newState, executionCount, executionCountOnResets);
    }

    @AllowRemoteAccess
    public void onComponentStateChanged(String executionId, String compExeId, ComponentState newState, Integer executionCount, String executionCountOnResets, String errorMessage) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeWfCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).onComponentStateChanged(compExeId, newState, executionCount, executionCountOnResets, errorMessage);
    }

    @AllowRemoteAccess
    public void onComponentStateChanged(String executionId, String compExeId, ComponentState newState, Integer executionCount, String executionCountOnResets, String errorId, String errorMessage) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeWfCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).onComponentStateChanged(compExeId, newState, executionCount, executionCountOnResets, errorId, errorMessage);
    }

    @AllowRemoteAccess
    public void onInputProcessed(String executionId, String serializedEndpointDatum) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeWfCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).onInputProcessed(serializedEndpointDatum);
    }

    @AllowRemoteAccess
    public void onComponentHeartbeatReceived(String executionId, String compExecutionId) throws ExecutionControllerException, RemoteOperationException {
        try {
            ((WorkflowExecutionController)this.exeWfCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).onComponentHeartbeatReceived(compExecutionId);
        }
        catch (ServiceException e) {
            LogFactory.getLog(this.getClass()).warn((Object)StringUtils.format((String)"Failed to send heart beat to workflow controller %s; it is not available (anymore): %s", (Object[])new Object[]{executionId, e.toString()}));
        }
    }

    @AllowRemoteAccess
    public void onConsoleRowsProcessed(String executionId, ConsoleRow[] consoleRows) throws ExecutionControllerException, RemoteOperationException {
        ((WorkflowExecutionController)this.exeWfCtrlUtilsService.getExecutionController(WorkflowExecutionController.class, executionId, this.bundleContext)).processConsoleRows(consoleRows);
    }

    protected void activate(ComponentContext osgiComponentContext) {
        this.bundleContext = osgiComponentContext.getBundleContext();
    }

    protected void bindLocalExecutionControllerUtilsService(LocalExecutionControllerUtilsService newService) {
        this.exeWfCtrlUtilsService = newService;
    }
}

