/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.gui.view;

import de.rcenvironment.components.parametricstudy.common.ParametricStudyService;
import de.rcenvironment.components.parametricstudy.gui.view.ChartConfigurationComposite;
import de.rcenvironment.components.parametricstudy.gui.view.ChartDataComposite;
import de.rcenvironment.components.parametricstudy.gui.view.Messages;
import de.rcenvironment.components.parametricstudy.gui.view.StudyDatastore;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentExecutionInformation;
import de.rcenvironment.core.gui.workflow.view.ComponentRuntimeView;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.part.ViewPart;

public class ParametricStudyView
extends ViewPart
implements ComponentRuntimeView,
ISelectionProvider {
    private ComponentExecutionInformation componentInstanceInformation;
    private TabFolder tabFolder;
    private ChartDataComposite dataComposite;
    private ChartConfigurationComposite configurationComposite;
    private boolean initialized = false;
    private final List<ISelectionChangedListener> selectionChangedListeners = new LinkedList<ISelectionChangedListener>();
    private ISelectionProvider selectionProvider;
    private StudyDatastore study;

    public void createPartControl(Composite parent) {
        this.tabFolder = new TabFolder(parent, 1024);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem tabItem = (TabItem)event.item;
                Control widget = tabItem.getControl();
                ISelectionProvider provider = null;
                if (widget instanceof ISelectionProvider) {
                    provider = (ISelectionProvider)widget;
                }
                ParametricStudyView.this.setSelectionProvider(provider);
            }
        });
        TabItem chartTabItem = new TabItem(this.tabFolder, 0, 0);
        chartTabItem.setText(Messages.chartTabText);
        chartTabItem.setToolTipText(Messages.chartTabToolTipText);
        this.configurationComposite = new ChartConfigurationComposite((Composite)this.tabFolder, 0);
        this.configurationComposite.createControls();
        chartTabItem.setControl((Control)this.configurationComposite);
        TabItem dataTabItem = new TabItem(this.tabFolder, 0, 1);
        dataTabItem.setText(Messages.dataTabText);
        dataTabItem.setToolTipText(Messages.dataTabToolTipText);
        this.dataComposite = new ChartDataComposite((Composite)this.tabFolder, 0);
        this.dataComposite.createControls();
        dataTabItem.setControl((Control)this.dataComposite);
        this.setSelectionProvider(this.dataComposite);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void dispose() {
        super.dispose();
        this.tabFolder.dispose();
        this.dataComposite.dispose();
        this.configurationComposite.dispose();
    }

    public void setFocus() {
        if (!this.initialized) {
            this.initialized = true;
            this.refresh();
        }
    }

    private void refresh() {
        if (this.componentInstanceInformation == null) {
            return;
        }
    }

    public void initializeData(ComponentExecutionInformation componentInstanceDescriptor) {
        this.componentInstanceInformation = componentInstanceDescriptor;
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        ParametricStudyService parametricStudyService = (ParametricStudyService)serviceRegistryAccess.getService(ParametricStudyService.class);
        this.study = StudyDatastore.connect(componentInstanceDescriptor.getExecutionIdentifier(), (ResolvableNodeId)componentInstanceDescriptor.getNodeId(), parametricStudyService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        List<ISelectionChangedListener> list = this.selectionChangedListeners;
        synchronized (list) {
            this.selectionChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        List<ISelectionChangedListener> list = this.selectionChangedListeners;
        synchronized (list) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        ISelection selection = null;
        if (this.selectionProvider != null) {
            selection = this.selectionProvider.getSelection();
        }
        return selection;
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectionProvider(ISelectionProvider selectionProvider) {
        List<ISelectionChangedListener> list = this.selectionChangedListeners;
        synchronized (list) {
            for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                this.selectionProvider.removeSelectionChangedListener(listener);
            }
            this.selectionProvider = selectionProvider;
            for (ISelectionChangedListener listener : this.selectionChangedListeners) {
                this.selectionProvider.addSelectionChangedListener(listener);
            }
        }
    }

    public void initializeView() {
        if (this.study != null && !this.dataComposite.isDisposed()) {
            this.dataComposite.setStudyDatastore(this.study);
            this.configurationComposite.setStudyDatastore(this.study);
        }
    }
}

