/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.execution.impl;

import de.rcenvironment.core.communication.uplink.client.execution.api.DataTransferUtils;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryDownloadReceiver;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadContext;
import de.rcenvironment.core.communication.uplink.client.execution.api.DirectoryUploadProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.FileDataSource;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionProvider;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionProviderEventCollector;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionRequest;
import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionResult;
import de.rcenvironment.core.communication.uplink.client.session.api.DestinationIdUtils;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.headless.internal.ExtendedHeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescriptionPersistenceHandler;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.InvalidFilenameException;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileService;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ToolExecutionProviderImpl
implements ToolExecutionProvider {
    private static final String DE_RCENVIRONMENT_SCPOUTPUTCOLLECTOR = "de.rcenvironment.scpoutputcollector/";
    private static final String DE_RCENVIRONMENT_SCPINPUTLOADER = "de.rcenvironment.scpinputloader/";
    private static final String KEY_DATA_TYPE = "dataType";
    private static final String KEY_META_DATA = "metaData";
    private static final int NUMBER_600 = 600;
    private static final int NUMBER_200 = 200;
    private static final int NUMBER_400 = 400;
    private ToolExecutionRequest request;
    private File tempDir;
    private File inputDir;
    private File outputDir;
    private File createdWorkflowFile;
    private WorkflowExecutionInformation wfExecInf;
    private DistributedComponentKnowledgeService componentKnowledgeService;
    private UserComponentIdMappingService userComponentIdMappingService;
    private HeadlessWorkflowExecutionService workflowExecutionService;
    private final TempFileService tempFileService = TempFileServiceAccess.getInstance();
    private final Log log = LogFactory.getLog(this.getClass());

    public ToolExecutionProviderImpl(ToolExecutionRequest request) {
        this.request = request;
        try {
            this.tempDir = this.tempFileService.createManagedTempDir();
            this.inputDir = new File(this.tempDir, "input");
            this.outputDir = new File(this.tempDir, "output");
        }
        catch (IOException iOException) {}
        this.componentKnowledgeService = (DistributedComponentKnowledgeService)ServiceRegistry.createAccessFor((Object)this).getService(DistributedComponentKnowledgeService.class);
        this.userComponentIdMappingService = (UserComponentIdMappingService)ServiceRegistry.createAccessFor((Object)this).getService(UserComponentIdMappingService.class);
        this.workflowExecutionService = (HeadlessWorkflowExecutionService)ServiceRegistry.createAccessFor((Object)this).getService(HeadlessWorkflowExecutionService.class);
    }

    @Override
    public DirectoryDownloadReceiver getInputDirectoryReceiver() {
        return new DirectoryDownloadReceiver(){

            @Override
            public void receiveDirectoryListing(List<String> relativePaths) throws IOException {
                DataTransferUtils.receiveDirectoryListing(relativePaths, ToolExecutionProviderImpl.this.inputDir);
            }

            @Override
            public void receiveFile(FileDataSource dataSource) throws IOException {
                DataTransferUtils.receiveFile(dataSource, ToolExecutionProviderImpl.this.inputDir);
            }
        };
    }

    @Override
    public ToolExecutionResult execute(ToolExecutionProviderEventCollector eventCollector) throws OperationFailureException {
        this.prepareWorkflowFile();
        FinalWorkflowState state = this.executeConfiguredWorkflow(eventCollector);
        ToolExecutionResult result = new ToolExecutionResult();
        result.successful = state.equals((Object)FinalWorkflowState.FINISHED);
        result.cancelled = state.equals((Object)FinalWorkflowState.CANCELLED);
        return result;
    }

    @Override
    public void requestCancel() {
        if (this.wfExecInf != null) {
            try {
                this.workflowExecutionService.cancel(this.wfExecInf.getWorkflowExecutionHandle());
            }
            catch (ExecutionControllerException | RemoteOperationException e) {
                this.log.warn((Object)StringUtils.format((String)"Failed to cancel workflow '%s'; cause: %s", (Object[])new Object[]{this.wfExecInf.getExecutionIdentifier(), e.getMessage()}));
            }
        } else {
            this.log.debug((Object)"Failed to cancel workflow; it was not running or already finished.");
        }
    }

    @Override
    public DirectoryUploadProvider getOutputDirectoryProvider() {
        return new DirectoryUploadProvider(){

            @Override
            public List<String> provideDirectoryListing() throws IOException {
                ArrayList<String> listOfDirs = new ArrayList<String>();
                DataTransferUtils.getDirectoryListing(ToolExecutionProviderImpl.this.outputDir, listOfDirs, "");
                return listOfDirs;
            }

            @Override
            public void provideFiles(DirectoryUploadContext uploadContext) throws IOException {
                DataTransferUtils.uploadDirectory(ToolExecutionProviderImpl.this.outputDir, uploadContext, "");
                ToolExecutionProviderImpl.this.cleanupTempFiles();
            }
        };
    }

    @Override
    public void onContextClosing() {
        this.cleanupTempFiles();
    }

    private void cleanupTempFiles() {
        try {
            this.tempFileService.disposeManagedTempDirOrFile(this.createdWorkflowFile);
            this.tempFileService.disposeManagedTempDirOrFile(this.tempDir);
        }
        catch (IOException iOException) {
            this.log.warn((Object)"Could not delete temporary files");
        }
    }

    private void prepareWorkflowFile() throws OperationFailureException {
        Map metaData;
        DataType type;
        String identifier;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        String timestampString = dateFormat.format(new Date());
        WorkflowDescription workflowDesc = new WorkflowDescription(UUID.randomUUID().toString());
        workflowDesc.setWorkflowVersion(Integer.valueOf(5));
        workflowDesc.setName("Remote_Tool_Access-" + timestampString + "-" + this.request.getToolId());
        String internalToolId = this.userComponentIdMappingService.fromExternalToInternalId(this.request.getToolId());
        DistributedComponentEntry matchingComponentEntry = this.getMatchingComponentInstallationForTool(internalToolId, this.request.getToolVersion(), DestinationIdUtils.getNodeIdFromQualifiedDestinationId(this.request.getDestinationId()));
        WorkflowNode tool = new WorkflowNode(new ComponentDescription(matchingComponentEntry.getComponentInstallation()));
        WorkflowNode inputloader = new WorkflowNode(new ComponentDescription(this.getInputLoaderComponentInstallation()));
        WorkflowNode outputcollector = new WorkflowNode(new ComponentDescription(this.getOutputCollectorComponentInstallation()));
        tool.setName(this.request.getToolId());
        tool.setLocation(400, 200);
        inputloader.setName("Scp Input Loader");
        inputloader.getConfigurationDescription().setConfigurationValue("UploadDirectory", this.inputDir.getAbsolutePath());
        inputloader.getConfigurationDescription().setConfigurationValue("UncompressedUpload", Boolean.toString(false));
        inputloader.getConfigurationDescription().setConfigurationValue("SimpleDescriptionFormat", Boolean.toString(false));
        inputloader.setLocation(200, 200);
        outputcollector.setName("Scp output collector");
        outputcollector.getConfigurationDescription().setConfigurationValue("DownloadDirectory", this.outputDir.getAbsolutePath());
        outputcollector.getConfigurationDescription().setConfigurationValue("UncompressedDownload", Boolean.toString(false));
        outputcollector.getConfigurationDescription().setConfigurationValue("SimpleDescriptionFormat", Boolean.toString(false));
        outputcollector.setLocation(600, 200);
        workflowDesc.addWorkflowNode(inputloader);
        workflowDesc.addWorkflowNode(tool);
        workflowDesc.addWorkflowNode(outputcollector);
        for (Map<String, Object> map : this.request.getDynamicInputs()) {
            String inputName = (String)map.get("name");
            identifier = (String)map.get("identifier");
            type = DataType.valueOf((String)((String)map.get(KEY_DATA_TYPE)));
            metaData = (Map)map.get(KEY_META_DATA);
            tool.getInputDescriptionsManager().addDynamicEndpointDescription(identifier, inputName, type, metaData);
        }
        for (Map<String, Object> map : this.request.getDynamicOutputs()) {
            String outputName = (String)map.get("name");
            identifier = (String)map.get("identifier");
            type = DataType.valueOf((String)((String)map.get(KEY_DATA_TYPE)));
            metaData = (Map)map.get(KEY_META_DATA);
            tool.getOutputDescriptionsManager().addDynamicEndpointDescription(identifier, outputName, type, metaData);
        }
        for (Map.Entry entry : this.request.getProperties().entrySet()) {
            tool.getConfigurationDescription().setConfigurationValue((String)entry.getKey(), (String)entry.getValue());
        }
        EndpointDescriptionsManager endpointDescriptionsManager = inputloader.getOutputDescriptionsManager();
        for (EndpointDescription inputDesc : tool.getInputDescriptionsManager().getEndpointDescriptions()) {
            String inputName = inputDesc.getName();
            DataType dataType = inputDesc.getDataType();
            EndpointDescription outputDesc = endpointDescriptionsManager.addDynamicEndpointDescription("default", inputName, dataType, new HashMap());
            Connection inputConnection = new Connection(inputloader, outputDesc, tool, inputDesc);
            workflowDesc.addConnection(inputConnection);
            if (!this.request.getNonRequiredInputs().contains(inputName)) continue;
            Map metaData2 = inputDesc.getMetaData();
            metaData2.put("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.NotRequired.toString());
            tool.getInputDescriptionsManager().editStaticEndpointDescription(inputName, dataType, metaData2);
            inputDesc.setMetaDataValue("inputExecutionConstraint_4aae3eea", EndpointDefinition.InputExecutionContraint.NotRequired.toString());
        }
        EndpointDescriptionsManager outputCollectorInputs = outputcollector.getInputDescriptionsManager();
        for (EndpointDescription outputDesc : tool.getOutputDescriptionsManager().getEndpointDescriptions()) {
            String inputName = outputDesc.getName();
            DataType dataType = outputDesc.getDataType();
            EndpointDescription inputDesc = outputCollectorInputs.addDynamicEndpointDescription("default", inputName, dataType, new HashMap());
            Connection outputConnection = new Connection(tool, outputDesc, outputcollector, inputDesc);
            workflowDesc.addConnection(outputConnection);
        }
        try {
            this.createdWorkflowFile = this.tempFileService.createTempFileFromPattern("rta-*.wf");
            WorkflowDescriptionPersistenceHandler persistenceHandler = new WorkflowDescriptionPersistenceHandler();
            ByteArrayOutputStream content = persistenceHandler.writeWorkflowDescriptionToStream(workflowDesc);
            FileUtils.writeByteArrayToFile((File)this.createdWorkflowFile, (byte[])content.toByteArray());
        }
        catch (IOException iOException) {}
    }

    private FinalWorkflowState executeConfiguredWorkflow(final ToolExecutionProviderEventCollector eventCollector) throws OperationFailureException {
        HeadlessWorkflowExecutionContextBuilder exeContextBuilder;
        File logDir;
        if (this.outputDir.isDirectory()) {
            this.renameAsOld(this.outputDir);
        }
        if ((logDir = new File(this.outputDir.getParent(), "logs")).isDirectory()) {
            this.renameAsOld(logDir);
        }
        logDir.mkdirs();
        try {
            exeContextBuilder = new HeadlessWorkflowExecutionContextBuilder(this.createdWorkflowFile, logDir);
            exeContextBuilder.setSingleConsoleRowsProcessor(new SingleConsoleRowsProcessor(){

                public void onConsoleRow(ConsoleRow consoleRow) {
                    if (!consoleRow.getType().equals((Object)ConsoleRow.Type.LIFE_CYCLE_EVENT)) {
                        eventCollector.submitEvent(consoleRow.getType().name(), consoleRow.getPayload());
                    }
                }
            });
            exeContextBuilder.setDeletionBehavior(HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected);
            exeContextBuilder.setDisposalBehavior(HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected);
        }
        catch (InvalidFilenameException invalidFilenameException) {
            throw new IllegalStateException();
        }
        WorkflowExecutionException executionException = null;
        FinalWorkflowState finalState = FinalWorkflowState.FAILED;
        try {
            ExtendedHeadlessWorkflowExecutionContext context = exeContextBuilder.buildExtended();
            this.wfExecInf = this.workflowExecutionService.startHeadlessWorkflowExecution((HeadlessWorkflowExecutionContext)context);
            finalState = this.workflowExecutionService.waitForWorkflowTerminationAndCleanup((HeadlessWorkflowExecutionContext)context);
        }
        catch (WorkflowExecutionException e) {
            executionException = e;
            File exceptionLogFile = new File(logDir, "error.log");
            try {
                FileUtils.writeStringToFile((File)exceptionLogFile, (String)("Workflow execution failed with an error: " + e.toString()));
            }
            catch (IOException iOException) {
                this.log.error((Object)("Failed to write exception log file " + exceptionLogFile.getAbsolutePath()));
            }
        }
        this.log.debug((Object)"Finished remote access workflow.");
        if (this.inputDir.isDirectory()) {
            File tempDestination = new File(this.inputDir.getParentFile(), "input.old." + System.currentTimeMillis());
            this.inputDir.renameTo(tempDestination);
            if (this.inputDir.isDirectory()) {
                this.log.warn((Object)("Tried to rename input directory " + this.inputDir.getAbsolutePath() + " to " + tempDestination.getAbsolutePath() + ", but it is still present"));
            }
        }
        if (executionException != null) {
            throw new OperationFailureException("Tool execution failed.", (Throwable)executionException);
        }
        return finalState;
    }

    private DistributedComponentEntry getMatchingComponentInstallationForTool(String toolId, String toolVersion, String toolNodeId) {
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        DistributedComponentEntry matchingComponent = null;
        for (DistributedComponentEntry entry : compKnowledge.getKnownSharedInstallations()) {
            if (!entry.getComponentInterface().getIdentifier().equals(toolId) || !entry.getComponentInterface().getVersion().equals(toolVersion) || !entry.getNodeId().equals(toolNodeId)) continue;
            matchingComponent = entry;
        }
        return matchingComponent;
    }

    private ComponentInstallation getInputLoaderComponentInstallation() {
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        ComponentInstallation component = null;
        for (DistributedComponentEntry entry : compKnowledge.getAllLocalInstallations()) {
            if (!entry.getComponentInterface().getIdentifierAndVersion().startsWith(DE_RCENVIRONMENT_SCPINPUTLOADER)) continue;
            component = entry.getComponentInstallation();
        }
        return component;
    }

    private ComponentInstallation getOutputCollectorComponentInstallation() {
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        ComponentInstallation component = null;
        for (DistributedComponentEntry entry : compKnowledge.getAllLocalInstallations()) {
            if (!entry.getComponentInterface().getIdentifierAndVersion().startsWith(DE_RCENVIRONMENT_SCPOUTPUTCOLLECTOR)) continue;
            component = entry.getComponentInstallation();
        }
        return component;
    }

    private void renameAsOld(File outputFilesDir) {
        File tempDestination = new File(outputFilesDir.getParentFile(), String.valueOf(outputFilesDir.getName()) + ".old." + System.currentTimeMillis());
        outputFilesDir.renameTo(tempDestination);
        if (outputFilesDir.isDirectory()) {
            this.log.warn((Object)("Tried to move directory " + outputFilesDir.getAbsolutePath() + " to " + tempDestination.getAbsolutePath() + ", but it is still present"));
        }
    }
}

