/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.execution.validator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputLocationList;
import de.rcenvironment.components.outputwriter.common.OutputWriterValidatorHelper;
import de.rcenvironment.components.outputwriter.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractComponentValidator;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class OutputWriterComponentValidator
extends AbstractComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.outputwriter";
    }

    protected List<ComponentValidationMessage> validateComponentSpecific(ComponentDescription componentDescription) {
        LinkedList<ComponentValidationMessage> messages = new LinkedList<ComponentValidationMessage>();
        String chooseAtStart = this.getProperty(componentDescription, "SelectRootOnWorkflowStart");
        if (!Boolean.parseBoolean(chooseAtStart) && this.getProperty(componentDescription, "SelectedRoot").isEmpty()) {
            ComponentValidationMessage noDirectory = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "SelectedRoot", Messages.noRootChosen, Messages.bind((String)Messages.noRootChosen, (Object)"SelectedRoot"));
            messages.add(noDirectory);
        }
        String outputLocString = this.getProperty(componentDescription, "outputLocations");
        ObjectMapper jsonMapper = JsonUtils.getDefaultObjectMapper();
        jsonMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        if (outputLocString == null) {
            outputLocString = "{}";
        }
        try {
            OutputLocationList outputList = (OutputLocationList)jsonMapper.readValue(outputLocString, OutputLocationList.class);
            ArrayList inputNamesHavingOutput = new ArrayList();
            for (OutputLocation out : outputList.getOutputLocations()) {
                inputNamesHavingOutput.addAll(out.getInputs());
                if (out.getInputs().isEmpty()) {
                    ComponentValidationMessage outputWithoutInput = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, out.getFilename(), Messages.noInputForOutput, Messages.bind((String)Messages.noInputForOutput, (Object)out.getFilename()));
                    messages.add(outputWithoutInput);
                }
                boolean connectedInputs = false;
                boolean unconnectedInputs = false;
                for (String inputName : out.getInputs()) {
                    boolean stillExists = false;
                    for (EndpointDescription ed : this.getInputs(componentDescription)) {
                        if (!ed.getName().equals(inputName)) continue;
                        stillExists = true;
                        if (ed.isConnected()) {
                            connectedInputs = true;
                            continue;
                        }
                        unconnectedInputs = true;
                    }
                    if (stillExists) continue;
                    ComponentValidationMessage missingInput = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, out.getFilename(), Messages.missingInput, Messages.bind((String)Messages.missingInput, (Object)out.getFilename(), (Object)inputName));
                    messages.add(missingInput);
                }
                if (connectedInputs && unconnectedInputs) {
                    ComponentValidationMessage connectedAndUnconnectedInputs = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, out.getFilename(), Messages.connectedAndUnconnectedInputs, Messages.bind((String)Messages.connectedAndUnconnectedInputs, (Object)out.getFilename()));
                    messages.add(connectedAndUnconnectedInputs);
                }
                String header = out.getHeader();
                ArrayList<String> knownPlaceholderList = new ArrayList<String>();
                knownPlaceholderList.add("[Linebreak]");
                knownPlaceholderList.add("[Timestamp]");
                knownPlaceholderList.add("[Execution count]");
                List unknownPlaceholderList = OutputWriterValidatorHelper.getValidationErrors((String)header);
                if (unknownPlaceholderList.size() != 0 && ((String)unknownPlaceholderList.get(0)).equals("Incomplete squared bracket term detected.")) {
                    this.setMessages("File header", out.getFilename(), Messages.syntaxError, messages);
                } else {
                    for (String placeholder : unknownPlaceholderList) {
                        this.setMessages(placeholder, out.getFilename(), Messages.unmatchedHeaderPlaceholder, messages);
                    }
                }
                String formatString = out.getFormatString();
                for (String input : out.getInputs()) {
                    String inputPlaceholder = "[" + input + "]";
                    if (knownPlaceholderList.contains(inputPlaceholder)) continue;
                    knownPlaceholderList.add(inputPlaceholder);
                }
                unknownPlaceholderList = OutputWriterValidatorHelper.getValidationErrors((String)formatString);
                if (unknownPlaceholderList.size() != 0 && ((String)unknownPlaceholderList.get(0)).equals("Incomplete squared bracket term detected.")) {
                    this.setMessages("Value(s) format", out.getFilename(), Messages.syntaxError, messages);
                } else {
                    for (String placeholder : unknownPlaceholderList) {
                        this.setMessages(placeholder, out.getFilename(), Messages.unmatchedFormatPlaceholder, messages);
                    }
                }
                for (EndpointDescription ed : this.getInputs(componentDescription)) {
                    if (ed.getDataType().equals((Object)DataType.FileReference) || ed.getDataType().equals((Object)DataType.DirectoryReference) || inputNamesHavingOutput.contains(ed.getName())) continue;
                    ComponentValidationMessage inputWithoutOutput = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, ed.getName(), Messages.noOutputForInput, Messages.bind((String)Messages.noOutputForInput, (Object)ed.getName()));
                    messages.add(inputWithoutOutput);
                }
            }
        }
        catch (IOException e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Could not validate OutputLocation configuration " + e.getMessage()));
        }
        return messages;
    }

    private void setMessages(String placeholder, String filename, String message, List<ComponentValidationMessage> messages) {
        ComponentValidationMessage unmatchedPlaceholder = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, placeholder, message, Messages.bind((String)message, (Object)filename, (Object)placeholder));
        messages.add(unmatchedPlaceholder);
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }
}

