/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.model.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;

public abstract class PropertiesChangeSupport {
    private transient PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(this);

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String property) {
        if (this.pcsDelegate.hasListeners(property)) {
            this.pcsDelegate.firePropertyChange(property, null, null);
        }
    }

    public void firePropertyChange(String property, Object newValue) {
        if (this.pcsDelegate.hasListeners(property)) {
            this.pcsDelegate.firePropertyChange(property, null, newValue);
        }
    }

    public void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.pcsDelegate.hasListeners(property)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, property, oldValue, newValue);
            PropertyChangeListener[] listeners = this.pcsDelegate.getPropertyChangeListeners();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof PropertyChangeListenerProxy) {
                    PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listeners[i];
                    if (proxy.getPropertyName().equals(property)) {
                        listeners[i].propertyChange(event);
                    }
                } else {
                    listeners[i].propertyChange(event);
                }
                ++i;
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.removePropertyChangeListener(listener);
    }

    protected PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcsDelegate.getPropertyChangeListeners();
    }
}

