/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator.xml;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.Assertions;
import java.util.List;
import org.dom4j.Node;

public final class XMLSupport {
    private static final String ERROR_PARAMETER_NULL = "The parameter \"%s\" must not be null or empty.";
    private static final String PARAMETER_ROOT_NODE = "rootNode";
    private static final String PARAMETER_XPATH_EXPRESSION = "xPathExpression";

    private XMLSupport() {
    }

    public static String getNodeStringValue(Node rootNode, String xPathExpression) {
        Assertions.isDefined(rootNode, StringUtils.format((String)ERROR_PARAMETER_NULL, (Object[])new Object[]{PARAMETER_ROOT_NODE}));
        Assertions.isDefined(xPathExpression, StringUtils.format((String)ERROR_PARAMETER_NULL, (Object[])new Object[]{PARAMETER_XPATH_EXPRESSION}));
        String nodeValue = "";
        Node node = rootNode.selectSingleNode(xPathExpression);
        if (node != null) {
            nodeValue = node.getStringValue();
        }
        return nodeValue;
    }

    public static Node selectNode(Node rootNode, String xPathExpression) {
        Assertions.isDefined(rootNode, StringUtils.format((String)ERROR_PARAMETER_NULL, (Object[])new Object[]{PARAMETER_ROOT_NODE}));
        Assertions.isDefined(xPathExpression, StringUtils.format((String)ERROR_PARAMETER_NULL, (Object[])new Object[]{PARAMETER_XPATH_EXPRESSION}));
        return rootNode.selectSingleNode(xPathExpression);
    }

    public static List<Node> selectNodes(Node rootNode, String xPathExpression) {
        Assertions.isDefined(rootNode, StringUtils.format((String)ERROR_PARAMETER_NULL, (Object[])new Object[]{PARAMETER_ROOT_NODE}));
        Assertions.isDefined(xPathExpression, StringUtils.format((String)ERROR_PARAMETER_NULL, (Object[])new Object[]{PARAMETER_XPATH_EXPRESSION}));
        return rootNode.selectNodes(xPathExpression);
    }
}

