/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.gui.workflow.execute.ColorPalette;
import de.rcenvironment.core.gui.workflow.execute.TargetNodeEditingSupport;
import de.rcenvironment.core.gui.workflow.execute.Updatable;
import de.rcenvironment.core.gui.workflow.execute.WorkflowPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;

public class WorkflowNodeTargetPlatformLabelProvider
extends StyledCellLabelProvider {
    private List<CCombo> comboList;
    private TargetNodeEditingSupport editingSupport;
    private WorkflowDescription workflowDescription;
    private Map<WorkflowNode, Image> images = new HashMap<WorkflowNode, Image>();
    private final Set<Resource> resources = new HashSet<Resource>();
    private Map<WorkflowNode, Boolean> nodesValid = new HashMap<WorkflowNode, Boolean>();
    private Map<WorkflowNode, Integer> nodeValueWithError = new HashMap<WorkflowNode, Integer>();
    private IWizard iWizard;
    private WorkflowPage page;
    private Updatable updater;

    public WorkflowNodeTargetPlatformLabelProvider(TargetNodeEditingSupport editingSupport, WorkflowDescription workflowDescription, IWizard iWizard) {
        this.editingSupport = editingSupport;
        this.workflowDescription = workflowDescription;
        this.comboList = new ArrayList<CCombo>();
        this.iWizard = iWizard;
    }

    public Image getImage(WorkflowNode workflowNode) {
        if (!this.images.containsKey(workflowNode)) {
            Image image = workflowNode.getComponentDescription().getIcon16();
            this.resources.add((Resource)image);
            this.images.put(workflowNode, image);
        }
        return this.images.get(workflowNode);
    }

    public void update(ViewerCell cell) {
        this.updater.updateInstanceColumn(cell);
    }

    void handleSelection(CCombo combo, WorkflowNode workflowNode) {
        WorkflowNodeIdentifier identifier = null;
        for (WorkflowNode node : this.workflowDescription.getWorkflowNodes()) {
            if (!node.getIdentifierAsObject().equals((Object)workflowNode.getIdentifierAsObject())) continue;
            identifier = node.getIdentifierAsObject();
        }
        WorkflowNode wfNode = this.workflowDescription.getWorkflowNode(identifier);
        this.editingSupport.setValue(wfNode, combo.getSelectionIndex());
        boolean exactMatch = this.editingSupport.isNodeExactMatchRegardingComponentVersion(wfNode);
        if (!exactMatch) {
            combo.setForeground(ColorPalette.getInstance().getWarningColor());
        } else {
            combo.setForeground(ColorPalette.getInstance().getBlackColor());
        }
        if (combo.getItemCount() <= 1 && exactMatch) {
            combo.setEnabled(false);
        }
        this.nodesValid.put(wfNode, exactMatch);
        this.page.prepareErrorStatement();
        if (this.iWizard.getContainer().getCurrentPage() != null) {
            this.iWizard.getContainer().updateButtons();
        }
    }

    void clearComboList() {
        for (CCombo combo : this.comboList) {
            TableEditor editor;
            if (combo.getData("EDITOR") instanceof TableEditor) {
                editor = (TableEditor)combo.getData("EDITOR");
                editor.dispose();
            } else {
                editor = (TreeEditor)combo.getData("EDITOR");
                editor.dispose();
            }
            combo.dispose();
        }
        this.comboList.clear();
    }

    public boolean areNodesValid() {
        return !this.nodesValid.values().contains(Boolean.FALSE);
    }

    public Map<WorkflowNode, Boolean> getNodesValidList() {
        return this.nodesValid;
    }

    public void disposeRescources() {
        for (Resource resource : this.resources) {
            if (resource instanceof Image) continue;
            resource.dispose();
        }
    }

    public List<CCombo> getComboList() {
        return this.comboList;
    }

    public IWizard getiWizard() {
        return this.iWizard;
    }

    public TargetNodeEditingSupport getEditingSupport() {
        return this.editingSupport;
    }

    public void setUpdater(Updatable updater) {
        this.updater = updater;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public WorkflowPage getPage() {
        return this.page;
    }

    public void setPage(WorkflowPage page) {
        this.page = page;
    }

    public WorkflowDescription getWorkflowDescription() {
        return this.workflowDescription;
    }
}

