/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.cluster.sge.internal;

import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import de.rcenvironment.core.utils.cluster.internal.AbstractClusterService;
import de.rcenvironment.core.utils.cluster.internal.ClusterJobInformationImpl;
import de.rcenvironment.core.utils.cluster.internal.ClusterJobTimesInformation;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SgeClusterService
extends AbstractClusterService {
    private static final int INDEX_JOBID = 0;
    private static final int INDEX_JOBNAME = 1;
    private static final int INDEX_USER = 2;
    private static final int INDEX_JOBSTATE = 3;
    private static final int INDEX_REMAININGTIME = 5;
    private static final int INDEX_QUEUETIME = 6;
    private static final int INDEX_STARTTIME = 6;
    private static final int SECTION_ACTIVE_JOBS = 0;
    private static final int SECTION_WAITING_JOBS = 1;
    private static final int SECTION_WAITING_JOBS_WITH_DEPENDENCIES = 2;
    private static final int SECTION_UNSCHEDULED_JOBS = 3;

    public SgeClusterService(SshSessionConfiguration sshConfiguration, Map<String, String> pathToQueuingSystemCommands) {
        super(sshConfiguration, pathToQueuingSystemCommands);
    }

    @Override
    public Set<ClusterJobInformation> fetchClusterJobInformation() throws IOException {
        this.ensureJschSessionEstablished();
        String stdout = this.executesCommand(this.jschSession, this.buildMainCommand("showq"), "~");
        Map<String, ClusterJobInformation> jobInformation = this.parseStdoutForClusterJobInformation(stdout);
        this.latestFetchedJobInformation = Collections.unmodifiableMap(jobInformation);
        this.latestFetch = new Date().getTime();
        return new HashSet<ClusterJobInformation>(jobInformation.values());
    }

    @Override
    public String cancelClusterJobs(List<String> jobIds) throws IOException {
        StringBuilder commandBuilder = new StringBuilder(this.buildMainCommand("qdel"));
        for (String jobId : jobIds) {
            commandBuilder.append(" ");
            commandBuilder.append(jobId);
        }
        this.ensureJschSessionEstablished();
        try {
            this.executesCommand(this.jschSession, commandBuilder.toString(), "~");
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
        return "";
    }

    protected Map<String, ClusterJobInformation> parseStdoutForClusterJobInformation(String stdout) {
        String[] lines;
        HashMap<String, ClusterJobInformation> jobInformation = new HashMap<String, ClusterJobInformation>();
        int section = 0;
        boolean inSection = false;
        boolean emptyRowPassed = false;
        String[] stringArray = lines = stdout.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] lineTokens = line.split("(\\s+)");
            if (inSection) {
                if (lineTokens.length <= 1) {
                    if (!emptyRowPassed) {
                        emptyRowPassed = true;
                    } else {
                        emptyRowPassed = false;
                        inSection = false;
                        ++section;
                    }
                } else {
                    ClusterJobInformation information = this.extractClusterJobInformation(lineTokens, section);
                    jobInformation.put(information.getJobId(), information);
                }
            } else {
                String[] stringArray2 = lineTokens;
                int n3 = lineTokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String attribute = stringArray2[n4];
                    if (attribute.matches("JOBID")) {
                        inSection = true;
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return jobInformation;
    }

    private ClusterJobInformation extractClusterJobInformation(String[] lineTokens, int section) {
        ClusterJobInformationImpl information = new ClusterJobInformationImpl();
        information.setJobId(lineTokens[0]);
        information.setJobName(lineTokens[1]);
        information.setUser(lineTokens[2]);
        information.setJobState(this.getClusterJobState(lineTokens[3]));
        information.setClusterJobTimesInformation(this.extractClusterJobTimesInformation(lineTokens, section));
        return information;
    }

    private ClusterJobInformation.ClusterJobState getClusterJobState(String stateToken) {
        try {
            return ClusterJobInformation.ClusterJobState.valueOf(stateToken);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ClusterJobInformation.ClusterJobState.Unknown;
        }
    }

    private ClusterJobTimesInformation extractClusterJobTimesInformation(String[] lineTokens, int section) {
        ClusterJobTimesInformation information = new ClusterJobTimesInformation();
        information.setJobId(lineTokens[0]);
        switch (section) {
            case 0: {
                information.setRemainingTime(lineTokens[5]);
                information.setStartTime(this.getTime(lineTokens, 6));
                break;
            }
            default: {
                information.setQueueTime(this.getTime(lineTokens, 6));
            }
        }
        return information;
    }

    private String getTime(String[] lineTokens, int startIndex) {
        StringBuilder strBuilder = new StringBuilder();
        int i = startIndex;
        while (i < lineTokens.length) {
            strBuilder.append(lineTokens[i]);
            strBuilder.append(" ");
            ++i;
        }
        return strBuilder.delete(strBuilder.length() - 1, strBuilder.length()).toString();
    }
}

