/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cluster.common;

import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;

public final class ClusterComponentConstants {
    public static final String CONFIG_KEY_QUEUINGSYSTEM = "queuingSystem";
    public static final String CONFIG_KEY_PATHTOQUEUINGSYSTEMCOMMANDS = "pathToQueuingSystemCommands";
    public static final String KEY_IS_SCRIPT_PROVIDED_WITHIN_INPUT_DIR = "isScriptProvided";
    public static final String INPUT_JOBCOUNT = "Job count";
    public static final String INPUT_JOBINPUTS = "Job inputs";
    public static final String OUTPUT_JOBOUTPUTS = "Job outputs";
    public static final String INPUT_SHAREDJOBINPUT = "Shared job input";
    public static final String CLUSTER_FETCHING_FAILED = "cluster fetching failed";
    public static final String COMPONENT_ID = "de.rcenvironment.cluster";
    public static final String[] COMPONENT_IDS = new String[]{"de.rcenvironment.cluster", "de.rcenvironment.components.cluster.execution.ClusterComponent_Cluster"};
    public static final String JOB_SCRIPT_NAME = "run_cluster_job.sh";

    private ClusterComponentConstants() {
    }

    public static Map<String, String> extractPathsToQueuingSystemCommands(String paths) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        String[] stringArray = paths.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] keyValue;
            String path = stringArray[n2];
            if (!path.isEmpty() && (keyValue = path.split("=")).length == 2) {
                pathMap.put(keyValue[0], keyValue[1]);
            }
            ++n2;
        }
        return pathMap;
    }

    public static String getCommandsPathsAsPropertyString(Map<String, String> paths) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> commandEntry : paths.entrySet()) {
            builder.append(StringUtils.format((String)"%s=%s;", (Object[])new Object[]{commandEntry.getKey(), commandEntry.getValue()}));
        }
        return builder.toString();
    }
}

