/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.core.search.SearchEngine;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.xsd.ui.internal.editor.search.IXSDTypesFilter;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListProvider;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class XSDTypesSearchListProvider
extends XSDSearchListProvider {
    protected IXSDTypesFilter builtInFilter;
    protected boolean supportFilter = true;
    private boolean showComplexTypes = true;

    public XSDTypesSearchListProvider(IFile currentFile, XSDSchema[] schemas) {
        super(currentFile, schemas);
    }

    public void populateComponentList(IComponentList list, SearchScope scope, IProgressMonitor pm) {
        XSDSchema schemaForSchema = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        Iterator i = schemaForSchema.getSimpleTypeIdMap().values().iterator();
        while (i.hasNext()) {
            XSDTypeDefinition td = (XSDTypeDefinition)i.next();
            if (this.builtInFilter != null && this.builtInFilter.shouldFilterOut(td)) continue;
            list.add((Object)td);
        }
        ArrayList visitedSchemas = new ArrayList();
        int i2 = 0;
        while (i2 < this.schemas.length) {
            XSDSchema schema = this.schemas[i2];
            QualifiedName kind = this.showComplexTypes ? IXSDSearchConstants.TYPE_META_NAME : IXSDSearchConstants.SIMPLE_TYPE_META_NAME;
            XSDSearchListProvider.ComponentCollectingXSDVisitor visitor = new XSDSearchListProvider.ComponentCollectingXSDVisitor(this, list, kind);
            visitor.visitSchema(schema, true);
            visitedSchemas.addAll(visitor.getVisitedSchemas());
            ++i2;
        }
        if (scope != null) {
            this.populateComponentListUsingSearch(list, scope, pm, this.createFileMap(visitedSchemas));
        }
    }

    private void populateComponentListUsingSearch(IComponentList list, SearchScope scope, IProgressMonitor pm, HashMap files) {
        SearchEngine searchEngine = new SearchEngine();
        XSDSearchListProvider.InternalSearchRequestor requestor = new XSDSearchListProvider.InternalSearchRequestor(this, list, files);
        if (this.showComplexTypes) {
            this.findMatches(searchEngine, requestor, scope, IXSDSearchConstants.COMPLEX_TYPE_META_NAME);
        }
        this.findMatches(searchEngine, requestor, scope, IXSDSearchConstants.SIMPLE_TYPE_META_NAME);
    }

    public void _populateComponentListQuick(IComponentList list, IProgressMonitor pm) {
    }

    public void turnBuiltInFilterOn(boolean option) {
        this.supportFilter = option;
    }

    public void setBuiltInFilter(IXSDTypesFilter filter) {
        this.builtInFilter = filter;
    }

    public void showComplexTypes(boolean show) {
        this.showComplexTypes = show;
    }
}

