/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.model.api;

import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.model.spi.PropertiesChangeSupport;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNodeIdentifier;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.UUID;
import java.util.regex.Pattern;

public class WorkflowNode
extends PropertiesChangeSupport
implements Serializable,
ComponentInstanceProperties,
Comparable<WorkflowNode> {
    public static final Pattern PROPERTIES_PATTERN = Pattern.compile("^properties\\.(.*)$");
    public static final String PROPERTY_COMMUNICATION_NODE = "de.rcenvironment.rce.component.workflow.CommunicationNode";
    public static final String PROPERTY_NODE_ATTRIBUTES = "de.rcenvironment.props.n";
    private static final int DEFAULT_X_Y = 0;
    private static final long serialVersionUID = -7495156467094187194L;
    private static final int INITIAL_ZINDEX = -1;
    private ComponentDescription compDesc;
    private WorkflowNodeIdentifier identifier;
    private String name;
    private int x;
    private int y;
    private int zIndex;
    private boolean isEnabled = true;
    private boolean valid = false;
    private boolean isChecked = false;
    private boolean init = false;

    public WorkflowNode(ComponentDescription componentDescription) {
        this.compDesc = componentDescription;
        this.identifier = new WorkflowNodeIdentifier(UUID.randomUUID().toString());
        this.x = 0;
        this.y = 0;
        this.zIndex = -1;
    }

    public String toString() {
        return this.compDesc.getIdentifier();
    }

    public ComponentDescription getComponentDescription() {
        return this.compDesc;
    }

    public void setComponentDescription(ComponentDescription cd) {
        this.compDesc = cd;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isImitiationModeActive() {
        return Boolean.valueOf(this.getConfigurationDescription().getConfigurationValue("isImitationMode"));
    }

    public boolean isImitationModeSupported() {
        return Boolean.valueOf(this.getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration().getValue("imitationModeSupported"));
    }

    public void setLocation(int newX, int newY) {
        this.x = newX;
        this.y = newY;
        this.firePropertyChange(PROPERTY_COMMUNICATION_NODE);
    }

    public void setEnabled(boolean newEnabled) {
        this.isEnabled = newEnabled;
        this.firePropertyChange(PROPERTY_NODE_ATTRIBUTES);
    }

    public void setImitiationModeActive(boolean isImitiationModeActive) {
        this.getConfigurationDescription().setConfigurationValue("isImitationMode", Boolean.toString(isImitiationModeActive));
        this.firePropertyChange(PROPERTY_NODE_ATTRIBUTES);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(PROPERTY_NODE_ATTRIBUTES);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public String getIdentifier() {
        return this.identifier.toString();
    }

    public WorkflowNodeIdentifier getIdentifierAsObject() {
        return this.identifier;
    }

    public boolean equals(Object other) {
        if (other instanceof WorkflowNode) {
            return this.identifier.equals(((WorkflowNode)other).identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public void setIdentifier(String newIdentifier) {
        this.identifier = new WorkflowNodeIdentifier(newIdentifier);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        this.getConfigurationDescription().addPropertyChangeListener(l);
        this.getInputDescriptionsManager().addPropertyChangeListener(l);
        this.getOutputDescriptionsManager().addPropertyChangeListener(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        this.getConfigurationDescription().removePropertyChangeListener(l);
        this.getInputDescriptionsManager().removePropertyChangeListener(l);
        this.getOutputDescriptionsManager().removePropertyChangeListener(l);
    }

    @Override
    public int compareTo(WorkflowNode o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public EndpointDescriptionsManager getInputDescriptionsManager() {
        return this.compDesc.getInputDescriptionsManager();
    }

    @Override
    public EndpointDescriptionsManager getOutputDescriptionsManager() {
        return this.compDesc.getOutputDescriptionsManager();
    }

    @Override
    public ConfigurationDescription getConfigurationDescription() {
        return this.compDesc.getConfigurationDescription();
    }

    @Override
    public String getComponentIdentifierWithVersion() {
        return this.getComponentDescription().getIdentifier();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int zIndexD) {
        this.zIndex = zIndexD;
    }
}

