/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.management.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.management.BenchmarkSubtask;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.LogFactory;

public class BenchmarkSubtaskImpl
implements BenchmarkSubtask {
    private static final int NO_DURATION_AVAILABLE_VALUE = -1;
    private final List<InstanceNodeSessionId> targetNodes;
    private final int numMessages;
    private final int requestSize;
    private final int responseSize;
    private final int responseDelay;
    private final int threadsPerTarget;
    private Map<InstanceNodeSessionId, NodeResultContainer> nodeResults;
    private long subtaskStartTime;
    private CountDownLatch subtaskRequestCountdown;

    public BenchmarkSubtaskImpl(List<InstanceNodeSessionId> targetNodes, int numMessages, int requestSize, int responseSize, int responseDelay, int threadsPerTarget) {
        this.targetNodes = Collections.unmodifiableList(targetNodes);
        this.numMessages = numMessages;
        this.requestSize = requestSize;
        this.responseSize = responseSize;
        this.responseDelay = responseDelay;
        this.threadsPerTarget = threadsPerTarget;
        this.nodeResults = Collections.synchronizedMap(new HashMap());
        for (InstanceNodeSessionId node : targetNodes) {
            this.nodeResults.put(node, new NodeResultContainer());
        }
        this.subtaskRequestCountdown = new CountDownLatch(numMessages * targetNodes.size());
    }

    @Override
    public List<InstanceNodeSessionId> getTargetNodes() {
        return this.targetNodes;
    }

    @Override
    public int getNumMessages() {
        return this.numMessages;
    }

    @Override
    public int getRequestSize() {
        return this.requestSize;
    }

    @Override
    public int getResponseSize() {
        return this.responseSize;
    }

    @Override
    public int getResponseDelay() {
        return this.responseDelay;
    }

    @Override
    public int getThreadsPerTarget() {
        return this.threadsPerTarget;
    }

    public String formatDescription() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (InstanceNodeSessionId node : this.targetNodes) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(node);
        }
        String targetDescr = builder.toString();
        return StringUtils.format((String)"target nodes: {%s}, requests per target: %d, request size: %d, response size: %d, response delay: %dms, threads per target: %d", (Object[])new Object[]{targetDescr, this.numMessages, this.requestSize, this.responseSize, this.responseDelay, this.threadsPerTarget});
    }

    public long getRemainingRequestCount() {
        return this.subtaskRequestCountdown.getCount();
    }

    public void awaitTermination() throws InterruptedException {
        this.subtaskRequestCountdown.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] formatResults() {
        String[] array = new String[this.targetNodes.size()];
        int i = 0;
        for (InstanceNodeSessionId targetNode : this.targetNodes) {
            NodeResultContainer resultContainer;
            NodeResultContainer nodeResultContainer = resultContainer = this.nodeResults.get(targetNode);
            synchronized (nodeResultContainer) {
                long timeToFinish = this.toMsec(resultContainer.getTotalDuration());
                long avgRawSuccessMsec = -1L;
                long avgActualSuccessMsec = -1L;
                if (resultContainer.getNumSuccess() > 0) {
                    avgRawSuccessMsec = this.toMsec(resultContainer.getTotalSuccessfulTime() / (long)resultContainer.getNumSuccess());
                    avgActualSuccessMsec = avgRawSuccessMsec - (long)this.responseDelay;
                }
                int numFailures = this.numMessages - resultContainer.getNumSuccess();
                array[i++] = StringUtils.format((String)"%s: Avg actual time: %d ms, Avg raw time: %d ms, Failures: %d, Total time: %d ms", (Object[])new Object[]{targetNode, avgActualSuccessMsec, avgRawSuccessMsec, numFailures, timeToFinish});
            }
        }
        return array;
    }

    private long toMsec(long duration) {
        return TimeUnit.MILLISECONDS.convert(duration, TimeUnit.NANOSECONDS);
    }

    void recordStartTime() {
        this.subtaskStartTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordSingleResult(InstanceNodeSessionId targetNode, long duration, RemoteOperationException error) {
        NodeResultContainer resultContainer;
        NodeResultContainer nodeResultContainer = resultContainer = this.nodeResults.get(targetNode);
        synchronized (nodeResultContainer) {
            resultContainer.setNumFinished(resultContainer.getNumFinished() + 1);
            resultContainer.setTotalTime(resultContainer.getTotalTime() + duration);
            if (error == null) {
                resultContainer.setNumSuccess(resultContainer.getNumSuccess() + 1);
                resultContainer.setTotalSuccessfulTime(resultContainer.getTotalSuccessfulTime() + duration);
            } else {
                LogFactory.getLog(this.getClass()).warn((Object)("Error on benchmark request: " + error.getMessage()));
                resultContainer.setTotalFailureTime(resultContainer.getTotalFailureTime() + duration);
            }
            if (resultContainer.getNumFinished() == this.numMessages) {
                resultContainer.setTotalDuration(System.nanoTime() - this.subtaskStartTime);
            }
        }
        this.subtaskRequestCountdown.countDown();
    }

    private class NodeResultContainer {
        private long totalTime;
        private int numSuccess;
        private int numFinished;
        private long totalDuration;
        private long totalSuccessfulTime;
        private long totalFailureTime;

        private NodeResultContainer() {
        }

        long getTotalTime() {
            return this.totalTime;
        }

        void setTotalTime(long totalTime) {
            this.totalTime = totalTime;
        }

        int getNumSuccess() {
            return this.numSuccess;
        }

        void setNumSuccess(int numSuccess) {
            this.numSuccess = numSuccess;
        }

        int getNumFinished() {
            return this.numFinished;
        }

        void setNumFinished(int numFinished) {
            this.numFinished = numFinished;
        }

        long getTotalDuration() {
            return this.totalDuration;
        }

        void setTotalDuration(long totalDuration) {
            this.totalDuration = totalDuration;
        }

        long getTotalSuccessfulTime() {
            return this.totalSuccessfulTime;
        }

        void setTotalSuccessfulTime(long totalSuccessfulTime) {
            this.totalSuccessfulTime = totalSuccessfulTime;
        }

        long getTotalFailureTime() {
            return this.totalFailureTime;
        }

        void setTotalFailureTime(long totalFailureTime) {
            this.totalFailureTime = totalFailureTime;
        }
    }
}

