/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cluster.execution.internal;

import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import de.rcenvironment.core.utils.cluster.ClusterJobStateChangeListener;
import java.util.concurrent.BlockingQueue;

public class ClusterJobFinishListener
implements ClusterJobStateChangeListener {
    private final BlockingQueue<String> synchronousQueue;

    public ClusterJobFinishListener(BlockingQueue<String> synchronousQueue) {
        this.synchronousQueue = synchronousQueue;
    }

    public boolean onClusterJobStateChanged(ClusterJobInformation.ClusterJobState state) {
        boolean continueListening = true;
        if (state == null) {
            try {
                this.synchronousQueue.put("cluster fetching failed");
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Waiting for job become completed failed", e);
            }
            continueListening = false;
        } else if (state.equals((Object)ClusterJobInformation.ClusterJobState.Completed) || state.equals((Object)ClusterJobInformation.ClusterJobState.Unknown)) {
            try {
                this.synchronousQueue.put(state.name());
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Waiting for job become completed failed", e);
            }
            continueListening = false;
        }
        return continueListening;
    }
}

