/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.gui.component.AbstractListBox;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;

public class ActionListBox
extends AbstractListBox {
    public ActionListBox() {
        this(null);
    }

    public ActionListBox(TerminalSize preferredSize) {
        super(preferredSize);
    }

    public void addAction(Action action) {
        this.addAction(action.toString(), action);
    }

    public void addAction(final String label, final Action action) {
        super.addItem(new Item(){

            @Override
            public String getTitle() {
                return label;
            }

            @Override
            public void doAction() {
                action.doAction();
            }
        });
    }

    @Override
    protected Interactable.Result unhandledKeyboardEvent(Key key) {
        if (key.getKind() == Key.Kind.Enter) {
            ((Item)this.getSelectedItem()).doAction();
            return Interactable.Result.EVENT_HANDLED;
        }
        return Interactable.Result.EVENT_NOT_HANDLED;
    }

    @Override
    protected String createItemString(int index) {
        return ((Item)this.getItemAt(index)).getTitle();
    }

    @Override
    public TerminalPosition getHotspot() {
        return null;
    }

    @Override
    protected Theme.Definition getListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.DIALOG_AREA);
    }

    @Override
    protected Theme.Definition getSelectedListItemThemeDefinition(Theme theme) {
        return theme.getDefinition(Theme.Category.TEXTBOX_FOCUSED);
    }

    private static interface Item {
        public String getTitle();

        public void doAction();
    }
}

