/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.impl;

import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.extras.testscriptrunner.definitions.common.AbstractStepDefinitionBase;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

public class WorkflowStepDefinitions
extends AbstractStepDefinitionBase {
    private static final String ESCAPED_DOUBLE_QUOTE = "\"";
    private static final String USE_REGEXP_MARKER = "the pattern ";
    private String lastWorkflowLogContent;
    private ManagedInstance lastWorkflowInitiatingInstance;

    public WorkflowStepDefinitions(TestScenarioExecutionContext executionContext) {
        super(executionContext);
    }

    @When(value="^executing (?:the )?workflow \"([^\"]*)\" on (?:instance )?\"([^\"]*)\"$")
    public void whenExecutingWorkflowOnInstance(String workflowName, String instanceId) throws Throwable {
        String wfLogFileContent;
        Path wfLogFile;
        Path logFilesDirectory;
        Path originalWfFileLocation;
        if (!workflowName.endsWith(".wf")) {
            workflowName = String.valueOf(workflowName) + ".wf";
        }
        if (!Files.isRegularFile(originalWfFileLocation = this.executionContext.getTestScriptLocation().toPath().resolve("workflows").resolve(workflowName), new LinkOption[0])) {
            throw new AssertionError((Object)("No workflow file found at expected location " + originalWfFileLocation));
        }
        File tempDir = TempFileServiceAccess.getInstance().createManagedTempDir("bdd-wf");
        Path wfFileLocation = tempDir.toPath().resolve(originalWfFileLocation.getFileName());
        Files.copy(originalWfFileLocation, wfFileLocation, new CopyOption[0]);
        ManagedInstance instance = this.resolveInstance(instanceId);
        this.printToCommandConsole("Executing workflow " + wfFileLocation.toString() + " on instance " + instanceId);
        String commandOutput = this.executeCommandOnInstance(instance, "wf run --delete never \"" + wfFileLocation.toString() + ESCAPED_DOUBLE_QUOTE, false);
        this.log.debug((Object)("'wf run' command output:\n" + commandOutput));
        instance.setLastCommandOutput(commandOutput);
        this.lastInstanceWithSingleCommandExecution = instance;
        Pattern logDirPattern = Pattern.compile("Loading: '.+'; log directory: (.+) \\(full path:");
        Matcher matcher = logDirPattern.matcher(commandOutput);
        if (!matcher.find()) {
            Assert.fail((String)("Log output directory pattern not found in 'wf run' command output; full output:\n" + commandOutput));
        }
        if (!Files.isDirectory(logFilesDirectory = Paths.get(matcher.group(1), new String[0]), new LinkOption[0])) {
            Assert.fail((String)("Found log output directory location '" + logFilesDirectory + "' in command output, but it does not point to an actual directory"));
        }
        if (!Files.isRegularFile(wfLogFile = logFilesDirectory.resolve("workflow.log"), new LinkOption[0])) {
            Assert.fail((String)("Found log output directory location '" + logFilesDirectory + "', but there is no workflow.log file inside"));
        }
        this.lastWorkflowLogContent = wfLogFileContent = FileUtils.readFileToString((File)wfLogFile.toFile());
        this.lastWorkflowInitiatingInstance = instance;
    }

    @Then(value="^the workflow log should (not )?contain (the pattern )?\"(.*)\"$")
    public void thenTheWorkflowLogShouldContain(String negationFlag, String useRegexpMarker, String substring) throws Throwable {
        if (this.lastWorkflowLogContent == null) {
            Assert.fail((String)"Test error: No workflow log present yet");
            return;
        }
        if (this.lastWorkflowLogContent.isEmpty()) {
            Assert.fail((String)"Test error: Workflow log was stored, but is empty");
        }
        this.assertPropertyOfTextOutput(this.lastWorkflowInitiatingInstance, negationFlag, useRegexpMarker, substring, this.lastWorkflowLogContent, "workflow log");
    }

    @Then(value="^the workflow should have reached the (\\w+) state$")
    public void theWorkflowShouldHaveReachedTheState(String state) throws Throwable {
        this.thenTheWorkflowLogShouldContain(null, null, "NEW_STATE:" + state);
    }

    @Then(value="^the workflow controller should have been \"([^\"]+)\"(?: using node id \"(\\w+)\")?$")
    public void theWorkflowControllerShouldHaveBeen(String nodeName, String nodeId) throws Throwable {
        this.thenTheWorkflowLogShouldContain(null, null, "Location of workflow controller: \"" + nodeName + ESCAPED_DOUBLE_QUOTE);
    }

    @Then(value="^workflow component \"([^\"]+)\" should have been run on \"([^\"]+)\"( via uplink)?(?: using node id \"(\\w+)\")?$")
    public void workflowComponentShouldHaveBeenRunOn(String compName, String nodeName, String uplinkFlag, String nodeId) throws Throwable {
        if (uplinkFlag != null) {
            ManagedInstance instance = this.resolveInstance(nodeName);
            nodeName = String.valueOf(nodeName) + " \\(via " + instance.getUplinkUserName() + "\\/" + nodeName + "\\)";
        }
        String regexp = "Location of workflow component \"" + compName + "\" [^:]+: \"" + nodeName + ESCAPED_DOUBLE_QUOTE;
        if (nodeId != null) {
            regexp = String.valueOf(regexp) + " \\[" + nodeId + ":0\\]";
        }
        this.thenTheWorkflowLogShouldContain(null, USE_REGEXP_MARKER, regexp);
    }
}

