/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.uplink.common.internal.MessageType;
import de.rcenvironment.core.communication.uplink.common.internal.UplinkProtocolMessageConverter;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionLowLevelEventHandler;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkConnectionRefusedException;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConstants;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolErrorType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.LogUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.ProtocolException;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CommonUplinkLowLevelProtocolWrapper {
    private static final int HANDSHAKE_MESSAGE_TIMEOUT = 2000;
    private static final int HANDSHAKE_MESSAGE_WAIT_CHECK_INTERVAL = 100;
    protected DataInputStream dataInputStream;
    protected DataOutputStream dataOutputStream;
    protected final UplinkConnectionLowLevelEventHandler eventHandler;
    protected final ObjectMapper jsonMapper;
    protected final UplinkProtocolMessageConverter messageConverter;
    protected final boolean verboseLoggingEnabled = DebugSettings.getVerboseLoggingEnabled((String)"uplink.lowlevel");
    protected final Log log = LogFactory.getLog(this.getClass());
    private boolean outgoingStreamClosed;

    public CommonUplinkLowLevelProtocolWrapper(UplinkConnectionLowLevelEventHandler eventHandler, String logIdentity) {
        this.eventHandler = eventHandler;
        this.jsonMapper = JsonUtils.getDefaultObjectMapper();
        this.messageConverter = new UplinkProtocolMessageConverter(logIdentity);
    }

    public abstract void runSession() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMessageBlock(long channelId, MessageBlock messageBlock) throws IOException {
        byte[] data = messageBlock.getData();
        DataOutputStream dataOutputStream = this.dataOutputStream;
        synchronized (dataOutputStream) {
            if (this.outgoingStreamClosed) {
                this.log.debug((Object)"Ignoring message send request as the connection has been shut down");
                return;
            }
            if (this.verboseLoggingEnabled) {
                this.log.debug((Object)StringUtils.format((String)"Sending a message of type %s to channel %d, payload size %d bytes", (Object[])new Object[]{messageBlock.getType(), channelId, data.length}));
            }
            this.dataOutputStream.writeLong(channelId);
            this.dataOutputStream.writeInt(data.length);
            this.dataOutputStream.writeByte(messageBlock.getType().getCode());
            this.dataOutputStream.write(data);
            this.dataOutputStream.flush();
        }
    }

    public final void sendMessageBlock(long channelId, int type, byte[] data) throws IOException {
        this.sendMessageBlock(channelId, new MessageBlock(type, data));
    }

    public abstract void closeOutgoingMessageStream();

    protected byte[] readExpectedBytesWithTimeout(int expectedLength, int timeoutMsec, int recheckInterval) throws IOException {
        byte[] expectedBytes = new byte[expectedLength];
        long startTime = System.currentTimeMillis();
        while (this.dataInputStream.available() < expectedLength) {
            if (System.currentTimeMillis() < startTime + (long)timeoutMsec) {
                try {
                    Thread.sleep(recheckInterval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new ProtocolException("Interrupted while waiting for " + expectedLength + " bytes of data");
                }
            }
            throw new ProtocolException("Expected " + expectedLength + " bytes of data, but did not receive them within " + timeoutMsec + " msec");
        }
        this.dataInputStream.readFully(expectedBytes);
        return expectedBytes;
    }

    protected void sendHandshakeInit() throws IOException {
        byte[] initBytes = "INIT v0 ".getBytes(UplinkProtocolConstants.DEFAULT_CHARSET);
        if (initBytes.length != 8) {
            throw new ProtocolException("Handshake array length does not match the expected byte count");
        }
        this.dataOutputStream.write(initBytes);
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)("Sent handshake init (" + initBytes.length + " bytes)"));
        }
    }

    protected void expectHandshakeInit() throws IOException {
        byte[] expectedHandshakeInitBytes = this.readExpectedBytesWithTimeout(8, 2000, 100);
        String reveivedHeader = new String(expectedHandshakeInitBytes, UplinkProtocolConstants.DEFAULT_CHARSET);
        if (!reveivedHeader.equals("INIT v0 ")) {
            throw new ProtocolException("Received invalid handshake init: " + reveivedHeader);
        }
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)("Received expected handshake init (" + expectedHandshakeInitBytes.length + " bytes)"));
        }
    }

    protected void sendHandshakeData(MessageBlock responseData) throws IOException {
        this.sendMessageBlock(0L, responseData);
        this.dataOutputStream.flush();
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)"Sent handshake data");
        }
    }

    protected void sendHandshakeConfirmation() throws IOException {
        this.sendMessageBlock(0L, new MessageBlock(MessageType.HANDSHAKE));
        this.dataOutputStream.flush();
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)"Sent handshake confirmation");
        }
    }

    protected MessageBlock expectHandshakeData() throws IOException, UplinkConnectionRefusedException {
        long channelId = this.readChannelId();
        if (channelId != 0L) {
            throw new ProtocolException("Unexpected handshake channel id: " + channelId);
        }
        MessageBlock messageBlock = this.readMessageBlockWithTimeout(2000);
        if (messageBlock.getType() == MessageType.GOODBYE) {
            String errorMessage = this.extractGoodbyeErrorMessage(messageBlock, true);
            throw new UplinkConnectionRefusedException(UplinkProtocolErrorType.typeOfWrappedErrorMessage(errorMessage), UplinkProtocolErrorType.unwrapErrorMessage(errorMessage));
        }
        if (messageBlock.getType() != MessageType.HANDSHAKE) {
            throw new ProtocolException("Expected handshake data, but received message type " + (Object)((Object)messageBlock.getType()) + " instead");
        }
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)("Received handshake data: " + new String(messageBlock.getData(), UplinkProtocolConstants.DEFAULT_CHARSET)));
        }
        return messageBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long readChannelId() throws IOException {
        DataInputStream dataInputStream = this.dataInputStream;
        synchronized (dataInputStream) {
            return this.dataInputStream.readLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final MessageBlock readMessageBlock() throws IOException {
        DataInputStream dataInputStream = this.dataInputStream;
        synchronized (dataInputStream) {
            int blockSize = this.dataInputStream.readInt();
            if (blockSize < 0 || blockSize > 262144) {
                throw new ProtocolException(StringUtils.format((String)"Incoming message block announced a size of %d (valid range: 0-%d)", (Object[])new Object[]{blockSize, 262144}));
            }
            byte type = this.dataInputStream.readByte();
            byte[] data = new byte[blockSize];
            this.dataInputStream.readFully(data);
            return new MessageBlock(type, data);
        }
    }

    protected final MessageBlock readMessageBlockWithTimeout(int timeoutMsec) throws IOException {
        CompletableFuture messageFuture = new CompletableFuture();
        ConcurrencyUtils.getAsyncTaskService().execute("Uplink: Read message block with timeout", () -> {
            try {
                messageFuture.complete(this.readMessageBlock());
            }
            catch (IOException e) {
                messageFuture.completeExceptionally(e);
            }
        });
        try {
            return (MessageBlock)messageFuture.get(timeoutMsec, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException("Error while waiting for an incoming message: " + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeOutgoingDataStream() {
        DataOutputStream dataOutputStream = this.dataOutputStream;
        synchronized (dataOutputStream) {
            if (this.outgoingStreamClosed) {
                return;
            }
            try {
                this.sendMessageBlock(0L, 127, new byte[0]);
            }
            catch (ProtocolException e) {
                throw new RuntimeException("Internal error: Failed to construct shutdown message", e);
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Failed to send goodbye message; most likely, the connection has already failed");
            }
            try {
                this.dataOutputStream.close();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"Failed to actively close the output stream; most likely, the connection has already failed");
            }
            this.outgoingStreamClosed = true;
        }
    }

    protected final void runMessageReceiveLoop() {
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)"Running message dispatch loop");
        }
        boolean proceed = true;
        while (proceed) {
            try {
                if (this.receiveNextMessage()) continue;
                proceed = false;
            }
            catch (IOException e) {
                String errorMarker = LogUtils.logExceptionAsSingleLineAndAssignUniqueMarker((Log)this.log, (String)"Error while receiving a message, closing the connection", (Throwable)e);
                this.eventHandler.onNonProtocolError(e);
                this.attemptToSendErrorGoodbyeMessage(UplinkProtocolErrorType.INTERNAL_SERVER_ERROR, "Closing the connection after an error (internal error log marker " + errorMarker + ")");
                proceed = false;
            }
        }
    }

    private boolean receiveNextMessage() throws IOException {
        long channelId = this.readChannelId();
        MessageBlock message = this.readMessageBlock();
        if (message.getType() == MessageType.GOODBYE) {
            this.log.debug((Object)"Received 'goodbye' message, stopping message listener");
            if (message.getDataLength() == 0) {
                this.eventHandler.onRegularGoodbyeMessage();
            } else {
                String errorMessage = this.extractGoodbyeErrorMessage(message, false);
                this.eventHandler.onErrorGoodbyeMessage(UplinkProtocolErrorType.typeOfWrappedErrorMessage(errorMessage), UplinkProtocolErrorType.unwrapErrorMessage(errorMessage));
            }
            return false;
        }
        if (this.verboseLoggingEnabled) {
            this.log.debug((Object)StringUtils.format((String)"Received message of type %s for channel %d, payload size %d bytes", (Object[])new Object[]{message.getType(), channelId, message.getDataLength()}));
        }
        this.eventHandler.onMessageBlock(channelId, message);
        return true;
    }

    private String extractGoodbyeErrorMessage(MessageBlock message, boolean replaceEmptyOrMissingMessage) {
        String errorMessage;
        if (message.getDataLength() == 0 && replaceEmptyOrMissingMessage) {
            return "E99: <no error message available>";
        }
        try {
            errorMessage = new String(message.getData());
        }
        catch (RuntimeException runtimeException) {
            errorMessage = "Failed to decode the error string attached to a 'goodbye' message; byte length: " + message.getDataLength();
        }
        return errorMessage;
    }

    protected void attemptToSendErrorGoodbyeMessage(UplinkProtocolErrorType type, String rawMessage) {
        String wrappedMessage = type.wrapErrorMessage(rawMessage);
        try {
            this.sendMessageBlock(0L, this.messageConverter.encodeErrorGoodbyeMessage(wrappedMessage));
        }
        catch (IOException e) {
            this.log.debug((Object)StringUtils.format((String)"Failed to send a 'goodbye' error message; this is often a best-effort attempt, so this can typically be ignored (message body: %s; error while sending: %s)", (Object[])new Object[]{wrappedMessage, e.toString()}));
        }
    }

    protected boolean isOutgoingStreamClosed() {
        return this.outgoingStreamClosed;
    }
}

