/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.embedded.ssh.api.ScpContext;
import de.rcenvironment.core.embedded.ssh.api.ScpContextManager;
import de.rcenvironment.core.embedded.ssh.internal.ScpContextImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScpContextManagerImpl
implements ScpContextManager {
    private final List<ScpContext> contexts = new ArrayList<ScpContext>();
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public synchronized ScpContext createScpContext(String username, String virtualRootPath) throws IOException {
        ScpContextImpl newContext = new ScpContextImpl(username, virtualRootPath);
        this.contexts.add(newContext);
        return newContext;
    }

    @Override
    public synchronized ScpContext getMatchingScpContext(String username, String virtualPath) {
        for (ScpContext context : this.contexts) {
            if (!context.getAuthorizedUsername().equals(username) || !virtualPath.startsWith(context.getVirtualScpRootPath())) continue;
            return context;
        }
        return null;
    }

    @Override
    public synchronized void disposeScpContext(ScpContext scpContext) throws IOException {
        boolean removed = this.contexts.remove(scpContext);
        if (!removed) {
            this.log.warn((Object)("ScpContext handed in for disposal, but not present in internal list: " + scpContext.toString()));
        }
        scpContext.dispose();
    }
}

