/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.authentication.AuthenticationException;
import de.rcenvironment.core.embedded.ssh.api.ScpContext;
import de.rcenvironment.core.embedded.ssh.api.ScpContextManager;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.scp.ScpCommand;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;

public class ScpCommandWrapper
implements Command,
FileSystemAware,
SessionAware {
    private static final int NOT_FOUND_INDEX = -1;
    private static final String FORWARD_SLASH = "/";
    private static final String BACKSLASH = "\\";
    private String command;
    private InputStream in;
    private OutputStream err;
    private OutputStream out;
    private ExitCallback callback;
    private FileSystem fileSystem;
    private ScpCommandFactory scpCommandFactory;
    private ScpContextManager scpContextManager;
    private ServerSession session;
    private final Log logger = LogFactory.getLog(this.getClass());

    public ScpCommandWrapper(String command, ScpContextManager authenticationManager) {
        this.command = command;
        this.scpContextManager = authenticationManager;
        this.scpCommandFactory = new ScpCommandFactory();
    }

    public void start(ChannelSession channelSession, Environment env) throws IOException {
        block5: {
            String username = (String)env.getEnv().get("USER");
            try {
                String virtualScpPath = this.getScpPathOfCommand();
                ScpContext scpContext = this.scpContextManager.getMatchingScpContext(username, virtualScpPath);
                if (scpContext != null) {
                    try {
                        this.delegateToScp(channelSession, env, scpContext);
                        break block5;
                    }
                    catch (IOException e) {
                        this.logger.warn((Object)"Exception in SCP command wrapper", (Throwable)e);
                        throw e;
                    }
                }
                throw new AuthenticationException(StringUtils.format((String)"No permission to access SCP path \"%s\"", (Object[])new Object[]{virtualScpPath}));
            }
            catch (AuthenticationException e) {
                this.logger.warn((Object)("Denied SCP access for user " + username + ": " + e.toString()));
                this.out.write(2);
                this.out.write(("ERROR: " + e.getMessage()).getBytes());
                this.out.write(10);
                this.out.flush();
                this.callback.onExit(0);
            }
        }
    }

    public void destroy(ChannelSession channelSession) {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            this.logger.debug((Object)e);
        }
    }

    private void delegateToScp(ChannelSession channelSession, Environment env, ScpContext scpContext) throws IOException {
        ScpCommand scpCommand = (ScpCommand)this.scpCommandFactory.createCommand(channelSession, this.rewriteCommand(this.command, scpContext));
        scpCommand.setErrorStream(this.err);
        scpCommand.setExitCallback(this.callback);
        scpCommand.setInputStream(this.in);
        scpCommand.setOutputStream(this.out);
        scpCommand.setSession(this.session);
        scpCommand.setFileSystem(this.fileSystem);
        scpCommand.start(channelSession, env);
    }

    private String rewriteCommand(String originalCommand, ScpContext scpContext) {
        String rewrittenPath;
        int startOfPath = originalCommand.indexOf(FORWARD_SLASH);
        String originalCommandStart = originalCommand.substring(0, startOfPath);
        String originalPath = originalCommand.substring(startOfPath);
        this.logger.debug((Object)StringUtils.format((String)"Rewriting access to logical file path '%s' (command prefix: '%s')", (Object[])new Object[]{originalPath, originalCommandStart}));
        if (!originalPath.startsWith(scpContext.getVirtualScpRootPath())) {
            throw new IllegalStateException("Virtual SCP path '" + originalPath + "' does not start with expected root path '" + scpContext.getVirtualScpRootPath() + "'");
        }
        String relativePath = originalPath.substring(scpContext.getVirtualScpRootPath().length());
        if (relativePath.startsWith(FORWARD_SLASH) || relativePath.startsWith(BACKSLASH)) {
            relativePath = relativePath.substring(1);
        }
        if (!(rewrittenPath = new File(scpContext.getLocalRootPath(), relativePath).getAbsolutePath().replace(BACKSLASH, FORWARD_SLASH)).startsWith(FORWARD_SLASH)) {
            rewrittenPath = FORWARD_SLASH + rewrittenPath;
        }
        if (originalPath.endsWith(FORWARD_SLASH) && !rewrittenPath.endsWith(FORWARD_SLASH)) {
            rewrittenPath = String.valueOf(rewrittenPath) + FORWARD_SLASH;
        }
        this.logger.debug((Object)("Final SCP mapped path: " + rewrittenPath));
        File rewrittenPathParentDir = new File(rewrittenPath).getParentFile();
        rewrittenPathParentDir.mkdirs();
        return String.valueOf(originalCommandStart) + rewrittenPath;
    }

    private String getScpPathOfCommand() throws AuthenticationException {
        int slashPos = this.command.indexOf(FORWARD_SLASH);
        if (slashPos == -1) {
            throw new AuthenticationException("SCP path must contain at least one forward slash");
        }
        if (this.command.charAt(slashPos - 1) != ' ') {
            throw new AuthenticationException("SCP path must start with a forward slash");
        }
        String path = this.command.substring(slashPos).trim();
        if (path.contains("..") || path.contains("..")) {
            throw new AuthenticationException("Parent folder traversal (\"..\") is disallowed");
        }
        return path;
    }

    public void setInputStream(InputStream inParam) {
        this.in = inParam;
    }

    public void setOutputStream(OutputStream outParam) {
        this.out = outParam;
    }

    public void setErrorStream(OutputStream errParam) {
        this.err = errParam;
    }

    public void setExitCallback(ExitCallback callbackParam) {
        this.callback = callbackParam;
    }

    public void setFileSystem(FileSystem fileSystemParam) {
        this.fileSystem = fileSystemParam;
    }

    public void setSession(ServerSession arg0) {
        this.session = arg0;
    }
}

