/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.OperatingSystemException;
import de.rcenvironment.core.monitoring.system.api.SystemMonitoringDataService;
import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.monitoring.system.internal.PTQLWrapper;
import de.rcenvironment.core.monitoring.system.internal.SystemMonitoringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.osgi.framework.BundleContext;

public class SystemMonitoringDataServiceImpl
implements SystemMonitoringDataService {
    private static final Sigar SIGAR = new Sigar();
    private static final int CONVERSION_FACTOR_1K = 1024;
    private static final double CONVERSION_FACTOR_PERCENT = 100.0;
    private static final int SIG_ID_KILL = 15;
    private static final int SIG_ID_FORCE_KILL = -9;
    private static final String NO_SUCH_PROCESS_MESSAGE = "No such process";
    private static final String ACCESS_DENIED_EXCEPTION = "Access is denied.";
    private static final Log LOGGER = LogFactory.getLog(SystemMonitoringDataServiceImpl.class);
    private static final int TOTAL_CPU_NAN_MAX_RETRY_COUNT = 50;
    private static final int TOTAL_CPU_NAN_RETRY_WAIT_MSEC = 1;
    private long cachedTotalSystemRam;

    protected void activate(BundleContext bundleContext) {
        try {
            this.cachedTotalSystemRam = this.fetchTotalSystemRAM();
        }
        catch (OperatingSystemException e) {
            this.cachedTotalSystemRam = 0L;
            LOGGER.error((Object)("Failed to initialize total system RAM: " + e.toString()));
        }
    }

    @Override
    public double getTotalCPUUsage() throws OperatingSystemException {
        try {
            double cpuUsage;
            block7: {
                SigarProxy sigarProxy = Humidor.getInstance().getSigar();
                cpuUsage = sigarProxy.getCpuPerc().getCombined();
                if (Double.isNaN(cpuUsage)) {
                    int retryCount = 1;
                    while (true) {
                        if (!Double.isNaN(cpuUsage = sigarProxy.getCpuPerc().getCombined())) {
                            LOGGER.debug((Object)("Fetched valid CPU load data after " + retryCount + " immediate retries"));
                            break block7;
                        }
                        if (retryCount >= 50) break;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_CPU_USAGE, "Interrupted while waiting for CPU load data retry");
                        }
                        ++retryCount;
                    }
                    throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_CPU_USAGE, "Failed to fetch valid CPU load data even after " + retryCount + " immediate retries");
                }
            }
            return SystemMonitoringUtils.clampToPercentageOrNAN(cpuUsage);
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_CPU_USAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProcessCPUUsage(Long pid) throws OperatingSystemException {
        Sigar sigar;
        double processCPUusage = 0.0;
        int watch = 0;
        try {
            if (pid == null) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS);
            }
            do {
                sigar = SIGAR;
                synchronized (sigar) {
                    processCPUusage = SIGAR.getProcCpu(pid.longValue()).getPercent();
                }
                if (++watch != 10) continue;
                return processCPUusage;
            } while (processCPUusage == 0.0);
        }
        catch (SigarException e) {
            if (e.getMessage().contains(NO_SUCH_PROCESS_MESSAGE)) {
                throw this.createNoSuchProcessException(pid);
            }
            if (e.getMessage().contains(ACCESS_DENIED_EXCEPTION)) {
                throw this.createAccessDeniedException(pid);
            }
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_CPU_PROCESS_USAGE, " of process with pid: " + pid);
        }
        sigar = SIGAR;
        synchronized (sigar) {
            try {
            }
            catch (SigarException sigarException) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_CPU_LIST);
            }
        }
        return SystemMonitoringUtils.clampToPercentageOrNAN(processCPUusage /= (double)SIGAR.getCpuList().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getReportedCPUIdle() throws OperatingSystemException {
        try {
            double idle = 0.0;
            Sigar sigar = SIGAR;
            synchronized (sigar) {
                idle = SIGAR.getCpuPerc().getIdle();
            }
            return SystemMonitoringUtils.clampToPercentageOrNAN(idle);
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_IDLE);
        }
    }

    @Override
    public long getTotalSystemRAM() throws OperatingSystemException {
        return this.cachedTotalSystemRam;
    }

    @Override
    public long getProcessRAMUsage(Long pid) throws OperatingSystemException {
        try {
            if (pid == null) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS);
            }
            return Humidor.getInstance().getSigar().getProcMem(pid.longValue()).getResident() / 0x100000L;
        }
        catch (SigarException e) {
            if (e.getMessage().contains(NO_SUCH_PROCESS_MESSAGE)) {
                throw this.createNoSuchProcessException(pid);
            }
            if (e.getMessage().contains(ACCESS_DENIED_EXCEPTION)) {
                throw this.createAccessDeniedException(pid);
            }
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_RAM_PROCESS_USAGE, " of process with pid: " + pid);
        }
    }

    @Override
    public long getTotalUsedRAM() throws OperatingSystemException {
        return (long)((double)this.cachedTotalSystemRam * this.getTotalUsedRAMPercentage());
    }

    @Override
    public long getFreeRAM() throws OperatingSystemException {
        return (long)((double)this.cachedTotalSystemRam * (1.0 - this.getTotalUsedRAMPercentage()));
    }

    @Override
    public double getTotalUsedRAMPercentage() throws OperatingSystemException {
        try {
            return Humidor.getInstance().getSigar().getMem().getUsedPercent() / 100.0;
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM_PERCENTAGE);
        }
    }

    @Override
    public double getProcessRAMPercentage(Long pid) throws OperatingSystemException {
        long totalRam = this.getTotalSystemRAM();
        if (totalRam == 0L) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM_PERCENTAGE);
        }
        long ram = this.getProcessRAMUsage(pid);
        return ram / totalRam;
    }

    @Override
    public long getUsedLocalDiskSpace() throws OperatingSystemException {
        return this.getFileSystemUsage().getUsed();
    }

    @Override
    public long getFreeLocalDiskSpace() throws OperatingSystemException {
        return this.getFileSystemUsage().getFree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> getProcesses() throws OperatingSystemException {
        try {
            HashMap<Long, String> processMap = new HashMap<Long, String>();
            List<Long> processList = Arrays.asList(ArrayUtils.toObject((long[])Humidor.getInstance().getSigar().getProcList()));
            for (Long pid : processList) {
                Sigar sigar = SIGAR;
                synchronized (sigar) {
                    long[] pids;
                    long[] lArray = pids = ProcessFinder.find((Sigar)SIGAR, (String)(String.valueOf(PTQLWrapper.createQuery().createQueryString(PTQLWrapper.pid(), PTQLWrapper.eq())) + pid));
                    int n = pids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long process = lArray[n2];
                        processMap.put(process, Humidor.getInstance().getSigar().getProcState(process).getName());
                        ++n2;
                    }
                }
            }
            return processMap;
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_PROCESS_LIST);
        }
    }

    @Override
    public Map<Long, String> getChildProcessesAndIds(Long pid) throws OperatingSystemException {
        if (pid == null) {
            return Collections.emptyMap();
        }
        List<ProcessInformation> childList = this.getFullChildProcessInformation(pid);
        HashMap<Long, String> childMap = new HashMap<Long, String>();
        if (!childList.isEmpty()) {
            for (ProcessInformation process : childList) {
                childMap.put(process.getPid(), process.getName());
            }
        }
        return childMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill(Long pid, Boolean force) throws OperatingSystemException {
        block11: {
            try {
                LOGGER.info((Object)("Killing process with pid: " + pid));
                if (force.booleanValue()) {
                    Sigar sigar = SIGAR;
                    synchronized (sigar) {
                        SIGAR.kill(pid.longValue(), -9);
                        break block11;
                    }
                }
                Sigar sigar = SIGAR;
                synchronized (sigar) {
                    SIGAR.kill(pid.longValue(), 15);
                }
            }
            catch (SigarException e) {
                if (e.getMessage().contains("The parameter is incorrect.")) {
                    LOGGER.error((Object)("Failed to shut down process caused by incorrect parameters. The process with pid: " + pid + " may already be dead."));
                    return;
                }
                if (e.getMessage().contains(ACCESS_DENIED_EXCEPTION)) {
                    throw this.createAccessDeniedException(pid);
                }
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_KILL_PROCESS, " with pid: " + pid);
            }
        }
    }

    private long fetchTotalSystemRAM() throws OperatingSystemException {
        try {
            long ramValue = Humidor.getInstance().getSigar().getMem().getRam();
            if (ramValue == 0L) {
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM);
            }
            return ramValue;
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GATHER_TOTAL_RAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessInformation> getFullChildProcessInformation(long pid) throws OperatingSystemException {
        long[] pids = null;
        ArrayList<ProcessInformation> children = null;
        Sigar sigar = SIGAR;
        synchronized (sigar) {
            try {
                pids = ProcessFinder.find((Sigar)SIGAR, (String)(String.valueOf(PTQLWrapper.createQuery().createQueryString(PTQLWrapper.statePPID(), PTQLWrapper.eq())) + pid));
            }
            catch (SigarException e) {
                if (e.getMessage().equals(ACCESS_DENIED_EXCEPTION)) {
                    throw this.createAccessDeniedException(pid);
                }
                throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_CHILD_PROCESS_LIST, " of parent process with pid: " + pid);
            }
        }
        if (pids != null && pids.length > 0) {
            children = new ArrayList<ProcessInformation>();
            long[] lArray = pids;
            int n = pids.length;
            int n2 = 0;
            while (n2 < n) {
                block12: {
                    ProcessInformation p;
                    Long child = lArray[n2];
                    try {
                        p = new ProcessInformation(child, this.fetchProcessState(child).getName(), this.getFullChildProcessInformation(child), this.getProcessCPUUsage(child), this.getProcessRAMUsage(child));
                    }
                    catch (OperatingSystemException e) {
                        if (e.getErrorType().equals((Object)OperatingSystemException.ErrorType.NO_SUCH_PROCESS)) {
                            LOGGER.info((Object)("Couldn't find process with pid: " + child + ". Process might already be dead."));
                            break block12;
                        }
                        throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_CHILD_PROCESS_LIST, " of parent process with pid: " + pid);
                    }
                    children.add(p);
                }
                ++n2;
            }
        }
        if (children != null) {
            return children;
        }
        return Collections.emptyList();
    }

    private FileSystemUsage getFileSystemUsage() throws OperatingSystemException {
        FileSystem[] fileSystemList;
        try {
            fileSystemList = Humidor.getInstance().getSigar().getFileSystemList();
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_FILE_SYSTEM);
        }
        FileSystemUsage usage = null;
        FileSystem[] fileSystemArray = fileSystemList;
        int n = fileSystemList.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystem fs = fileSystemArray[n2];
            if (fs.getType() == 2) {
                try {
                    usage = Humidor.getInstance().getSigar().getFileSystemUsage(fs.getDirName());
                }
                catch (SigarException sigarException) {
                    throw new OperatingSystemException(OperatingSystemException.ErrorType.FAILED_TO_GET_FILE_SYSTEM_USAGE);
                }
            }
            ++n2;
        }
        return usage;
    }

    @Override
    public ProcState fetchProcessState(long pid) throws OperatingSystemException {
        try {
            return Humidor.getInstance().getSigar().getProcState(pid);
        }
        catch (SigarException sigarException) {
            throw new OperatingSystemException((Object)((Object)OperatingSystemException.ErrorType.FAILED_TO_GET_PROCESS_STATE) + " for process with pid: " + pid);
        }
    }

    private OperatingSystemException createAccessDeniedException(long pid) {
        return new OperatingSystemException(OperatingSystemException.ErrorType.ACCESS_DENIED, " to process with pid: " + pid + ". You may not have the appropriate permissions.");
    }

    private OperatingSystemException createNoSuchProcessException(long pid) {
        return new OperatingSystemException(OperatingSystemException.ErrorType.NO_SUCH_PROCESS, ". The process with pid: " + pid + " may not exist.");
    }
}

