/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.text;

import com.googlecode.lanterna.LanternaException;
import com.googlecode.lanterna.input.GnomeTerminalProfile;
import com.googlecode.lanterna.input.PuttyProfile;
import com.googlecode.lanterna.terminal.TerminalSize;
import com.googlecode.lanterna.terminal.text.ANSITerminal;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CygwinTerminal
extends ANSITerminal {
    private static final Pattern STTY_SIZE_PATTERN = Pattern.compile(".*rows ([0-9]+);.*columns ([0-9]+);.*");
    private Timer resizeCheckTimer;

    public CygwinTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        super(terminalInput, terminalOutput, terminalCharset);
        this.addInputProfile(new GnomeTerminalProfile());
        this.addInputProfile(new PuttyProfile());
        this.onResized(80, 20);
        this.resizeCheckTimer = null;
    }

    @Override
    public TerminalSize getTerminalSize() {
        try {
            String stty = CygwinTerminal.exec(CygwinTerminal.findSTTY(), "-F", "/dev/pty0", "-a");
            Matcher matcher = STTY_SIZE_PATTERN.matcher(stty);
            if (matcher.matches()) {
                return new TerminalSize(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(1)));
            }
            return new TerminalSize(80, 20);
        }
        catch (LanternaException e) {
            return new TerminalSize(80, 20);
        }
    }

    @Override
    public void enterPrivateMode() {
        super.enterPrivateMode();
        this.setCBreak(true);
        this.setEcho(false);
        CygwinTerminal.sttyMinimumCharacterForRead(1);
        this.resizeCheckTimer = new Timer("CygwinTerminalResizeChecker");
        this.resizeCheckTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
            }
        }, 1000L, 1000L);
    }

    @Override
    public void exitPrivateMode() {
        this.resizeCheckTimer.cancel();
        this.setEcho(true);
        super.exitPrivateMode();
        this.setCBreak(false);
    }

    @Override
    public void setCBreak(boolean cbreakOn) {
        CygwinTerminal.sttyCBreak(cbreakOn);
    }

    @Override
    public void setEcho(boolean echoOn) {
        CygwinTerminal.sttyKeyEcho(echoOn);
    }

    private static void sttyKeyEcho(boolean enable) {
        CygwinTerminal.exec(CygwinTerminal.findSTTY(), "-F", "/dev/pty0", enable ? "echo" : "-echo");
    }

    private static void sttyMinimumCharacterForRead(int nrCharacters) {
        CygwinTerminal.exec(CygwinTerminal.findSTTY(), "-F", "/dev/pty0", "min", nrCharacters + "");
    }

    private static void sttyCBreak(boolean enable) {
        CygwinTerminal.exec(CygwinTerminal.findSTTY(), "-F", "/dev/pty0", enable ? "cbreak" : "icanon");
    }

    private static String findShell() {
        return CygwinTerminal.findProgram("sh.exe");
    }

    private static String findSTTY() {
        return CygwinTerminal.findProgram("stty.exe");
    }

    private static String findProgram(String programName) {
        String[] paths;
        for (String path : paths = System.getProperty("java.library.path").split(";")) {
            File shBin = new File(path, programName);
            if (!shBin.exists()) continue;
            return shBin.getAbsolutePath();
        }
        return programName;
    }

    private static String exec(String ... cmd) {
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process process = pb.start();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream stdout = process.getInputStream();
            int readByte = stdout.read();
            while (readByte >= 0) {
                baos.write(readByte);
                readByte = stdout.read();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            BufferedReader reader = new BufferedReader(new InputStreamReader(bais));
            StringBuilder builder = new StringBuilder();
            while (reader.ready()) {
                builder.append(reader.readLine());
            }
            reader.close();
            return builder.toString();
        }
        catch (IOException e) {
            throw new LanternaException(e);
        }
    }
}

