/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.backend.metadata.derby.internal;

import de.rcenvironment.core.datamanagement.backend.metadata.derby.internal.DerbyDatabaseSetupSqlStatements;
import de.rcenvironment.core.datamanagement.backend.metadata.derby.internal.DerbyMetaDataBackendServiceImpl;
import de.rcenvironment.core.utils.common.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DerbyDatabaseSetup {
    private static final String VERSION_6_1 = "6.1";
    private static final String VERSION_ZERO = "0";
    private static final String VERSION_7_0 = "7.0";
    private static final String CURRENT_DB_VERSION = "8.0";
    private static final String[] UPDATABLE_VERSIONS = new String[]{"0", "6.1", "7.0"};
    private static final String[] VERSIONS_REQUIRING_NO_UPDATE = new String[]{"8.0dev2"};
    private static final int QUERY_EXECUTION_TIMEOUT = 600000;
    private static final int MAX_RETRIES = 3;
    private static final Log LOGGER = LogFactory.getLog(DerbyMetaDataBackendServiceImpl.class);
    private static final String WHERE = " WHERE ";
    private static final String APO = "'";
    private static final String AND = " AND ";
    private static final String SELECT = " SELECT ";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void setupDatabase(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        List<String> updatableVersions = Arrays.asList(UPDATABLE_VERSIONS);
        List<String> versionsRequiringNoUpdate = Arrays.asList(VERSIONS_REQUIRING_NO_UPDATE);
        if (!DerbyDatabaseSetup.tableExists(statement, "DB_VERSION_INFO")) {
            if (DerbyDatabaseSetup.tableExists(statement, "WORKFLOW_RUN")) {
                DerbyDatabaseSetup.deleteViews(connection);
                DerbyDatabaseSetup.updateDatabaseToCurrentVersion(connection, new LinkedList<String>(updatableVersions));
                DerbyDatabaseSetup.createViews(connection);
            } else {
                LOGGER.debug((Object)"Setting up database.");
                DerbyDatabaseSetup.createTableDBVersionInfo(connection, CURRENT_DB_VERSION);
                DerbyDatabaseSetup.createTables(connection);
                DerbyDatabaseSetup.createIndexes(connection);
                DerbyDatabaseSetup.createViews(connection);
            }
        } else if (!DerbyDatabaseSetup.getDBVersion(connection).equals(CURRENT_DB_VERSION)) {
            String formerVersion = DerbyDatabaseSetup.getDBVersion(connection);
            if (versionsRequiringNoUpdate.contains(formerVersion)) {
                LOGGER.debug((Object)("Updating database version: v " + formerVersion + " --> " + CURRENT_DB_VERSION + " . No change required."));
                DerbyDatabaseSetup.setDBVersion(CURRENT_DB_VERSION, connection);
            } else {
                if (!updatableVersions.contains(formerVersion)) throw new RuntimeException(StringUtils.format((String)"Failed to update the database from version %s to %s. Most likely reason: It was used with a newer version of RCE before. Use a newer version of RCE or choose another profile directory. (See the user guide for more information about the profile directory.)", (Object[])new Object[]{DerbyDatabaseSetup.getDBVersion(connection), CURRENT_DB_VERSION}));
                LinkedList<String> requiredUpdates = new LinkedList<String>(updatableVersions.subList(updatableVersions.indexOf(formerVersion), updatableVersions.size()));
                DerbyDatabaseSetup.deleteViews(connection);
                DerbyDatabaseSetup.updateDatabaseToCurrentVersion(connection, requiredUpdates);
                DerbyDatabaseSetup.createViews(connection);
            }
        } else if (!(DerbyDatabaseSetup.tableExists(statement, "WORKFLOW_RUN") && DerbyDatabaseSetup.tableExists(statement, "WORKFLOW_RUN_PROPERTIES") && DerbyDatabaseSetup.tableExists(statement, "TIMELINE_INTERVAL") && DerbyDatabaseSetup.tableExists(statement, "COMPONENT_INSTANCE") && DerbyDatabaseSetup.tableExists(statement, "COMPONENT_INSTANCE_PROPERTIES") && DerbyDatabaseSetup.tableExists(statement, "COMPONENT_RUN") && DerbyDatabaseSetup.tableExists(statement, "COMPONENT_RUN_PROPERTIES") && DerbyDatabaseSetup.tableExists(statement, "DATA_REFERENCE") && DerbyDatabaseSetup.tableExists(statement, "BINARY_REFERENCE") && DerbyDatabaseSetup.tableExists(statement, "ENDPOINT_INSTANCE") && DerbyDatabaseSetup.tableExists(statement, "TYPED_DATUM") && DerbyDatabaseSetup.tableExists(statement, "ENDPOINT_DATA") && DerbyDatabaseSetup.tableExists(statement, "ENDPOINT_INSTANCE_PROPERTIES") && DerbyDatabaseSetup.tableExists(statement, "REL_CI_DR") && DerbyDatabaseSetup.tableExists(statement, "REL_WFR_DR") && DerbyDatabaseSetup.tableExists(statement, "REL_CR_DR") && DerbyDatabaseSetup.tableExists(statement, "REL_DR_BR") && DerbyDatabaseSetup.viewExists(statement, "V_COMPONENT_RUNS") && DerbyDatabaseSetup.viewExists(statement, "V_COMPONENT_TIMELINE_INTERVALS") && DerbyDatabaseSetup.viewExists(statement, "V_ENDPOINT_DATA") && DerbyDatabaseSetup.viewExists(statement, "V_ENDPOINT_INSTANCE_PROPERTIES") && DerbyDatabaseSetup.viewExists(statement, "V_WORKFLOW_COMPONENTRUN") && DerbyDatabaseSetup.viewExists(statement, "V_WORKFLOWRUN_DATAREFERENCE") && DerbyDatabaseSetup.viewExists(statement, "V_WORKFLOWRUN_TYPEDDATUM"))) {
            throw new RuntimeException("Unknown DB state!");
        }
        statement.close();
        LOGGER.debug((Object)StringUtils.format((String)"Database version is %s", (Object[])new Object[]{DerbyDatabaseSetup.getDBVersion(connection)}));
    }

    private static void deleteViews(final Connection connection) {
        SQLRunnable task = new SQLRunnable(3){

            @Override
            protected void sqlRun() throws SQLTransientConnectionException {
                try {
                    DerbyDatabaseSetup.deleteView("V_COMPONENT_RUNS", connection);
                    DerbyDatabaseSetup.deleteView("V_COMPONENT_TIMELINE_INTERVALS", connection);
                    DerbyDatabaseSetup.deleteView("V_ENDPOINT_DATA", connection);
                    DerbyDatabaseSetup.deleteView("V_ENDPOINT_INSTANCE_PROPERTIES", connection);
                    DerbyDatabaseSetup.deleteView("V_WORKFLOWRUN_DATAREFERENCE", connection);
                    DerbyDatabaseSetup.deleteView("V_WORKFLOWRUN_TYPEDDATUM", connection);
                    DerbyDatabaseSetup.deleteView("V_WORKFLOW_COMPONENTRUN", connection);
                }
                catch (SQLException e) {
                    if (e instanceof SQLTransientConnectionException) {
                        throw (SQLTransientConnectionException)e;
                    }
                    throw new RuntimeException("Failed to delete views in data management meta data db.", e);
                }
            }

            @Override
            protected void handleSQLException(SQLException sqlException) {
                throw new RuntimeException("Failed to delete views.", sqlException);
            }
        };
        task.run();
    }

    private static void deleteView(String viewName, Connection connection) throws SQLException {
        String sql = "DROP VIEW %s";
        Statement stmt = connection.createStatement();
        if (DerbyDatabaseSetup.viewExists(stmt, viewName)) {
            stmt.execute(StringUtils.format((String)sql, (Object[])new Object[]{viewName}));
            LOGGER.debug((Object)StringUtils.format((String)"Deleted view %s", (Object[])new Object[]{viewName}));
        }
        stmt.close();
    }

    private static void updateDatabaseToCurrentVersion(Connection connection, Queue<String> requiredUpdates) throws SQLTransientConnectionException {
        String startVersion = requiredUpdates.poll();
        if (startVersion == null) {
            DerbyDatabaseSetup.setDBVersion(CURRENT_DB_VERSION, connection);
            return;
        }
        if (startVersion.equals(VERSION_ZERO)) {
            DerbyDatabaseSetup.updateFrom0To61(connection);
        } else if (startVersion.equals(VERSION_6_1)) {
            DerbyDatabaseSetup.updateFrom61To70(connection);
        } else if (startVersion.equals(VERSION_7_0)) {
            DerbyDatabaseSetup.updateFrom70To80(connection);
        }
        DerbyDatabaseSetup.updateDatabaseToCurrentVersion(connection, requiredUpdates);
    }

    private static void updateFrom0To61(Connection connection) {
        LOGGER.debug((Object)"Updating database: v 0 --> v 6.1");
        DerbyDatabaseSetup.createTableDBVersionInfo(connection, VERSION_6_1);
    }

    private static void updateFrom61To70(Connection connection) throws SQLTransientConnectionException {
        LOGGER.debug((Object)"Updating database: v 6.1 --> v 7.0");
        try {
            DatabaseMetaData dbm = connection.getMetaData();
            ResultSet rs = dbm.getTables(null, null, "ENDPOINT_INSTANCE_PROPERTIES", null);
            if (!rs.next()) {
                DerbyDatabaseSetup.createTable("ENDPOINT_INSTANCE_PROPERTIES", connection);
            }
            if (!(rs = dbm.getColumns(null, null, "WORKFLOW_RUN", "WORKFLOW_FILE_REFERENCE")).next()) {
                Statement stmt = connection.createStatement();
                String sql = "ALTER TABLE %s ADD %s LONG VARCHAR";
                stmt.execute(StringUtils.format((String)sql, (Object[])new Object[]{"WORKFLOW_RUN", "WORKFLOW_FILE_REFERENCE"}));
                LOGGER.debug((Object)"Added column WORKFLOW_FILE_DATA_REFERENCE_ID to WORKFLOW_RUN table.");
            }
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientConnectionException) {
                throw (SQLTransientConnectionException)e;
            }
            throw new RuntimeException("Failed to update data management meta data db.", e);
        }
    }

    private static void updateFrom70To80(Connection connection) throws SQLTransientConnectionException {
        LOGGER.debug((Object)"Updating database: v 7.0 --> v 8.0");
        try {
            DatabaseMetaData dbm = connection.getMetaData();
            ResultSet rs = dbm.getColumns(null, null, "COMPONENT_RUN", "COMPONENT_RUN_FINAL_STATE");
            if (!rs.next()) {
                Statement stmt = connection.createStatement();
                String sql = "ALTER TABLE %s ADD %s LONG VARCHAR";
                stmt.execute(StringUtils.format((String)sql, (Object[])new Object[]{"COMPONENT_RUN", "COMPONENT_RUN_FINAL_STATE"}));
                LOGGER.debug((Object)"Added column COMPONENT_RUN_FINAL_STATE to COMPONENT_RUN table.");
                stmt.close();
            }
            DerbyDatabaseSetup.modifyColumnToVarchar100(connection, "COMPONENT_RUN", "NODE_ID");
            DerbyDatabaseSetup.modifyColumnToVarchar100(connection, "DATA_REFERENCE", "NODE_ID");
            DerbyDatabaseSetup.modifyColumnToVarchar100(connection, "WORKFLOW_RUN", "CONTROLLER_NODE_ID");
            DerbyDatabaseSetup.modifyColumnToVarchar100(connection, "WORKFLOW_RUN", "DATAMANAGEMENT_NODE_ID");
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientConnectionException) {
                throw (SQLTransientConnectionException)e;
            }
            throw new RuntimeException("Failed to update data management meta data db.", e);
        }
    }

    private static void modifyColumnToVarchar100(Connection connection, String table, String column) throws SQLTransientConnectionException {
        String tempColumn = "TEMP_NODE_ID";
        try {
            Statement stmt = connection.createStatement();
            String sql1 = "ALTER TABLE %s ADD COLUMN %s VARCHAR(100)";
            String sql2 = "UPDATE %s SET %s = %s";
            String sql3 = "ALTER TABLE %s DROP COLUMN %s";
            String sql4 = "RENAME COLUMN %s.%s TO %s";
            stmt.execute(StringUtils.format((String)sql1, (Object[])new Object[]{table, tempColumn}));
            stmt.execute(StringUtils.format((String)sql2, (Object[])new Object[]{table, tempColumn, column}));
            stmt.execute(StringUtils.format((String)sql3, (Object[])new Object[]{table, column}));
            stmt.execute(StringUtils.format((String)sql4, (Object[])new Object[]{table, tempColumn, column}));
            stmt.close();
            LOGGER.debug((Object)StringUtils.format((String)"Replaced column NODE_ID of table COMPNENT_RUN with column of type VARCHAR(100).", (Object[])new Object[]{column, table}));
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientConnectionException) {
                throw (SQLTransientConnectionException)e;
            }
            throw new RuntimeException("Failed to change column data type.", e);
        }
    }

    private static void createTableDBVersionInfo(final Connection connection, final String dbVersion) {
        SQLRunnable task = new SQLRunnable(3){

            @Override
            protected void sqlRun() throws SQLTransientConnectionException {
                try {
                    DerbyDatabaseSetup.createTable("DB_VERSION_INFO", connection);
                    DerbyDatabaseSetup.setDBVersion(dbVersion, connection);
                }
                catch (SQLException e) {
                    if (e instanceof SQLTransientConnectionException) {
                        throw (SQLTransientConnectionException)e;
                    }
                    throw new RuntimeException("Failed to create table in data management meta data db.", e);
                }
            }

            @Override
            protected void handleSQLException(SQLException sqlException) {
                throw new RuntimeException("Failed to create version information table.", sqlException);
            }
        };
        task.run();
    }

    private static void setDBVersion(String dbVersion, Connection connection) {
        try {
            String sql = "DELETE FROM DB_VERSION_INFO";
            Statement stmt = connection.createStatement();
            stmt.executeUpdate(StringUtils.format((String)sql, (Object[])new Object[]{dbVersion}));
            stmt.close();
            sql = "INSERT INTO DB_VERSION_INFO VALUES('%s')";
            stmt = connection.createStatement();
            stmt.executeUpdate(StringUtils.format((String)sql, (Object[])new Object[]{dbVersion}));
            stmt.close();
            LOGGER.info((Object)StringUtils.format((String)"Set database version to %s", (Object[])new Object[]{dbVersion}));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set database version.", e);
        }
    }

    private static String getDBVersion(Connection connection) {
        try {
            String version = "unknown";
            String sql = " SELECT DB_VERSION FROM DB_VERSION_INFO";
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(StringUtils.format((String)sql, (Object[])new Object[0]));
            if (rs != null && rs.next()) {
                version = rs.getString("DB_VERSION");
                rs.close();
            }
            stmt.close();
            return version;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get database version.", e);
        }
    }

    private static boolean tableExists(Statement statement, String tablename) throws SQLException {
        boolean isExistentTable = false;
        ResultSet rs = null;
        try {
            String sql = " SELECT  tablename FROM SYS.SYSTABLES WHERE tablename = '" + tablename + APO + AND + "tabletype = " + APO + "T" + APO;
            statement.setQueryTimeout(600000);
            rs = statement.executeQuery(sql);
            isExistentTable = rs.next();
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        return isExistentTable;
    }

    private static boolean viewExists(Statement statement, String viewname) throws SQLException {
        boolean isExistentView = false;
        ResultSet rs = null;
        try {
            String sql = " SELECT  tablename FROM SYS.SYSTABLES WHERE tablename = '" + viewname + APO + AND + "tabletype = " + APO + "V" + APO;
            statement.setQueryTimeout(600000);
            rs = statement.executeQuery(sql);
            isExistentView = rs.next();
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        return isExistentView;
    }

    private static void createIndexes(final Connection connection) {
        SQLRunnable task = new SQLRunnable(3){

            @Override
            protected void sqlRun() throws SQLTransientConnectionException {
                DerbyDatabaseSetup.createIndexesTrial(connection);
            }

            @Override
            protected void handleSQLException(SQLException sqlException) {
                throw new RuntimeException("Failed to create indexes.", sqlException);
            }
        };
        task.run();
    }

    private static void createIndexesTrial(Connection connection) throws SQLTransientConnectionException {
        try {
            DerbyDatabaseSetup.createIndex("DATA_REFERENCE", "DATA_REFERENCE_KEY", connection);
            DerbyDatabaseSetup.createIndex("TIMELINE_INTERVAL", "COMPONENT_RUN_ID", connection);
            DerbyDatabaseSetup.createIndex("BINARY_REFERENCE", "BINARY_REFERENCE_KEY", connection);
            DerbyDatabaseSetup.createIndex("ENDPOINT_DATA", "COMPONENT_RUN_ID", connection);
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientConnectionException) {
                throw (SQLTransientConnectionException)e;
            }
            throw new RuntimeException("Failed to create indexes in meta data db.", e);
        }
    }

    private static void createIndex(String tableName, String columnName, Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        String sql = StringUtils.format((String)"CREATE INDEX INDEX_%s_%s ON %s (%s)", (Object[])new Object[]{tableName, columnName, tableName, columnName});
        LOGGER.debug((Object)StringUtils.format((String)"Creating index 'INDEX_%s_%s'", (Object[])new Object[]{tableName, columnName}));
        stmt.executeUpdate(sql);
        stmt.close();
    }

    private static void createTables(final Connection connection) {
        SQLRunnable task = new SQLRunnable(3){

            @Override
            protected void sqlRun() throws SQLTransientConnectionException {
                DerbyDatabaseSetup.createTablesTrial(connection);
            }

            @Override
            protected void handleSQLException(SQLException sqlException) {
                throw new RuntimeException("Failed to create tables.", sqlException);
            }
        };
        task.run();
    }

    private static void createTablesTrial(Connection connection) throws SQLTransientConnectionException {
        try {
            DerbyDatabaseSetup.createTable("WORKFLOW_RUN", connection);
            DerbyDatabaseSetup.createTable("WORKFLOW_RUN_PROPERTIES", connection);
            DerbyDatabaseSetup.createTable("COMPONENT_INSTANCE", connection);
            DerbyDatabaseSetup.createTable("COMPONENT_INSTANCE_PROPERTIES", connection);
            DerbyDatabaseSetup.createTable("COMPONENT_RUN", connection);
            DerbyDatabaseSetup.createTable("COMPONENT_RUN_PROPERTIES", connection);
            DerbyDatabaseSetup.createTable("TIMELINE_INTERVAL", connection);
            DerbyDatabaseSetup.createTable("DATA_REFERENCE", connection);
            DerbyDatabaseSetup.createTable("BINARY_REFERENCE", connection);
            DerbyDatabaseSetup.createTable("ENDPOINT_INSTANCE", connection);
            DerbyDatabaseSetup.createTable("ENDPOINT_INSTANCE_PROPERTIES", connection);
            DerbyDatabaseSetup.createTable("TYPED_DATUM", connection);
            DerbyDatabaseSetup.createTable("ENDPOINT_DATA", connection);
            DerbyDatabaseSetup.createTable("REL_CR_DR", connection);
            DerbyDatabaseSetup.createTable("REL_CI_DR", connection);
            DerbyDatabaseSetup.createTable("REL_WFR_DR", connection);
            DerbyDatabaseSetup.createTable("REL_DR_BR", connection);
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientConnectionException) {
                throw (SQLTransientConnectionException)e;
            }
            throw new RuntimeException("Failed to create tables in data management meta data db.", e);
        }
    }

    private static void createTable(String tableName, Connection connection) throws SQLException {
        String sql;
        Statement stmt;
        block59: {
            stmt = connection.createStatement();
            sql = null;
            LOGGER.debug((Object)StringUtils.format((String)"Creating table '%s'", (Object[])new Object[]{tableName}));
            if (DerbyDatabaseSetup.tableExists(stmt, tableName)) break block59;
            switch (tableName) {
                case "DB_VERSION_INFO": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableDbVersionInfo();
                    break;
                }
                case "WORKFLOW_RUN": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableWorkflowRun();
                    break;
                }
                case "WORKFLOW_RUN_PROPERTIES": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableWorkflowRunProperties();
                    break;
                }
                case "TIMELINE_INTERVAL": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableTimelineInterval();
                    break;
                }
                case "COMPONENT_INSTANCE": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableComponentInstance();
                    break;
                }
                case "COMPONENT_INSTANCE_PROPERTIES": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableComponentInstanceProperties();
                    break;
                }
                case "COMPONENT_RUN": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableComponentRun();
                    break;
                }
                case "COMPONENT_RUN_PROPERTIES": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableComponentRunProperties();
                    break;
                }
                case "TYPED_DATUM": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableTypedDatum();
                    break;
                }
                case "ENDPOINT_INSTANCE": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableEndpointInstance();
                    break;
                }
                case "ENDPOINT_INSTANCE_PROPERTIES": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableEndpointInstanceProperties();
                    break;
                }
                case "ENDPOINT_DATA": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableEndpointData();
                    break;
                }
                case "DATA_REFERENCE": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableDataReference();
                    break;
                }
                case "BINARY_REFERENCE": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlTableBinaryReference();
                    break;
                }
                case "REL_CR_DR": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlRelationComponentRunDataReference();
                    break;
                }
                case "REL_DR_BR": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlRelationDataReferenceBinaryReference();
                    break;
                }
                case "REL_CI_DR": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlRelationComponentInstanceDataReference();
                    break;
                }
                case "REL_WFR_DR": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlRelationWorkflowRunDataReference();
                    break;
                }
            }
        }
        if (sql != null) {
            stmt.executeUpdate(sql);
        }
        stmt.close();
    }

    private static void createViews(final Connection connection) {
        SQLRunnable task = new SQLRunnable(3){

            @Override
            protected void sqlRun() throws SQLTransientConnectionException {
                DerbyDatabaseSetup.createViewsTrial(connection);
            }

            @Override
            protected void handleSQLException(SQLException sqlException) {
                throw new RuntimeException("Failed to create views.", sqlException);
            }
        };
        task.run();
    }

    private static void createViewsTrial(Connection connection) throws SQLTransientConnectionException {
        try {
            DerbyDatabaseSetup.createView("V_COMPONENT_RUNS", connection);
            DerbyDatabaseSetup.createView("V_ENDPOINT_DATA", connection);
            DerbyDatabaseSetup.createView("V_ENDPOINT_INSTANCE_PROPERTIES", connection);
            DerbyDatabaseSetup.createView("V_COMPONENT_TIMELINE_INTERVALS", connection);
            DerbyDatabaseSetup.createView("V_WORKFLOW_COMPONENTRUN", connection);
            DerbyDatabaseSetup.createView("V_WORKFLOWRUN_DATAREFERENCE", connection);
            DerbyDatabaseSetup.createView("V_WORKFLOWRUN_TYPEDDATUM", connection);
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientConnectionException) {
                throw (SQLTransientConnectionException)e;
            }
            throw new RuntimeException("Failed to create views in data management meta data db.", e);
        }
    }

    private static void createView(String viewName, Connection connection) throws SQLException {
        String sql;
        Statement stmt;
        block26: {
            stmt = connection.createStatement();
            sql = null;
            LOGGER.debug((Object)StringUtils.format((String)"Creating view '%s'", (Object[])new Object[]{viewName}));
            if (DerbyDatabaseSetup.viewExists(stmt, viewName)) break block26;
            switch (viewName) {
                case "V_COMPONENT_RUNS": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlViewComponentRuns();
                    break;
                }
                case "V_ENDPOINT_DATA": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlViewEndpointData();
                    break;
                }
                case "V_ENDPOINT_INSTANCE_PROPERTIES": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlViewEndpointInstanceProperties();
                    break;
                }
                case "V_COMPONENT_TIMELINE_INTERVALS": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlViewComponentTimelineIntervals();
                    break;
                }
                case "V_WORKFLOW_COMPONENTRUN": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlViewWorkflowRunComponentRun();
                    break;
                }
                case "V_WORKFLOWRUN_DATAREFERENCE": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlViewWorkflowRunDataReference();
                    break;
                }
                case "V_WORKFLOWRUN_TYPEDDATUM": {
                    sql = DerbyDatabaseSetupSqlStatements.getSqlViewWorkflowRunTypedDatum();
                    break;
                }
            }
        }
        if (sql != null) {
            stmt.executeUpdate(sql);
        }
        stmt.close();
    }

    private static abstract class SQLRunnable
    implements Runnable {
        private final int maxAttempts;

        private SQLRunnable() {
            this(3);
        }

        private SQLRunnable(int maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        public final void run() {
            SQLTransientConnectionException exception;
            int attemptCount = 0;
            while (true) {
                ++attemptCount;
                exception = null;
                try {
                    this.sqlRun();
                }
                catch (SQLTransientConnectionException e) {
                    exception = e;
                    this.waitForRetry();
                    if (attemptCount <= this.maxAttempts) continue;
                }
                break;
            }
            if (exception != null) {
                this.handleSQLException(exception);
            }
        }

        private void waitForRetry() {
            LOGGER.info((Object)"Waiting half o a second to retry SQL statement execution");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn((Object)"Waiting for retrying a failed SQL statement was interupted");
            }
        }

        protected abstract void sqlRun() throws SQLTransientConnectionException;

        protected abstract void handleSQLException(SQLException var1);
    }
}

