/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.UpdateAgent;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TimingCodeInjector;
import net.sf.saxon.trace.TimingTraceListener;
import net.sf.saxon.trace.XQueryTraceListener;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;
import org.xml.sax.InputSource;

public class Query {
    protected Configuration config;
    protected Properties outputProperties = new Properties();
    protected boolean showTime = false;
    protected int repeat = 1;
    protected String sourceFileName = null;
    protected String queryFileName = null;
    protected boolean useURLs = false;
    protected String outputFileName = null;
    protected String moduleURIResolverClass = null;
    protected String uriResolverClass = null;
    protected boolean explain = false;
    protected boolean wrap = false;
    protected boolean pullMode = false;
    protected boolean projection = false;
    protected DecimalValue languageVersion = null;
    protected boolean updating = false;
    protected boolean writeback = false;
    protected boolean backup = true;
    protected String explainOutputFileName = null;
    private boolean closeTraceDestination = false;

    protected Configuration getConfiguration() {
        return this.config;
    }

    public static void main(String[] args) throws Exception {
        new Query().doQuery(args, "java net.sf.saxon.Query");
    }

    public void setPermittedOptions(CommandLineOptions options) {
        options.addRecognizedOption("backup", 1, "Save updated documents before overwriting");
        options.addRecognizedOption("catalog", 258, "Use specified catalog file to resolve URIs");
        options.addRecognizedOption("config", 258, "Use specified configuration file");
        options.addRecognizedOption("cr", 259, "Use specified collection URI resolver class");
        options.addRecognizedOption("dtd", 4, "Validate using DTD");
        options.setPermittedValues("dtd", new String[]{"on", "off", "recover"}, "on");
        options.addRecognizedOption("expand", 1, "Expand attribute defaults from DTD or Schema");
        options.addRecognizedOption("explain", 2, "Display compiled expression tree and optimization decisions");
        options.addRecognizedOption("ext", 1, "Allow calls to Java extension functions and xsl:result-document");
        options.addRecognizedOption("init", 3, "User-supplied net.sf.saxon.lib.Initializer class to initialize the Saxon Configuration");
        options.addRecognizedOption("l", 1, "Maintain line numbers for source documents");
        options.addRecognizedOption("mr", 259, "Use named ModuleURIResolver class");
        options.addRecognizedOption("now", 264, "Run with specified current date/time");
        options.addRecognizedOption("o", 258, "Use specified file for primary output");
        options.addRecognizedOption("opt", 261, "Use optimization level 0..10");
        options.addRecognizedOption("outval", 260, "Action when validation of output file fails");
        options.setPermittedValues("outval", new String[]{"recover", "fatal"}, null);
        options.addRecognizedOption("p", 1, "Recognize query parameters in URI passed to doc()");
        options.addRecognizedOption("pipe", 260, "Execute internally in push or pull mode");
        options.setPermittedValues("pipe", new String[]{"push", "pull"}, null);
        options.addRecognizedOption("projection", 1, "Use source document projection");
        options.addRecognizedOption("q", 258, "Query filename");
        options.addRecognizedOption("qs", 265, "Query string (usually in quotes)");
        options.addRecognizedOption("qversion", 260, "Indicate whether XQuery version 3.0 is supported");
        options.setPermittedValues("qversion", new String[]{"1.0", "1.1", "3.0"}, null);
        options.addRecognizedOption("r", 259, "Use named URIResolver class");
        options.addRecognizedOption("repeat", 261, "Run N times for performance measurement");
        options.addRecognizedOption("s", 258, "Source file for primary input");
        options.addRecognizedOption("sa", 1, "Run in schema-aware mode");
        options.addRecognizedOption("strip", 260, "Handling of whitespace text nodes in source documents");
        options.setPermittedValues("strip", new String[]{"none", "all", "ignorable"}, null);
        options.addRecognizedOption("t", 1, "Display version and timing information");
        options.addRecognizedOption("T", 3, "Use named TraceListener class, or standard TraceListener");
        options.addRecognizedOption("TJ", 1, "Debug binding and execution of extension functions");
        options.setPermittedValues("TJ", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("tree", 260, "Use specified tree model for source documents");
        options.addRecognizedOption("TP", 2, "Use profiling trace listener, with specified output file");
        options.addRecognizedOption("traceout", 258, "File for output of trace() and -T output");
        options.setPermittedValues("tree", new String[]{"linked", "tiny", "tinyc"}, null);
        options.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        options.setPermittedValues("u", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("update", 260, "Enable or disable XQuery updates, or enable the syntax but discard the updates");
        options.setPermittedValues("update", new String[]{"on", "off", "discard"}, null);
        options.addRecognizedOption("val", 260, "Apply validation to source documents");
        options.setPermittedValues("val", new String[]{"strict", "lax"}, "strict");
        options.addRecognizedOption("wrap", 1, "Wrap result sequence in XML elements");
        options.addRecognizedOption("x", 259, "Use named XMLReader class for parsing source documents");
        options.addRecognizedOption("xi", 1, "Expand XInclude directives in source documents");
        options.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        options.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        options.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        options.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsiloc", 1, "Load schemas named in xsi:schemaLocation (default on)");
        options.addRecognizedOption("?", 512, "Display command line help text");
    }

    protected void doQuery(String[] args, String command) {
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        try {
            options.setActualOptions(args);
        }
        catch (XPathException err) {
            Query.quit(err.getMessage(), 2);
        }
        boolean schemaAware = false;
        String configFile = options.getOptionValue("config");
        if (configFile != null) {
            try {
                this.config = Configuration.readConfiguration(new StreamSource(configFile));
                schemaAware = this.config.isLicensedFeature(4);
            }
            catch (XPathException e) {
                Query.quit(e.getMessage(), 2);
            }
        }
        if (this.config == null && !schemaAware) {
            schemaAware = options.testIfSchemaAware();
        }
        if (this.config == null) {
            this.config = Configuration.newConfiguration();
        }
        this.config.setHostLanguage(51);
        StaticQueryContext staticEnv = this.config.newStaticQueryContext();
        staticEnv.setSchemaAware(schemaAware);
        DynamicQueryContext dynamicEnv = new DynamicQueryContext(this.config);
        try {
            int r;
            XQueryExpression exp;
            this.parseOptions(options, command, dynamicEnv);
            if (this.languageVersion != null) {
                staticEnv.setLanguageVersion(this.languageVersion);
            }
            if (this.updating) {
                staticEnv.setUpdatingEnabled(true);
            }
            if (this.moduleURIResolverClass != null) {
                Object mr = this.config.getInstance(this.moduleURIResolverClass, null);
                if (!(mr instanceof ModuleURIResolver)) {
                    this.badUsage(this.moduleURIResolverClass + " is not a ModuleURIResolver");
                }
                staticEnv.setModuleURIResolver((ModuleURIResolver)mr);
            }
            if (this.uriResolverClass != null) {
                this.config.setURIResolver(this.config.makeURIResolver(this.uriResolverClass));
                dynamicEnv.setURIResolver(this.config.makeURIResolver(this.uriResolverClass));
            }
            this.config.displayLicenseMessage();
            if (schemaAware && !this.config.isLicensedFeature(4)) {
                if ("EE".equals(this.config.getEditionCode())) {
                    Query.quit("Installed license does not allow schema-aware query", 2);
                } else {
                    Query.quit("Schema-aware query requires Saxon Enterprise Edition", 2);
                }
            }
            if (this.pullMode) {
                // empty if block
            }
            if (this.explain) {
                this.config.setOptimizerTracing(true);
            }
            Source sourceInput = null;
            if (this.sourceFileName != null) {
                sourceInput = this.processSourceFile(this.sourceFileName, this.useURLs);
            }
            long startTime = System.nanoTime();
            if (this.showTime) {
                System.err.println("Analyzing query from " + this.queryFileName);
            }
            try {
                exp = this.compileQuery(staticEnv, this.queryFileName, this.useURLs);
                if (this.showTime) {
                    long endTime = System.nanoTime();
                    System.err.println("Analysis time: " + (double)(endTime - startTime) / 1000000.0 + " milliseconds");
                    startTime = endTime;
                }
            }
            catch (XPathException err) {
                int line = -1;
                String module = null;
                if (err.getLocator() != null) {
                    line = err.getLocator().getLineNumber();
                    module = err.getLocator().getSystemId();
                }
                if (err.hasBeenReported()) {
                    Query.quit("Static error(s) in query", 2);
                } else if (line == -1) {
                    System.err.println("Static error in query: " + err.getMessage());
                } else {
                    System.err.println("Static error at line " + line + " of " + module + ':');
                    System.err.println(err.getMessage());
                }
                exp = null;
                System.exit(2);
            }
            if (this.explain) {
                this.explain(exp);
            }
            exp.setAllowDocumentProjection(this.projection);
            this.processSource(sourceInput, exp, dynamicEnv);
            startTime = System.nanoTime();
            long totalTime = 0L;
            for (r = 0; r < this.repeat; ++r) {
                try {
                    OutputStream destination;
                    if (this.outputFileName != null) {
                        File outputFile = new File(this.outputFileName);
                        if (outputFile.isDirectory()) {
                            Query.quit("Output is a directory", 2);
                        }
                        if (!outputFile.exists()) {
                            File directory = outputFile.getParentFile();
                            if (directory != null && !directory.exists()) {
                                directory.mkdirs();
                            }
                            outputFile.createNewFile();
                        }
                        destination = new FileOutputStream(outputFile);
                    } else {
                        destination = System.out;
                    }
                    this.runQuery(exp, dynamicEnv, destination, this.outputProperties);
                }
                catch (TerminationException err) {
                    throw err;
                }
                catch (XPathException err) {
                    if (err.hasBeenReported()) {
                        throw new XPathException("Run-time errors were reported");
                    }
                    throw err;
                }
                if (!this.showTime) continue;
                long endTime = System.nanoTime();
                if (r >= 3) {
                    totalTime += endTime - startTime;
                }
                if (this.repeat < 100) {
                    System.err.println("Execution time: " + CommandLineOptions.showExecutionTimeNano(endTime - startTime));
                    System.err.println("Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                } else if (totalTime > 1000000000000L) break;
                startTime = endTime;
            }
            if (this.repeat > 3) {
                System.err.println("Average execution time: " + CommandLineOptions.showExecutionTimeNano(totalTime / (long)(r - 3)));
            }
        }
        catch (TerminationException err) {
            Query.quit(err.getMessage(), 1);
        }
        catch (XPathException err) {
            Query.quit("Query processing failed: " + err.getMessage(), 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            err.printStackTrace();
            Query.quit("Query processing failed", 2);
        }
        catch (SchemaException err) {
            Query.quit("Schema processing failed: " + err.getMessage(), 2);
        }
        catch (LicenseException err) {
            Query.quit("Query processing failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
            Query.quit("Fatal error during query: " + err2.getClass().getName() + ": " + (err2.getMessage() == null ? " (no message)" : err2.getMessage()), 2);
        }
    }

    protected void parseOptions(CommandLineOptions options, String command, DynamicQueryContext dynamicEnv) throws TransformerException {
        options.applyToConfiguration(this.config);
        dynamicEnv.setURIResolver(this.config.getURIResolver());
        this.backup = "on".equals(options.getOptionValue("backup"));
        this.explainOutputFileName = options.getOptionValue("explain");
        this.explain = this.explainOutputFileName != null;
        this.moduleURIResolverClass = options.getOptionValue("mr");
        this.outputFileName = options.getOptionValue("o");
        String value = options.getOptionValue("p");
        if ("on".equals(value)) {
            this.config.setParameterizedURIResolver();
            this.useURLs = true;
        }
        this.pullMode = "pull".equals(options.getOptionValue("pipe"));
        this.projection = "on".equals(options.getOptionValue("projection"));
        value = options.getOptionValue("q");
        if (value != null) {
            this.queryFileName = value;
        }
        if ((value = options.getOptionValue("qs")) != null) {
            this.queryFileName = "{" + value + "}";
        }
        try {
            String qv = options.getOptionValue("qversion");
            if (qv == null) {
                qv = "1.0";
            }
            if ("1.1".equals(qv)) {
                qv = "3.0";
            }
            this.languageVersion = (DecimalValue)DecimalValue.makeDecimalValue(qv, true).asAtomic();
        }
        catch (ValidationException err) {
            this.badUsage("XQuery version " + options.getOptionValue("qversion") + " must be numeric");
        }
        value = options.getOptionValue("repeat");
        if (value != null) {
            this.repeat = Integer.parseInt(value);
        }
        this.sourceFileName = options.getOptionValue("s");
        value = options.getOptionValue("t");
        if ("on".equals(value)) {
            System.err.println(this.config.getProductTitle());
            System.err.println(Configuration.getPlatform().getPlatformVersion());
            this.config.setTiming(true);
            this.showTime = true;
        }
        if ((value = options.getOptionValue("traceout")) != null && !value.equals("#err")) {
            if (value.equals("#out")) {
                dynamicEnv.setTraceFunctionDestination(System.out);
            } else if (value.equals("#null")) {
                dynamicEnv.setTraceFunctionDestination(null);
            } else {
                try {
                    dynamicEnv.setTraceFunctionDestination(new PrintStream(new FileOutputStream(new File(value))));
                    this.closeTraceDestination = true;
                }
                catch (FileNotFoundException e) {
                    this.badUsage("Trace output file " + value + " cannot be created");
                }
            }
        }
        if ((value = options.getOptionValue("T")) != null) {
            if ("".equals(value)) {
                this.config.setTraceListener(new XQueryTraceListener());
            } else {
                this.config.setTraceListenerClass(value);
            }
            this.config.setLineNumbering(true);
        }
        if ((value = options.getOptionValue("TP")) != null) {
            TimingTraceListener listener = new TimingTraceListener();
            this.config.setTraceListener(listener);
            this.config.setLineNumbering(true);
            this.config.getDefaultStaticQueryContext().setCodeInjector(new TimingCodeInjector());
            if (value.length() > 0) {
                try {
                    listener.setOutputDestination(new PrintStream(new FileOutputStream(new File(value))));
                }
                catch (FileNotFoundException e) {
                    this.badUsage("Trace output file " + value + " cannot be created");
                }
            }
        }
        if ((value = options.getOptionValue("u")) != null) {
            this.useURLs = "on".equals(value);
        }
        if ((value = options.getOptionValue("update")) != null) {
            if (!"off".equals(value)) {
                this.updating = true;
            }
            this.writeback = !"discard".equals(value);
        }
        this.wrap = "on".equals(options.getOptionValue("wrap"));
        value = options.getOptionValue("x");
        if (value != null) {
            this.config.setSourceParserClass(value);
        }
        String additionalSchemas = options.getOptionValue("xsd");
        value = options.getOptionValue("?");
        if (value != null) {
            this.badUsage("");
        }
        this.applyLocalOptions(options, this.config);
        List<String> positional = options.getPositionalOptions();
        int currentPositionalOption = 0;
        if (this.queryFileName == null) {
            if (positional.size() == currentPositionalOption) {
                this.badUsage("No query file name");
            }
            this.queryFileName = positional.get(currentPositionalOption++);
        }
        if (currentPositionalOption < positional.size()) {
            this.badUsage("Unrecognized option: " + positional.get(currentPositionalOption));
        }
        options.setParams(this.config, null, dynamicEnv, this.outputProperties);
        if (additionalSchemas != null) {
            CommandLineOptions.loadAdditionalSchemas(this.config, additionalSchemas);
        }
    }

    protected void applyLocalOptions(CommandLineOptions options, Configuration config) {
    }

    protected Source processSourceFile(String sourceFileName, boolean useURLs) throws TransformerException {
        Source sourceInput;
        if (useURLs || sourceFileName.startsWith("http:") || sourceFileName.startsWith("file:")) {
            sourceInput = this.config.getURIResolver().resolve(sourceFileName, null);
            if (sourceInput == null) {
                sourceInput = this.config.getSystemURIResolver().resolve(sourceFileName, null);
            }
        } else if (sourceFileName.equals("-")) {
            sourceInput = new StreamSource(System.in);
        } else {
            File sourceFile = new File(sourceFileName);
            if (!sourceFile.exists()) {
                Query.quit("Source file " + sourceFile + " does not exist", 2);
            }
            if (Configuration.getPlatform().isJava()) {
                InputSource eis = new InputSource(sourceFile.toURI().toString());
                sourceInput = new SAXSource(eis);
            } else {
                sourceInput = new StreamSource(sourceFile.toURI().toString());
            }
        }
        return sourceInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XQueryExpression compileQuery(StaticQueryContext staticEnv, String queryFileName, boolean useURLs) throws XPathException, IOException {
        XQueryExpression exp;
        if (queryFileName.equals("-")) {
            InputStreamReader queryReader = new InputStreamReader(System.in);
            exp = staticEnv.compileQuery(queryReader);
        } else if (queryFileName.startsWith("{") && queryFileName.endsWith("}")) {
            String q = queryFileName.substring(1, queryFileName.length() - 1);
            exp = staticEnv.compileQuery(q);
        } else if (useURLs || queryFileName.startsWith("http:") || queryFileName.startsWith("file:")) {
            StreamSource[] sources;
            ModuleURIResolver resolver = staticEnv.getModuleURIResolver();
            boolean isStandardResolver = false;
            if (resolver == null) {
                resolver = staticEnv.getConfiguration().getStandardModuleURIResolver();
                isStandardResolver = true;
            }
            while (true) {
                String[] locations = new String[]{queryFileName};
                try {
                    sources = resolver.resolve(null, null, locations);
                }
                catch (Exception e) {
                    if (e instanceof XPathException) {
                        throw (XPathException)e;
                    }
                    XPathException err = new XPathException("Exception in ModuleURIResolver: ", e);
                    err.setErrorCode("XQST0059");
                    throw err;
                }
                if (sources != null) break;
                if (isStandardResolver) {
                    Query.quit("System problem: standard ModuleURIResolver returned null", 4);
                    continue;
                }
                resolver = staticEnv.getConfiguration().getStandardModuleURIResolver();
                isStandardResolver = true;
            }
            if (sources.length != 1 || !(sources[0] instanceof StreamSource)) {
                Query.quit("Module URI Resolver must return a single StreamSource", 2);
            }
            String queryText = QueryReader.readSourceQuery(sources[0], this.config.getNameChecker());
            exp = staticEnv.compileQuery(queryText);
        } else {
            FileInputStream queryStream = null;
            try {
                queryStream = new FileInputStream(queryFileName);
                staticEnv.setBaseURI(new File(queryFileName).toURI().toString());
                exp = staticEnv.compileQuery(queryStream, null);
            }
            finally {
                if (queryStream != null) {
                    ((InputStream)queryStream).close();
                }
            }
        }
        return exp;
    }

    protected void explain(XQueryExpression exp) throws FileNotFoundException, XPathException {
        OutputStream explainOutput = this.explainOutputFileName == null || "".equals(this.explainOutputFileName) ? System.err : new FileOutputStream(new File(this.explainOutputFileName));
        Properties props = ExpressionPresenter.makeDefaultProperties();
        Receiver diag = this.config.getSerializerFactory().getReceiver(new StreamResult(explainOutput), this.config.makePipelineConfiguration(), props);
        ExpressionPresenter expressionPresenter = new ExpressionPresenter(this.config, diag);
        exp.explain(expressionPresenter);
    }

    protected void processSource(Source sourceInput, XQueryExpression exp, DynamicQueryContext dynamicEnv) throws XPathException {
        if (sourceInput != null) {
            ParseOptions options = new ParseOptions();
            if (this.showTime) {
                System.err.println("Processing " + sourceInput.getSystemId());
            }
            if (!exp.usesContextItem()) {
                System.err.println("Source document ignored - query does not access the context item");
                sourceInput = null;
            } else if (this.projection) {
                PathMap map = exp.getPathMap();
                PathMap.PathMapRoot contextRoot = map.getContextDocumentRoot();
                if (this.explain) {
                    System.err.println("DOCUMENT PROJECTION: PATH MAP");
                    map.diagnosticDump(System.err);
                }
                if (contextRoot != null) {
                    if (contextRoot.hasUnknownDependencies()) {
                        System.err.println("Document projection for the context document is not possible, because the query uses paths that defy analysis");
                    } else {
                        options.addFilter(this.config.makeDocumentProjector(contextRoot));
                    }
                } else {
                    System.err.println("Source document supplied, but query does not access the context item");
                }
            }
            if (sourceInput != null) {
                DocumentInfo doc = this.config.buildDocument(sourceInput, options);
                dynamicEnv.setContextItem(doc);
            }
        }
    }

    protected void runQuery(XQueryExpression exp, DynamicQueryContext dynamicEnv, OutputStream destination, final Properties outputProps) throws XPathException, IOException {
        if (exp.getExpression().isUpdatingExpression() && this.updating) {
            if (outputProps.getProperty("method") == null) {
                outputProps.setProperty("method", "xml");
            }
            if (this.writeback) {
                final ArrayList errors = new ArrayList(3);
                UpdateAgent agent = new UpdateAgent(){

                    public void update(NodeInfo node, Controller controller) throws XPathException {
                        try {
                            DocumentPool pool = controller.getDocumentPool();
                            String documentURI = pool.getDocumentURI(node);
                            if (documentURI != null) {
                                QueryResult.rewriteToDisk(node, outputProps, Query.this.backup, Query.this.showTime ? System.err : null);
                            } else if (Query.this.showTime) {
                                System.err.println("Updated document discarded because it was not read using doc()");
                            }
                        }
                        catch (XPathException err) {
                            System.err.println(err.getMessage());
                            errors.add(err);
                        }
                    }
                };
                exp.runUpdate(dynamicEnv, agent);
                if (!errors.isEmpty()) {
                    throw (XPathException)errors.get(0);
                }
            } else {
                Set affectedDocuments = exp.runUpdate(dynamicEnv);
                if (affectedDocuments.contains(dynamicEnv.getContextItem())) {
                    QueryResult.serialize((NodeInfo)dynamicEnv.getContextItem(), new StreamResult(destination), outputProps);
                }
            }
        } else if (this.wrap && !this.pullMode) {
            SequenceIterator results = exp.iterator(dynamicEnv);
            DocumentInfo resultDoc = QueryResult.wrap(results, this.config);
            QueryResult.serialize(resultDoc, new StreamResult(destination), outputProps);
            destination.close();
        } else if (this.pullMode) {
            if (this.wrap) {
                outputProps.setProperty("{http://saxon.sf.net/}wrap-result-sequence", "yes");
            }
            exp.pull(dynamicEnv, new StreamResult(destination), outputProps);
        } else {
            exp.run(dynamicEnv, new StreamResult(destination), outputProps);
        }
        if (this.closeTraceDestination) {
            dynamicEnv.getTraceFunctionDestination().close();
        }
    }

    protected static void quit(String message, int code) {
        System.err.println(message);
        System.exit(code);
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/using-xquery/commandline.xml");
        System.err.println("Format: " + this.getClass().getName() + " options params");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        System.err.println("Options available:" + options.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        System.err.println("Params: ");
        System.err.println("  param=value           Set query string parameter");
        System.err.println("  +param=filename       Set query document parameter");
        System.err.println("  ?param=expression     Set query parameter using XPath");
        System.err.println("  !param=value          Set serialization parameter");
        if ("".equals(message)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }
}

