/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.registration.internal;

import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.internal.ComponentBundleConfiguration;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.model.api.ComponentColor;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentShape;
import de.rcenvironment.core.component.model.api.ComponentSize;
import de.rcenvironment.core.component.model.api.LazyDisposal;
import de.rcenvironment.core.component.model.api.LocalExecutionOnly;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationDefinitionImpl;
import de.rcenvironment.core.component.model.configuration.impl.ConfigurationExtensionDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointDefinitionsProviderImpl;
import de.rcenvironment.core.component.model.endpoint.impl.EndpointGroupDefinitionImpl;
import de.rcenvironment.core.component.model.impl.ComponentInstallationImpl;
import de.rcenvironment.core.component.model.impl.ComponentInterfaceImpl;
import de.rcenvironment.core.component.model.impl.ComponentRevisionImpl;
import de.rcenvironment.core.component.registration.api.Registerable;
import de.rcenvironment.core.component.registration.internal.ComponentBundleListener;
import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.packageadmin.PackageAdmin;

@Component(immediate=true)
public class ComponentBundleLoader {
    private final Map<String, String> compFactoryServiceIdToCompInstIdMapping = new HashMap<String, String>();
    private final List<ServiceReference<?>> unhandledCompControllers = new ArrayList();
    private PlatformService platformService;
    private ConfigurationService configurationService;
    private LocalComponentRegistrationService componentRegistrationService;
    private UserComponentIdMappingService userComponentIdMappingService;
    private PackageAdmin packageAdminService;
    private LogicalNodeId localDefaultLogicalNodeId;
    private ComponentBundleConfiguration configuration;
    private ComponentContext osgiComponentCtx;
    @Deprecated
    private final Set<String> instantiationAuthTokens = Collections.synchronizedSet(new HashSet());
    private AuthorizationService authorizationService;
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected synchronized void activate(ComponentContext newContext) {
        this.localDefaultLogicalNodeId = this.platformService.getLocalDefaultLogicalNodeId();
        ConfigurationSegment configurationSegment = this.configurationService.getConfigurationSegment("publishing");
        try {
            this.configuration = (ComponentBundleConfiguration)configurationSegment.mapToObject(ComponentBundleConfiguration.class);
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to parse component publish settings; using default values", (Throwable)e);
            this.configuration = new ComponentBundleConfiguration();
        }
        for (String publishedId : this.configuration.getPublished()) {
            this.log.warn((Object)("Found a deprecated publication entry \"" + publishedId + "\" in the profile's configuration file, but it will not be applied; " + "use the component authorization system to publish components"));
        }
        List<ServiceReference<?>> list = this.unhandledCompControllers;
        synchronized (list) {
            this.osgiComponentCtx = newContext;
            for (ServiceReference<?> component : this.unhandledCompControllers) {
                this.registerXmlComponentDeclaration(component);
            }
            this.unhandledCompControllers.clear();
        }
        if (!CommandLineArguments.isDoNotStartComponentsRequested()) {
            ConcurrencyUtils.getAsyncTaskService().execute("Start all bundles providing RCE components", () -> {
                this.osgiComponentCtx.getBundleContext().addBundleListener((BundleListener)new ComponentBundleListener());
                Bundle[] bundleArray = this.osgiComponentCtx.getBundleContext().getBundles();
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle b = bundleArray[n2];
                    ComponentBundleListener.handleBundle(b);
                    ++n2;
                }
                this.componentRegistrationService.reportBuiltinComponentLoadingComplete();
            });
        } else {
            this.log.debug((Object)"Not triggering start of remaining component bundles as component loading is disabled");
            this.componentRegistrationService.reportBuiltinComponentLoadingComplete();
        }
    }

    @Reference
    protected void bindPlatformService(PlatformService newPlatformService) {
        this.platformService = newPlatformService;
    }

    @Reference
    protected void bindConfigurationService(ConfigurationService newInstance) {
        this.configurationService = newInstance;
    }

    @Reference
    protected void bindUserComponentIdMappingService(UserComponentIdMappingService newInstance) {
        this.userComponentIdMappingService = newInstance;
    }

    @Reference
    protected void bindComponentRegistrationService(LocalComponentRegistrationService newInstance) {
        this.componentRegistrationService = newInstance;
    }

    @Reference
    protected void bindComponentAuthorizationService(AuthorizationService newInstance) {
        this.authorizationService = newInstance;
    }

    @Reference
    protected void bindPackageAdminService(PackageAdmin newPackageAdminService) {
        this.packageAdminService = newPackageAdminService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=ComponentFactory.class, target="(component.factory=de.rcenvironment.rce.component)", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, name="Component Factory", unbind="unregisterXmlComponentDeclaration")
    protected synchronized void registerXmlComponentDeclaration(ServiceReference<?> factoryReference) {
        if (CommandLineArguments.isDoNotStartComponentsRequested()) {
            this.log.warn((Object)("Received a component registration call although components should be disabled: " + factoryReference.getBundle().getSymbolicName()));
            return;
        }
        List<ServiceReference<?>> list = this.unhandledCompControllers;
        synchronized (list) {
            if (this.osgiComponentCtx == null) {
                this.unhandledCompControllers.add(factoryReference);
                return;
            }
        }
        String compIdentifier = UUID.randomUUID().toString();
        ComponentFactory factory = (ComponentFactory)this.osgiComponentCtx.getBundleContext().getService(factoryReference);
        ComponentInstance compInstance = this.createOsgiComponentInstance(factory, compIdentifier);
        if (compInstance != null) {
            try {
                ComponentRevisionImpl componentRevision;
                ServiceReference<?> componentReference = this.getComponentReference(compIdentifier);
                if (componentReference != null && (componentRevision = this.createComponentRevision(componentReference)) != null) {
                    ComponentInstallation componentInstallation = this.createComponentInstallation(componentRevision);
                    this.compFactoryServiceIdToCompInstIdMapping.put(factoryReference.getProperty("service.id").toString(), componentInstallation.getInstallationId());
                    this.userComponentIdMappingService.registerBuiltinComponentMapping(componentInstallation.getComponentInterface().getIdentifier(), componentInstallation.getComponentInterface().getDisplayName());
                    this.componentRegistrationService.registerOrUpdateLocalComponentInstallation(componentInstallation);
                    return;
                }
            }
            finally {
                try {
                    compInstance.dispose();
                }
                catch (NullPointerException e) {
                    this.log.debug((Object)("NPE, most likely cause: unbind method  was not declared: " + e.toString()));
                }
            }
        }
        this.log.error((Object)StringUtils.format((String)"Failed to register a component, try restarting RCE (affected bundle: %s)", (Object[])new Object[]{factoryReference.getBundle().toString()}));
    }

    protected synchronized void unregisterXmlComponentDeclaration(ServiceReference<?> factoryReference) {
        String compIdentifier = this.compFactoryServiceIdToCompInstIdMapping.get(factoryReference.getProperty("service.id").toString());
        this.componentRegistrationService.unregisterLocalComponentInstallation(compIdentifier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readIcon(String key, ServiceReference<?> reference) {
        String iconPath = (String)reference.getProperty(key);
        if (iconPath == null) return null;
        String iconName = (String)reference.getProperty(key);
        String bundleId = "de.rcenvironment.components.";
        if (reference.getProperty("rce.component.icon.bundlename") == null) {
            String componentName = (String)reference.getProperty("rce.component.name");
            bundleId = String.valueOf(bundleId) + componentName.toLowerCase() + ".common";
        } else {
            bundleId = (String)reference.getProperty("rce.component.icon.bundlename");
        }
        URL url = ComponentUtils.readIconURL(bundleId, iconName);
        if (url == null) {
            this.log.warn((Object)("Icon not found: " + iconPath));
            return null;
        }
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                InputStream stream = url.openStream();
                try {
                    byte[] byArray;
                    block21: {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        try {
                            while (true) {
                                int r;
                                if ((r = stream.read()) < 0) {
                                    byArray = bos.toByteArray();
                                    return byArray;
                                }
                                bos.write(r);
                            }
                        }
                        finally {
                            if (bos == null) break block21;
                            bos.close();
                        }
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    return byArray;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.log.warn((Object)("Failed to read icon: " + iconPath));
            return null;
        }
    }

    @Deprecated
    protected void registerComponentInstantiationAuthToken(String token) {
        if (token != null) {
            this.instantiationAuthTokens.add(token);
        }
    }

    private ComponentInterfaceImpl configureComponentInterfaceFromImplementingClass(ComponentInterfaceImpl componentInterface, String className) {
        Class<?> componentClass;
        try {
            componentClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Failed to load component class: " + className), (Throwable)e);
            return null;
        }
        componentInterface.setLocalExecutionOnly(componentClass.getAnnotation(LocalExecutionOnly.class) != null);
        componentInterface.setPerformLazyDisposal(componentClass.getAnnotation(LazyDisposal.class) != null);
        componentInterface.setIsDeprecated(componentClass.getAnnotation(de.rcenvironment.core.component.model.api.Deprecated.class) != null);
        return componentInterface;
    }

    private ComponentInstance createOsgiComponentInstance(ComponentFactory factory, String identifier) {
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        ((Dictionary)serviceProperties).put("rce.component.controller.instance", identifier);
        try {
            return factory.newInstance(serviceProperties);
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Failed to load component because of an error in the OSGi DS file or an error in the component's constructor", (Throwable)e);
            return null;
        }
    }

    private ServiceReference<?> getComponentReference(String identifier) {
        ServiceReference[] references;
        block4: {
            String filter = "(rce.component.controller.instance=" + identifier + ")";
            try {
                references = this.osgiComponentCtx.getBundleContext().getAllServiceReferences(Registerable.class.getName(), filter);
                if (references != null && references.length != 0) break block4;
                this.log.error((Object)StringUtils.format((String)"No component found that provides the service '%s' and that has the temporary identifier '%s'", (Object[])new Object[]{Registerable.class.getName(), identifier}));
                return null;
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("Invalid syntax. This is a bug.", e);
            }
        }
        if (references.length > 1) {
            this.log.warn((Object)StringUtils.format((String)"More than one component found that provides the service '%s' and that has the temporary identifier '%s', first one is taken", (Object[])new Object[]{Registerable.class.getName(), identifier}));
        }
        return references[0];
    }

    private ComponentInstallation createComponentInstallation(ComponentRevisionImpl componentRevision) {
        ComponentInstallationImpl componentInstallation = new ComponentInstallationImpl();
        componentInstallation.setInstallationId(componentRevision.getComponentInterface().getIdentifierAndVersion());
        componentInstallation.setComponentRevision(componentRevision);
        componentInstallation.setNodeIdObject(this.localDefaultLogicalNodeId);
        return componentInstallation;
    }

    private void setIdentifiers(ServiceReference<?> componentReference, ComponentInterfaceImpl componentInterface) {
        String identifier;
        List<String> identifiers = null;
        Object identifierObject = componentReference.getProperty("rce.component.id");
        if (identifierObject != null) {
            if (identifierObject instanceof String[]) {
                String[] identifiersArray = (String[])identifierObject;
                if (identifiersArray.length == 0) {
                    throw new IllegalArgumentException("At least one component identifier must be defined whithin in XML definition file of the component");
                }
                identifier = identifiersArray[0];
                identifiers = Arrays.asList(identifiersArray);
            } else {
                identifier = (String)identifierObject;
            }
        } else {
            String name = (String)componentReference.getProperty("rce.component.name");
            identifier = String.valueOf((String)componentReference.getProperty("rce.component.class")) + "_" + name;
        }
        if (identifiers == null) {
            identifiers = new ArrayList<String>();
            identifiers.add(identifier);
        }
        componentInterface.setIdentifier(identifier);
        componentInterface.setIdentifiers(identifiers);
    }

    private ComponentRevisionImpl createComponentRevision(ServiceReference<?> componentReference) {
        ComponentInterfaceImpl componentInterface = new ComponentInterfaceImpl();
        ComponentRevisionImpl componentRevision = new ComponentRevisionImpl();
        this.setIdentifiers(componentReference, componentInterface);
        componentInterface.setDisplayName((String)componentReference.getProperty("rce.component.name"));
        componentInterface.setGroupName((String)componentReference.getProperty("rce.component.group"));
        componentInterface.setVersion((String)componentReference.getProperty("rce.component.version"));
        componentInterface.setIcon16(this.readIcon("rce.component.icon-16", componentReference));
        componentInterface.setIcon24(this.readIcon("rce.component.icon-24", componentReference));
        componentInterface.setIcon32(this.readIcon("rce.component.icon-32", componentReference));
        componentInterface.setSize(this.getComponentSize(componentReference));
        componentInterface.setColor(this.getComponentColor(componentReference));
        componentInterface.setShape(this.getComponentShape(componentReference));
        componentInterface.setCanHandleNotAValueDataTypes(this.getCanHandleNotAValueDataTypes(componentReference));
        componentInterface.setIsLoopDriver(this.getIsResetSink(componentReference));
        componentInterface.setLoopDriverSupportsDiscard(this.getLoopDriverSupportsDiscard(componentReference));
        try {
            componentInterface.setInputDefinitionsProvider(this.createEndpointDefinitionsProvider("rce.component.inputs", componentReference, componentReference.getBundle(), EndpointType.INPUT));
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to parse input definition", (Throwable)e);
            return null;
        }
        try {
            componentInterface.setOutputDefinitionsProvider(this.createEndpointDefinitionsProvider("rce.component.outputs", componentReference, componentReference.getBundle(), EndpointType.OUTPUT));
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to parse output definition", (Throwable)e);
            return null;
        }
        try {
            componentInterface.setConfigurationDefinition(this.createConfigurationDefinition("rce.component.configuration", componentReference));
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to parse configuration definition", (Throwable)e);
            return null;
        }
        try {
            componentInterface.setConfigurationExtensionDefinitions(this.createConfigurationExtensionDefinitions(componentReference.getBundle()));
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to parse extension definition", (Throwable)e);
            return null;
        }
        String className = (String)componentReference.getProperty("rce.component.class");
        this.configureComponentInterfaceFromImplementingClass(componentInterface, className);
        componentRevision.setComponentInterface(componentInterface);
        componentRevision.setClassName(className);
        return componentRevision;
    }

    private ComponentColor getComponentColor(ServiceReference<?> componentReference) {
        String color = (String)componentReference.getProperty("rce.component.color");
        if (color != null) {
            try {
                return ComponentColor.valueOf(color.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error((Object)StringUtils.format((String)"Color declared under '%s' is invalid: %s. Valid ones are: %s. Default will be used: %s", (Object[])new Object[]{"rce.component.color", color, Arrays.toString((Object[])ComponentColor.values()), ComponentConstants.COMPONENT_COLOR_STANDARD}));
            }
        }
        return ComponentConstants.COMPONENT_COLOR_STANDARD;
    }

    private boolean getCanHandleNotAValueDataTypes(ServiceReference<?> componentReference) {
        return Boolean.valueOf((String)componentReference.getProperty("rce.component.canHandleNotAValueDataTypes"));
    }

    private boolean getLoopDriverSupportsDiscard(ServiceReference<?> componentReference) {
        return Boolean.valueOf((String)componentReference.getProperty("rce.component.loopDriverSupportsDiscard"));
    }

    private boolean getIsResetSink(ServiceReference<?> componentReference) {
        return Boolean.valueOf((String)componentReference.getProperty("rce.component.isDriverComponent"));
    }

    private ComponentSize getComponentSize(ServiceReference<?> componentReference) {
        String size = (String)componentReference.getProperty("rce.component.size");
        if (size != null) {
            try {
                return ComponentSize.valueOf(size.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error((Object)StringUtils.format((String)"Size declared under '%s' is not valid: %s. Valid ones are: %s. Default will be used: %s", (Object[])new Object[]{"rce.component.size", size, Arrays.toString((Object[])ComponentSize.values()), ComponentConstants.COMPONENT_SIZE_STANDARD}));
            }
        }
        return ComponentConstants.COMPONENT_SIZE_STANDARD;
    }

    private ComponentShape getComponentShape(ServiceReference<?> componentReference) {
        String shape = (String)componentReference.getProperty("rce.component.shape");
        if (shape != null) {
            try {
                return ComponentShape.valueOf(shape.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error((Object)StringUtils.format((String)"Shape declared under '%s' is not valid: %s. Valid ones are: %s. Default will be used: %s", (Object[])new Object[]{"rce.component.shape", shape, Arrays.toString((Object[])ComponentShape.values()), ComponentConstants.COMPONENT_SHAPE_STANDARD}));
            }
        }
        return ComponentConstants.COMPONENT_SHAPE_STANDARD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EndpointDefinitionsProviderImpl createEndpointDefinitionsProvider(String key, ServiceReference<?> reference, Bundle componentsBundle, EndpointType type) throws IOException {
        Set<EndpointGroupDefinitionImpl> inputGroupDefinitions;
        EndpointDefinitionsProviderImpl endpointProvider;
        block39: {
            Set<EndpointDefinitionImpl> endpointDefinitions;
            Throwable throwable;
            URL fileUrl;
            String file;
            block36: {
                file = (String)reference.getProperty(key);
                if (file == null) {
                    return new EndpointDefinitionsProviderImpl();
                }
                fileUrl = reference.getBundle().getResource(file);
                if (fileUrl == null) {
                    throw new IOException("Endpoint definition file doesn't exist: " + file);
                }
                List<InputStream> extendedStaticInputStreams = this.getInputStreamsForEndpointMetaDataExtensions(reference, componentsBundle, type);
                List<InputStream> extendedDynamicInputStreams = this.getInputStreamsForEndpointMetaDataExtensions(reference, componentsBundle, type);
                endpointProvider = new EndpointDefinitionsProviderImpl();
                try {
                    Throwable throwable2 = null;
                    throwable = null;
                    try {
                        InputStream staticEndpointDescriptionInputStream = fileUrl.openStream();
                        try {
                            try (InputStream dynamicEndpointDescriptionInputStream = fileUrl.openStream();){
                                endpointDefinitions = ComponentUtils.extractStaticEndpointDefinition(staticEndpointDescriptionInputStream, extendedStaticInputStreams, type);
                                endpointDefinitions.addAll(ComponentUtils.extractDynamicEndpointDefinition(dynamicEndpointDescriptionInputStream, extendedDynamicInputStreams, type));
                            }
                            if (staticEndpointDescriptionInputStream == null) break block36;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (staticEndpointDescriptionInputStream == null) throw throwable2;
                            staticEndpointDescriptionInputStream.close();
                            throw throwable2;
                        }
                        staticEndpointDescriptionInputStream.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new IOException("Failed to parse endpoint definition file: " + file, e);
                }
            }
            endpointProvider.setEndpointDefinitions(endpointDefinitions);
            try {
                throwable = null;
                Object var13_18 = null;
                try {
                    InputStream endpointGroupDefinitionInputStream = fileUrl.openStream();
                    try {
                        block38: {
                            InputStream staticEndpointGroupDefinitionInputStream = fileUrl.openStream();
                            try {
                                try (InputStream dynamicEndpointGroupDefinitionInputStream = fileUrl.openStream();){
                                    inputGroupDefinitions = ComponentUtils.extractStaticInputGroupDefinitions(staticEndpointGroupDefinitionInputStream);
                                    inputGroupDefinitions.addAll(ComponentUtils.extractDynamicInputGroupDefinitions(dynamicEndpointGroupDefinitionInputStream));
                                }
                                if (staticEndpointGroupDefinitionInputStream == null) break block38;
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                } else if (throwable != throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                if (staticEndpointGroupDefinitionInputStream == null) throw throwable;
                                staticEndpointGroupDefinitionInputStream.close();
                                throw throwable;
                            }
                            staticEndpointGroupDefinitionInputStream.close();
                        }
                        if (endpointGroupDefinitionInputStream == null) break block39;
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        if (endpointGroupDefinitionInputStream == null) throw throwable;
                        endpointGroupDefinitionInputStream.close();
                        throw throwable;
                    }
                    endpointGroupDefinitionInputStream.close();
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                        throw throwable;
                    }
                    if (throwable == throwable7) throw throwable;
                    throwable.addSuppressed(throwable7);
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to parse endpoint group definition file: " + file, e);
            }
        }
        endpointProvider.setEndpointGroupDefinitions(inputGroupDefinitions);
        return endpointProvider;
    }

    private List<InputStream> getInputStreamsForEndpointMetaDataExtensions(ServiceReference<?> reference, Bundle componentsBundle, EndpointType type) throws IOException {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        String manifestHeaderKey = type == EndpointType.INPUT ? "RCE-ComponentExtension-InputMetaData" : "RCE-ComponentExtension-OutputMetaData";
        Bundle[] bundleArray = this.getFragmentBundlesProvidingPropertyExtensions(componentsBundle);
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            Dictionary manifestHeaders = fragment.getHeaders();
            String extensionFile = (String)manifestHeaders.get(manifestHeaderKey);
            if (extensionFile != null) {
                URL fileUrl = reference.getBundle().getResource(extensionFile);
                if (fileUrl == null) {
                    throw new IOException("Endpoint definition file doesn't exist: " + extensionFile);
                }
                inputStreams.add(fileUrl.openStream());
            }
            ++n2;
        }
        return inputStreams;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationDefinitionImpl createConfigurationDefinition(String key, ServiceReference<?> reference) throws IOException {
        file = (String)reference.getProperty(key);
        if (file == null) {
            return new ConfigurationDefinitionImpl();
        }
        fileUrl = reference.getBundle().getResource(file);
        if (fileUrl == null) {
            throw new IOException("Configuration definition file doesn't exist: " + file);
        }
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                configurationDescriptionInputStream = fileUrl.openStream();
                try {
                    block25: {
                        placeholdersDescriptionInputStream = fileUrl.openStream();
                        try {
                            block24: {
                                activationFilterDescriptionInputStream = fileUrl.openStream();
                                try {
                                    v0 = ComponentUtils.extractConfigurationDescription(configurationDescriptionInputStream, placeholdersDescriptionInputStream, activationFilterDescriptionInputStream);
                                    return v0;
                                }
                                finally {
                                    if (activationFilterDescriptionInputStream == null) break block24;
                                    activationFilterDescriptionInputStream.close();
                                }
                            }
                            if (placeholdersDescriptionInputStream == null) break block25;
                        }
                        catch (Throwable var6_9) {
                            if (var5_5 == null) {
                                var5_5 = var6_9;
                            } else if (var5_5 != var6_9) {
                                var5_5.addSuppressed(var6_9);
                            }
                            if (placeholdersDescriptionInputStream == null) throw var5_5;
                            placeholdersDescriptionInputStream.close();
                            throw var5_5;
                        }
                        placeholdersDescriptionInputStream.close();
                    }
                    if (configurationDescriptionInputStream != null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var6_10) {
                    if (var5_5 == null) {
                        var5_5 = var6_10;
                    } else if (var5_5 != var6_10) {
                        var5_5.addSuppressed(var6_10);
                    }
                    if (configurationDescriptionInputStream == null) throw var5_5;
                    configurationDescriptionInputStream.close();
                    throw var5_5;
                }
                configurationDescriptionInputStream.close();
lbl-1000:
                // 2 sources

                {
                    return v0;
                }
            }
            catch (Throwable var6_11) {
                if (var5_5 == null) {
                    var5_5 = var6_11;
                    throw var5_5;
                }
                if (var5_5 == var6_11) throw var5_5;
                var5_5.addSuppressed(var6_11);
                throw var5_5;
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to parse configuration definition", e);
        }
    }

    private Set<ConfigurationExtensionDefinitionImpl> createConfigurationExtensionDefinitions(Bundle componentsBundle) throws IOException {
        HashSet<ConfigurationExtensionDefinitionImpl> descs = new HashSet<ConfigurationExtensionDefinitionImpl>();
        Bundle[] bundleArray = this.getFragmentBundlesProvidingPropertyExtensions(componentsBundle);
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            Dictionary manifestHeaders = fragment.getHeaders();
            String extConfigFile = (String)manifestHeaders.get("RCE-ComponentExtension-Configuration");
            if (extConfigFile != null) {
                descs.add(this.createConfigurationExtensionDefinition(componentsBundle, extConfigFile));
            }
            ++n2;
        }
        return descs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConfigurationExtensionDefinitionImpl createConfigurationExtensionDefinition(Bundle bundle, String file) throws IOException {
        fileUrl = bundle.getResource(file);
        if (fileUrl == null) {
            throw new IOException("Configuration extension file doesn't exist: " + file);
        }
        try {
            var4_4 = null;
            var5_7 = null;
            try {
                configurationDescriptionInputStream = fileUrl.openStream();
                try {
                    block24: {
                        placeholdersDescriptionInputStream = fileUrl.openStream();
                        try {
                            block23: {
                                activationFilterDescriptionInputStream = fileUrl.openStream();
                                try {
                                    v0 = ComponentUtils.extractConfigurationExtensionDescription(configurationDescriptionInputStream, placeholdersDescriptionInputStream, activationFilterDescriptionInputStream);
                                    return v0;
                                }
                                finally {
                                    if (activationFilterDescriptionInputStream == null) break block23;
                                    activationFilterDescriptionInputStream.close();
                                }
                            }
                            if (placeholdersDescriptionInputStream == null) break block24;
                        }
                        catch (Throwable var5_8) {
                            if (var4_4 == null) {
                                var4_4 = var5_8;
                            } else if (var4_4 != var5_8) {
                                var4_4.addSuppressed(var5_8);
                            }
                            if (placeholdersDescriptionInputStream == null) throw var4_4;
                            placeholdersDescriptionInputStream.close();
                            throw var4_4;
                        }
                        placeholdersDescriptionInputStream.close();
                    }
                    if (configurationDescriptionInputStream != null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var5_9) {
                    if (var4_4 == null) {
                        var4_4 = var5_9;
                    } else if (var4_4 != var5_9) {
                        var4_4.addSuppressed(var5_9);
                    }
                    if (configurationDescriptionInputStream == null) throw var4_4;
                    configurationDescriptionInputStream.close();
                    throw var4_4;
                }
                configurationDescriptionInputStream.close();
lbl-1000:
                // 2 sources

                {
                    return v0;
                }
            }
            catch (Throwable var5_10) {
                if (var4_4 == null) {
                    var4_4 = var5_10;
                    throw var4_4;
                }
                if (var4_4 == var5_10) throw var4_4;
                var4_4.addSuppressed(var5_10);
                throw var4_4;
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to parse configuration extension definition file: " + file, e);
        }
    }

    private Bundle[] getFragmentBundlesProvidingPropertyExtensions(Bundle componentsBundle) {
        Bundle[] fragments = this.packageAdminService.getFragments(componentsBundle);
        if (fragments == null) {
            fragments = new Bundle[]{};
        }
        return fragments;
    }

    protected void setOsgiComponentContext(ComponentContext compContext) {
        this.osgiComponentCtx = compContext;
    }

    protected void setComponentBundleConfiguration(ComponentBundleConfiguration config) {
        this.configuration = config;
    }
}

