/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraph;
import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupListener;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupListenerAdapter;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupState;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListener;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListenerAdapter;
import de.rcenvironment.core.communication.routing.NetworkRoutingService;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListenerAdapter;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.gui.communication.views.NetworkViewContentProvider;
import de.rcenvironment.core.gui.communication.views.NetworkViewLabelProvider;
import de.rcenvironment.core.gui.communication.views.contributors.ConnectionSetupsListContributor;
import de.rcenvironment.core.gui.communication.views.contributors.InstanceComponentsInfoContributor;
import de.rcenvironment.core.gui.communication.views.contributors.MonitoringDataContributor;
import de.rcenvironment.core.gui.communication.views.contributors.SshConnectionSetupsListContributor;
import de.rcenvironment.core.gui.communication.views.contributors.SshUplinkConnectionSetupsListContributor;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.model.NetworkViewModel;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.utils.common.ClipboardHelper;
import de.rcenvironment.core.monitoring.system.api.model.FullSystemAndProcessDataSnapshot;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class NetworkView
extends ViewPart {
    public static final String ID = "de.rcenvironment.core.gui.communication.views.NetworkView";
    private static final ImageDescriptor ADD = ImageDescriptor.createFromURL((URL)NetworkView.class.getResource("/resources/icons/newConnection.png"));
    private static final ImageDescriptor ADDSSH = ImageDescriptor.createFromURL((URL)NetworkView.class.getResource("/resources/icons/newSshConnection.png"));
    private static final ImageDescriptor ADDUPLINK = ImageDescriptor.createFromURL((URL)NetworkView.class.getResource("/resources/icons/newUplinkConnection.png"));
    private static final ImageDescriptor EDIT = ImageDescriptor.createFromURL((URL)NetworkView.class.getResource("/resources/icons/edit16.gif"));
    private static final ImageDescriptor START = ImageDescriptor.createFromURL((URL)NetworkView.class.getResource("/resources/icons/run_enabled.gif"));
    private static final ImageDescriptor STOP = ImageDescriptor.createFromURL((URL)NetworkView.class.getResource("/resources/icons/cancel_enabled.gif"));
    private static final ImageDescriptor COPY = ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.COPY_16);
    private static final ImageDescriptor DELETE = ImageManager.getInstance().getImageDescriptor((ImageSource)StandardImages.DELETE_16);
    private static final String TAB = "\t";
    private Display display;
    private TreeViewer viewer;
    private Action toggleNodeIdsVisibleAction;
    private Action toggleRawNodePropertiesVisibleAction;
    private Action toggleFullGroupNamesAction;
    private Action addNetworkConnectionAction;
    private Action addSSHConnectionAction;
    private Action addUplinkConnectionAction;
    private Action copyToClipBoardAction;
    private Action editAction;
    private Action deleteAction;
    private Action startAction;
    private Action stopAction;
    private NetworkViewContentProvider contentProvider;
    private NetworkViewLabelProvider labelProvider;
    private boolean rawPropertiesVisible;
    private final ServiceRegistryPublisherAccess serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)((Object)this));
    private NetworkViewModel model;
    private ConnectionSetupsListContributor networkConnectionsContributor;
    private SshConnectionSetupsListContributor sshConnectionsContributor;
    private SshUplinkConnectionSetupsListContributor sshUplinkConnectionsContributor;
    private List<NetworkViewContributor> allContributors;
    private InstanceComponentsInfoContributor infoContributer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.labelProvider = new NetworkViewLabelProvider();
        this.labelProvider.setNodeIdsVisible(false);
        this.contentProvider = this.initializeContentProvider();
        this.contentProvider.setRawPropertiesVisible(false);
        this.createActions();
    }

    private void createActions() {
        this.toggleNodeIdsVisibleAction = new Action("Show Node Identifiers", 2){

            public void run() {
                NetworkView.this.labelProvider.setNodeIdsVisible(this.isChecked());
                NetworkView.this.viewer.refresh((Object)AnchorPoints.INSTANCES_PARENT_NODE, true);
            }
        };
        this.toggleRawNodePropertiesVisibleAction = new Action("Show Raw Node Properties", 2){

            public void run() {
                NetworkView.this.rawPropertiesVisible = this.isChecked();
                NetworkView.this.contentProvider.setRawPropertiesVisible(NetworkView.this.rawPropertiesVisible);
                NetworkView.this.viewer.refresh((Object)AnchorPoints.INSTANCES_PARENT_NODE, false);
            }
        };
        this.toggleFullGroupNamesAction = new Action("Show Group IDs Next to Group Names", 2){

            public void run() {
                NetworkView.this.infoContributer.setShowFullId(this.isChecked());
                NetworkView.this.viewer.refresh((Object)AnchorPoints.INSTANCES_PARENT_NODE, true);
            }
        };
        this.copyToClipBoardAction = new Action("Copy to Clipboard\tCtrl+C", COPY){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)NetworkView.this.viewer.getSelection();
                if (selection.getFirstElement() instanceof NetworkGraphNodeWithContext) {
                    NetworkGraphNodeWithContext selectionObject = (NetworkGraphNodeWithContext)selection.getFirstElement();
                    if (selectionObject.getContext() == NetworkGraphNodeWithContext.Context.RAW_NODE_PROPERTY) {
                        ClipboardHelper.setContent((String)NetworkView.this.labelProvider.getText(selectionObject));
                    } else if (selectionObject.getContext() == NetworkGraphNodeWithContext.Context.RAW_NODE_PROPERTIES_FOLDER) {
                        Map<InstanceNodeSessionId, Map<String, String>> nodeProperties = NetworkView.this.model.getNodeProperties();
                        StringBuilder allRawNodePropertiesBuilder = new StringBuilder("RAW NODE PROPERTIES: \n\n");
                        for (Map.Entry<InstanceNodeSessionId, Map<String, String>> nodePropertiesEntry : nodeProperties.entrySet()) {
                            InstanceNodeSessionId identifier = nodePropertiesEntry.getKey();
                            if (!identifier.getAssociatedDisplayName().equals(selectionObject.getDisplayNameOfNode())) continue;
                            for (String nodeProperty : nodePropertiesEntry.getValue().keySet()) {
                                allRawNodePropertiesBuilder.append(StringUtils.format((String)"%s: %s\n", (Object[])new Object[]{nodeProperty, nodePropertiesEntry.getValue().get(nodeProperty)}));
                            }
                        }
                        ClipboardHelper.setContent((String)allRawNodePropertiesBuilder.toString());
                    }
                }
            }
        };
        this.addNetworkConnectionAction = new Action("Add Network Connection...", ADD){

            public void run() {
                NetworkView.this.networkConnectionsContributor.showAddConnectionDialog();
            }
        };
        this.addUplinkConnectionAction = new Action("Add Uplink Connection...", ADDUPLINK){

            public void run() {
                NetworkView.this.sshUplinkConnectionsContributor.showAddConnectionDialog();
            }
        };
        this.addSSHConnectionAction = new Action("Add SSH Remote Access Connection...", ADDSSH){

            public void run() {
                NetworkView.this.sshConnectionsContributor.showAddConnectionDialog();
            }
        };
        this.editAction = new Action("Edit Network Connection...", EDIT){

            public void run() {
                NetworkView.this.executeStandardUserNodeAction(StandardUserNodeActionType.EDIT);
            }
        };
        this.deleteAction = new Action("Delete Network Connection...\tDelete", DELETE){

            public void run() {
                NetworkView.this.executeStandardUserNodeAction(StandardUserNodeActionType.DELETE);
            }
        };
        this.deleteAction.setAccelerator(127);
        this.startAction = new Action("Start/Connect", START){

            public void run() {
                NetworkView.this.executeStandardUserNodeAction(StandardUserNodeActionType.START);
            }
        };
        this.stopAction = new Action("Stop/Disconnect", STOP){

            public void run() {
                NetworkView.this.executeStandardUserNodeAction(StandardUserNodeActionType.STOP);
            }
        };
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getShell().getDisplay();
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        NetworkGraph initialGraph = ((NetworkRoutingService)this.serviceRegistryAccess.getService(NetworkRoutingService.class)).getReachableNetworkGraph();
        Collection initialConnectionSetups = ((ConnectionSetupService)this.serviceRegistryAccess.getService(ConnectionSetupService.class)).getAllConnectionSetups();
        this.model = new NetworkViewModel(initialGraph, null, initialConnectionSetups, new HashMap<InstanceNodeSessionId, Map<String, String>>(), new ConcurrentHashMap<InstanceNodeSessionId, FullSystemAndProcessDataSnapshot>());
        for (NetworkViewContributor contributor : this.allContributors) {
            contributor.setCurrentModel(this.model);
            contributor.setTreeViewer(this.viewer);
        }
        this.viewer.setInput((Object)this.model);
        this.viewer.expandToLevel(3);
        this.viewer.getControl().addKeyListener((KeyListener)new NetworkViewKeyListener());
        this.viewer.getTree().addMenuDetectListener(event -> this.updatePossibleActionsForSelection(this.getSelectedTreeNode()));
        this.viewer.addDoubleClickListener(dblClkEvent -> {
            this.expandSelectedNode();
            if (this.editAction.isEnabled()) {
                this.editAction.run();
            }
        });
        this.viewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                if (arg0.keyCode == 13) {
                    NetworkView.this.expandSelectedNode();
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.hookContextMenu();
        this.addToolbarActions();
        this.registerChangeListeners();
        this.registerSelectionListeners();
    }

    public void dispose() {
        this.serviceRegistryAccess.dispose();
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private NetworkViewContentProvider initializeContentProvider() {
        this.allContributors = this.defineContributors();
        ArrayList<NetworkViewContributor> rootContributors = new ArrayList<NetworkViewContributor>();
        ArrayList<NetworkViewContributor> instanceDataContributors = new ArrayList<NetworkViewContributor>();
        for (NetworkViewContributor contributor : this.allContributors) {
            if (contributor.getRootElementsPriority() != 0) {
                rootContributors.add(contributor);
            }
            if (contributor.getInstanceDataElementsPriority() == 0) continue;
            instanceDataContributors.add(contributor);
        }
        Collections.sort(rootContributors, (contributor1, contributor2) -> Integer.compare(contributor1.getRootElementsPriority(), contributor2.getRootElementsPriority()));
        Collections.sort(instanceDataContributors, (contributor1, contributor2) -> Integer.compare(contributor1.getInstanceDataElementsPriority(), contributor2.getInstanceDataElementsPriority()));
        return new NetworkViewContentProvider(rootContributors, instanceDataContributors);
    }

    private List<NetworkViewContributor> defineContributors() {
        ArrayList<NetworkViewContributor> result = new ArrayList<NetworkViewContributor>();
        this.networkConnectionsContributor = new ConnectionSetupsListContributor();
        this.sshUplinkConnectionsContributor = new SshUplinkConnectionSetupsListContributor(node -> this.updatePossibleActionsForSelection(node));
        this.sshConnectionsContributor = new SshConnectionSetupsListContributor(node -> this.updatePossibleActionsForSelection(node));
        this.infoContributer = new InstanceComponentsInfoContributor();
        result.add(this.networkConnectionsContributor);
        result.add(new MonitoringDataContributor());
        result.add(this.infoContributer);
        result.add(this.sshUplinkConnectionsContributor);
        result.add(this.sshConnectionsContributor);
        return result;
    }

    private void registerSelectionListeners() {
        this.disableAllActions();
        this.viewer.addSelectionChangedListener(event -> {
            if (this.viewer.getControl().isDisposed()) {
                return;
            }
            Object node = this.getSelectedTreeNode();
            if (node != null) {
                this.updatePossibleActionsForSelection(node);
            } else {
                this.disableAllActions();
            }
        });
    }

    private void registerChangeListeners() {
        this.serviceRegistryAccess.registerService(NetworkTopologyChangeListener.class, (Object)new NetworkTopologyChangeListenerAdapter(){

            public void onReachableNetworkChanged(NetworkGraph networkGraph) {
                NetworkView.this.display.asyncExec(() -> {
                    ((NetworkView)NetworkView.this).model.networkGraph = networkGraph;
                    NetworkView.this.model.updateGraphWithProperties();
                    if (NetworkView.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    TreePath[] expandedTreePaths = NetworkView.this.viewer.getExpandedTreePaths();
                    NetworkView.this.viewer.refresh((Object)AnchorPoints.INSTANCES_PARENT_NODE, false);
                    NetworkView.this.viewer.setExpandedTreePaths(expandedTreePaths);
                });
            }
        });
        this.serviceRegistryAccess.registerService(NodePropertiesChangeListener.class, (Object)new NodePropertiesChangeListenerAdapter(){

            public void onNodePropertyMapsOfNodesChanged(Map<InstanceNodeSessionId, Map<String, String>> updatedPropertyMaps) {
                NetworkView.this.display.asyncExec(() -> {
                    ((NetworkView)NetworkView.this).model.nodeProperties.putAll(updatedPropertyMaps);
                    NetworkView.this.model.updateGraphWithProperties();
                    if (NetworkView.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    TreePath[] expandedTreePaths = NetworkView.this.viewer.getExpandedTreePaths();
                    NetworkView.this.viewer.refresh((Object)AnchorPoints.INSTANCES_PARENT_NODE);
                    NetworkView.this.viewer.setExpandedTreePaths(expandedTreePaths);
                });
            }
        });
        this.serviceRegistryAccess.registerService(DistributedComponentKnowledgeListener.class, (Object)new DistributedComponentKnowledgeListener(){

            public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newKnowledge) {
                NetworkView.this.display.asyncExec(() -> {
                    ((NetworkView)NetworkView.this).model.componentKnowledge = newKnowledge;
                    if (NetworkView.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    TreePath[] expandedTreePaths = NetworkView.this.viewer.getExpandedTreePaths();
                    NetworkView.this.viewer.refresh((Object)AnchorPoints.INSTANCES_PARENT_NODE);
                    NetworkView.this.viewer.setExpandedTreePaths(expandedTreePaths);
                });
            }
        });
        this.serviceRegistryAccess.registerService(ConnectionSetupListener.class, (Object)new ConnectionSetupListenerAdapter(){

            public void onCollectionChanged(Collection<ConnectionSetup> setups) {
                NetworkView.this.display.asyncExec(() -> {
                    ((NetworkView)NetworkView.this).model.connectionSetups = setups;
                    if (NetworkView.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    NetworkView.this.viewer.refresh(NetworkView.this.networkConnectionsContributor.getFullRefreshRootElement(), false);
                    NetworkView.this.viewer.setExpandedState(NetworkView.this.networkConnectionsContributor.getRootElementToExpand(), true);
                });
            }

            public void onStateChanged(ConnectionSetup setup, ConnectionSetupState oldState, ConnectionSetupState newState) {
                NetworkView.this.display.asyncExec(() -> this.tryUpdatePossibleActionsForSelection(setup));
            }

            private void tryUpdatePossibleActionsForSelection(ConnectionSetup setup) {
                if (NetworkView.this.viewer.getControl().isDisposed()) {
                    return;
                }
                Object node = NetworkView.this.networkConnectionsContributor.getTreeNodeForSetup(setup);
                if (node != null) {
                    if (node.equals(NetworkView.this.getSelectedTreeNode())) {
                        NetworkView.this.updatePossibleActionsForSelection(node);
                    }
                    NetworkView.this.viewer.update(node, null);
                }
            }
        });
    }

    private Object getSelectedTreeNode() {
        ISelection rawSelection = this.viewer.getSelection();
        if (rawSelection instanceof TreeSelection) {
            TreeSelection selection = (TreeSelection)rawSelection;
            return selection.getFirstElement();
        }
        return null;
    }

    private void updatePossibleActionsForSelection(Object node) {
        if (node == null) {
            this.disableAllActions();
            return;
        }
        if (node instanceof StandardUserNodeActionNode) {
            StandardUserNodeActionNode typedNode = (StandardUserNodeActionNode)node;
            this.startAction.setEnabled(typedNode.isActionApplicable(StandardUserNodeActionType.START));
            this.stopAction.setEnabled(typedNode.isActionApplicable(StandardUserNodeActionType.STOP));
            this.editAction.setEnabled(typedNode.isActionApplicable(StandardUserNodeActionType.EDIT));
            this.deleteAction.setEnabled(typedNode.isActionApplicable(StandardUserNodeActionType.DELETE));
            this.copyToClipBoardAction.setEnabled(typedNode.isActionApplicable(StandardUserNodeActionType.COPY_TO_CLIPBOARD));
        } else if (node instanceof NetworkGraphNodeWithContext) {
            this.disableAllActions();
            NetworkGraphNodeWithContext typedNode = (NetworkGraphNodeWithContext)node;
            if (typedNode.getContext() == NetworkGraphNodeWithContext.Context.RAW_NODE_PROPERTY || typedNode.getContext() == NetworkGraphNodeWithContext.Context.RAW_NODE_PROPERTIES_FOLDER) {
                this.copyToClipBoardAction.setEnabled(true);
            }
        } else {
            this.disableAllActions();
        }
    }

    private void disableAllActions() {
        this.editAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.startAction.setEnabled(false);
        this.stopAction.setEnabled(false);
        this.copyToClipBoardAction.setEnabled(false);
    }

    private void executeStandardUserNodeAction(StandardUserNodeActionType actionType) {
        Object node = this.getSelectedTreeNode();
        if (node instanceof StandardUserNodeActionNode) {
            StandardUserNodeActionNode typedNode = (StandardUserNodeActionNode)node;
            if (typedNode.isActionApplicable(actionType)) {
                typedNode.performAction(actionType);
            } else {
                this.updatePossibleActionsForSelection(typedNode);
            }
        }
    }

    private void addToolbarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.addNetworkConnectionAction);
        toolBarManager.add((IAction)this.addUplinkConnectionAction);
        toolBarManager.add((IAction)this.addSSHConnectionAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.startAction);
        toolBarManager.add((IAction)this.stopAction);
        toolBarManager.add((IAction)this.editAction);
        toolBarManager.add((IAction)this.deleteAction);
    }

    private void hookContextMenu() {
        MenuManager subMenuManager = new MenuManager("Advanced");
        subMenuManager.add((IAction)this.toggleNodeIdsVisibleAction);
        subMenuManager.add((IAction)this.toggleRawNodePropertiesVisibleAction);
        subMenuManager.add((IAction)this.toggleFullGroupNamesAction);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)this.addNetworkConnectionAction);
        menuManager.add((IAction)this.addUplinkConnectionAction);
        menuManager.add((IAction)this.addSSHConnectionAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.startAction);
        menuManager.add((IAction)this.stopAction);
        menuManager.add((IAction)this.editAction);
        menuManager.add((IAction)this.deleteAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.copyToClipBoardAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)subMenuManager);
        menuManager.updateAll(true);
        Menu menu = menuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void expandSelectedNode() {
        Object selectedTreeNode = this.getSelectedTreeNode();
        if (selectedTreeNode == null) {
            return;
        }
        if (this.viewer.getExpandedState(selectedTreeNode)) {
            this.viewer.collapseToLevel(selectedTreeNode, 1);
        } else {
            this.viewer.expandToLevel(selectedTreeNode, 1);
        }
    }

    private final class NetworkViewKeyListener
    extends KeyAdapter {
        private NetworkViewKeyListener() {
        }

        public void keyPressed(KeyEvent event) {
            if (event.stateMask == 262144) {
                if (event.keyCode == 99) {
                    NetworkView.this.copyToClipBoardAction.run();
                }
            } else if (event.keyCode == 127) {
                NetworkView.this.deleteAction.run();
            }
        }
    }
}

