/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.nodeproperties.internal;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.channel.MessageChannelLifecycleListenerAdapter;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.channel.MessageChannelState;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandler;
import de.rcenvironment.core.communication.messaging.NetworkRequestHandlerMap;
import de.rcenvironment.core.communication.messaging.direct.api.DirectMessagingSender;
import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.model.NetworkMessage;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.NetworkResponseHandler;
import de.rcenvironment.core.communication.nodeproperties.NodePropertiesService;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.internal.NodePropertiesRegistry;
import de.rcenvironment.core.communication.nodeproperties.internal.NodePropertyImpl;
import de.rcenvironment.core.communication.nodeproperties.spi.RawNodePropertiesChangeListener;
import de.rcenvironment.core.communication.protocol.NetworkRequestFactory;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.transport.spi.MessageChannel;
import de.rcenvironment.core.communication.utils.MessageUtils;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.RestartSafeIncreasingValueGenerator;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodePropertiesServiceImpl
implements NodePropertiesService {
    private static final String MESSAGE_SUBTYPE_INITIAL = "init";
    private static final String MESSAGE_SUBTYPE_INCREMENTAL = "delta";
    private static final int MAX_DELTA_BATCH_SIZE = 25;
    private static final int MAX_DELTA_BATCH_LATENCY = 150;
    private final Object knowledgeLock = new Object();
    private final NodePropertiesRegistry completeKnowledgeRegistry;
    private final NodePropertiesRegistry locallyPublishedKnowledgeRegistry;
    private final RestartSafeIncreasingValueGenerator timeKeeper = new RestartSafeIncreasingValueGenerator();
    private final AsyncOrderedCallbackManager<RawNodePropertiesChangeListener> callbackManager;
    private NetworkRequestHandler networkRequestHandler;
    private MessageChannelService connectionService;
    private DirectMessagingSender directMessagingSender;
    private InstanceNodeSessionId localNodeSessionId;
    private NodeConfigurationService nodeConfigurationService;
    private final AsyncTaskService threadPool = ConcurrencyUtils.getAsyncTaskService();
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled((String)"NodeProperties");
    private final BatchAggregator<UpdateDeltaForBroadcasting> deltaBroadcastAggregator;
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean localNodeIsRelay;
    private NodeIdentifierService nodeIdentifierService;
    private String localInstanceNodeId;

    public NodePropertiesServiceImpl() {
        this.completeKnowledgeRegistry = new NodePropertiesRegistry();
        this.locallyPublishedKnowledgeRegistry = new NodePropertiesRegistry();
        this.callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
        this.networkRequestHandler = new NetworkRequestHandler(){

            @Override
            public NetworkResponse handleRequest(NetworkRequest request, InstanceNodeSessionId lastHopNodeId) throws InternalMessagingException {
                return NodePropertiesServiceImpl.this.handleIncomingPropertiesUpdate(request);
            }
        };
        this.deltaBroadcastAggregator = ConcurrencyUtils.getFactory().createBatchAggregator(25, 150L, (BatchProcessor)new BatchProcessor<UpdateDeltaForBroadcasting>(){
            private final AtomicInteger counter = new AtomicInteger();

            public void processBatch(List<UpdateDeltaForBroadcasting> batch) {
                int batchId = this.counter.incrementAndGet();
                if (batch.size() == 1) {
                    UpdateDeltaForBroadcasting singleDelta = batch.get(0);
                    NodePropertiesServiceImpl.this.broadcastToAllNeighboursExcept(NodePropertiesServiceImpl.MESSAGE_SUBTYPE_INCREMENTAL, singleDelta.properties, singleDelta.recipientExclusion, batchId);
                } else {
                    NodePropertiesServiceImpl.this.broadcastIndividualMergedUpdates(NodePropertiesServiceImpl.MESSAGE_SUBTYPE_INCREMENTAL, batch, batchId);
                }
                StatsCounter.registerValue((String)"Node property updates", (String)"Number of aggregated deltas per batch", (long)batch.size());
            }
        });
        this.addRawNodePropertiesChangeListener(new RawNodePropertiesChangeListener(){

            @Override
            public void onRawNodePropertiesAddedOrModified(Collection<? extends NodeProperty> newProperties) {
                if (NodePropertiesServiceImpl.this.verboseLogging) {
                    int i = 1;
                    for (NodeProperty nodeProperty : newProperties) {
                        NodePropertiesServiceImpl.this.log.debug((Object)StringUtils.format((String)"Raw node property change (%d/%d) received by %s, published by %s: '%s' := '%s' [%d]", (Object[])new Object[]{i++, newProperties.size(), NodePropertiesServiceImpl.this.localNodeSessionId.getInstanceNodeSessionIdString(), nodeProperty.getInstanceNodeSessionIdString(), nodeProperty.getKey(), nodeProperty.getValue(), nodeProperty.getSequenceNo()}));
                    }
                }
            }
        });
    }

    public void activate() {
        this.localNodeSessionId = this.nodeConfigurationService.getInstanceNodeSessionId();
        this.localInstanceNodeId = this.localNodeSessionId.getInstanceNodeIdString();
        this.localNodeIsRelay = this.nodeConfigurationService.isRelay();
        this.connectionService.addChannelLifecycleListener(new MessageChannelLifecycleListenerAdapter(){

            @Override
            public void setInitialMessageChannels(Set<MessageChannel> currentChannels) {
                if (currentChannels.size() != 0) {
                    NodePropertiesServiceImpl.this.log.warn((Object)("Initial message channels not empty: " + currentChannels));
                }
            }

            @Override
            public void onOutgoingChannelEstablished(MessageChannel channel) {
                NodePropertiesServiceImpl.this.log.debug((Object)(NodePropertiesServiceImpl.this.localNodeSessionId + ": established channel (" + channel.getInitiatedByRemote() + "), sending initial node property to " + channel.getRemoteNodeInformation().getInstanceNodeSessionId()));
                if (channel.getState() == MessageChannelState.ESTABLISHED) {
                    Set<MessageChannel> allOutgoingChannels = NodePropertiesServiceImpl.this.connectionService.getAllOutgoingChannels();
                    if (!allOutgoingChannels.contains(channel)) {
                        NodePropertiesServiceImpl.this.log.warn((Object)("Channel " + channel + " established, but not contained in the 'all channels' set yet!"));
                    }
                    NodePropertiesServiceImpl.this.performInitialPropertiesExchangeViaChannel(channel);
                } else {
                    NodePropertiesServiceImpl.this.log.debug((Object)("Ignoring node property update for channel " + channel.getChannelId() + " as it is " + (Object)((Object)channel.getState())));
                }
            }
        });
    }

    public void bindMessageChannelService(MessageChannelService newInstance) {
        this.connectionService = newInstance;
        this.directMessagingSender = newInstance;
    }

    public void bindNodeConfigurationService(NodeConfigurationService newInstance) {
        this.nodeConfigurationService = newInstance;
        this.nodeIdentifierService = this.nodeConfigurationService.getNodeIdentifierService();
    }

    @Override
    public void addOrUpdateLocalNodeProperty(String key, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(key, value);
        this.addOrUpdateLocalNodeProperties(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOrUpdateLocalNodeProperties(Map<String, String> data) {
        if (data.isEmpty()) {
            this.log.debug((Object)"A node properties update was triggered with empty update data; logging stacktrace (no actual exception thrown)", (Throwable)new IllegalArgumentException());
            return;
        }
        if (this.verboseLogging) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Applying update delta to published node properties:");
            for (Map.Entry<String, String> e : data.entrySet()) {
                String value = Optional.ofNullable(e.getValue()).orElse("<null>");
                buffer.append(StringUtils.format((String)"\n  %s := %s", (Object[])new Object[]{e.getKey(), value}));
            }
            this.log.debug((Object)buffer.toString());
        }
        Object object = this.knowledgeLock;
        synchronized (object) {
            long newSequenceNo = this.timeKeeper.invalidateAndGet();
            List<NodePropertyImpl> newDelta = new ArrayList<NodePropertyImpl>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                newDelta.add(new NodePropertyImpl(this.localNodeSessionId, entry.getKey(), newSequenceNo, entry.getValue()));
            }
            this.completeKnowledgeRegistry.mergeUnchecked(newDelta);
            this.locallyPublishedKnowledgeRegistry.mergeUnchecked(newDelta);
            this.deltaBroadcastAggregator.enqueue((Object)new UpdateDeltaForBroadcasting(newDelta, null));
            newDelta = Collections.unmodifiableList(newDelta);
            this.registerContainedDisplayNameProperties(newDelta);
            this.reportImmutableDeltaToListeners(newDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getNodeProperties(InstanceNodeSessionId nodeId) {
        Object object = this.knowledgeLock;
        synchronized (object) {
            return this.completeKnowledgeRegistry.getNodeProperties(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InstanceNodeSessionId, Map<String, String>> getAllNodeProperties(Collection<InstanceNodeSessionId> nodeIds) {
        Object object = this.knowledgeLock;
        synchronized (object) {
            return this.completeKnowledgeRegistry.getAllNodeProperties(nodeIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InstanceNodeSessionId, Map<String, String>> getAllNodeProperties() {
        Object object = this.knowledgeLock;
        synchronized (object) {
            return this.completeKnowledgeRegistry.getAllNodeProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRawNodePropertiesChangeListener(RawNodePropertiesChangeListener listener) {
        Object object = this.knowledgeLock;
        synchronized (object) {
            final Collection<NodePropertyImpl> copyOfCompleteKnowledge = this.completeKnowledgeRegistry.getDetachedCopyOfEntries();
            this.callbackManager.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<RawNodePropertiesChangeListener>(){

                public void performCallback(RawNodePropertiesChangeListener listener) {
                    listener.onRawNodePropertiesAddedOrModified(copyOfCompleteKnowledge);
                }
            });
        }
    }

    @Override
    public void removeRawNodePropertiesChangeListener(RawNodePropertiesChangeListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    @Override
    public NetworkRequestHandlerMap getNetworkRequestHandlers() {
        return new NetworkRequestHandlerMap("np", this.networkRequestHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInitialPropertiesExchangeViaChannel(final MessageChannel channel) {
        Collection<NodePropertyImpl> knowledgeToPublish;
        Object object = this.knowledgeLock;
        synchronized (object) {
            knowledgeToPublish = this.localNodeIsRelay ? this.completeKnowledgeRegistry.getDetachedCopyOfEntries() : this.locallyPublishedKnowledgeRegistry.getDetachedCopyOfEntries();
        }
        NetworkRequest request = this.constructNetworkRequest(MESSAGE_SUBTYPE_INITIAL, knowledgeToPublish);
        this.directMessagingSender.sendDirectMessageAsync(request, channel, new NetworkResponseHandler(){

            @Override
            public void onResponseAvailable(NetworkResponse response) {
                InstanceNodeSessionId sender = channel.getRemoteNodeInformation().getInstanceNodeSessionId();
                if (sender == null) {
                    NodePropertiesServiceImpl.this.log.error((Object)("Consistency error: empty remote node id for channel " + channel + " after initial properties exchange"));
                }
                if (!response.isSuccess()) {
                    NodePropertiesServiceImpl.this.log.warn((Object)StringUtils.format((String)"Initial node property exchange with %s via channel %s failed: %s", (Object[])new Object[]{sender, channel.getChannelId(), response.getResultCode()}));
                    return;
                }
                try {
                    IncomingUpdate parsedUpdate = new IncomingUpdate(response);
                    Collection effectiveSubset = NodePropertiesServiceImpl.this.mergeExternalUpdateIntoFullKnowledgeAndGetEffectiveSubset(parsedUpdate);
                    if (NodePropertiesServiceImpl.this.localNodeIsRelay) {
                        NodePropertiesServiceImpl.this.log.debug((Object)("Received initial node property response from " + sender + "; forwarding to all other connected instances"));
                        NodePropertiesServiceImpl.this.forwardIfNotEmpty(sender, effectiveSubset);
                    } else {
                        NodePropertiesServiceImpl.this.log.debug((Object)("Received initial node property response from " + sender));
                    }
                }
                catch (RuntimeException e) {
                    NodePropertiesServiceImpl.this.log.warn((Object)"Failed to deserialize response for initial node property exchange", (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkResponse handleIncomingPropertiesUpdate(NetworkRequest request) throws InternalMessagingException {
        try {
            IncomingUpdate parsedUpdate = new IncomingUpdate(request);
            InstanceNodeSessionId sender = request.accessMetaData().getSender();
            Collection<NodePropertyImpl> effectiveSubset = this.mergeExternalUpdateIntoFullKnowledgeAndGetEffectiveSubset(parsedUpdate);
            if (this.localNodeIsRelay) {
                this.forwardIfNotEmpty(sender, effectiveSubset);
            }
            if (parsedUpdate.isInitialUpdate) {
                Collection<NodePropertyImpl> complementingKnowledge;
                Object object = this.knowledgeLock;
                synchronized (object) {
                    if (this.localNodeIsRelay) {
                        complementingKnowledge = this.completeKnowledgeRegistry.getComplementingKnowledge(parsedUpdate.entries);
                        this.log.debug((Object)StringUtils.format((String)"Responding to initial node property exchange with %d complementing entries (out of %d in the complete set)", (Object[])new Object[]{complementingKnowledge.size(), this.completeKnowledgeRegistry.getEntryCount()}));
                    } else {
                        complementingKnowledge = this.locallyPublishedKnowledgeRegistry.getComplementingKnowledge(parsedUpdate.entries);
                        this.log.debug((Object)StringUtils.format((String)"Responding to initial node property exchange with %d complementing entries (out of %d in the local set)", (Object[])new Object[]{complementingKnowledge.size(), this.locallyPublishedKnowledgeRegistry.getEntryCount()}));
                    }
                }
                byte[] responseBody = this.constructMessageBody(MESSAGE_SUBTYPE_INCREMENTAL, complementingKnowledge);
                return NetworkResponseFactory.generateSuccessResponse(request, responseBody);
            }
            byte[] responseBody = new byte[]{};
            return NetworkResponseFactory.generateSuccessResponse(request, responseBody);
        }
        catch (RuntimeException e) {
            throw new InternalMessagingException("Error processing node properties update", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<NodePropertyImpl> mergeExternalUpdateIntoFullKnowledgeAndGetEffectiveSubset(IncomingUpdate parsedUpdate) {
        Collection<NodePropertyImpl> effectiveSubset;
        Object object = this.knowledgeLock;
        synchronized (object) {
            Map<String, String> propertiesToRepublishOrCancel = this.checkForPropertiesToRepublishOrCancel(parsedUpdate.entries);
            if (!propertiesToRepublishOrCancel.isEmpty()) {
                this.log.debug((Object)("Publishing a cancel/republish set containing " + propertiesToRepublishOrCancel.size() + " entries"));
                this.addOrUpdateLocalNodeProperties(propertiesToRepublishOrCancel);
            }
            effectiveSubset = this.completeKnowledgeRegistry.mergeAndGetEffectiveSubset(parsedUpdate.entries);
            effectiveSubset = Collections.unmodifiableCollection(effectiveSubset);
            this.registerContainedDisplayNameProperties(effectiveSubset);
            this.reportImmutableDeltaToListeners(effectiveSubset);
        }
        return effectiveSubset;
    }

    private void registerContainedDisplayNameProperties(Collection<NodePropertyImpl> properties) {
        for (NodeProperty nodeProperty : properties) {
            if (!"displayName".equals(nodeProperty.getKey())) continue;
            String displayName = nodeProperty.getValue();
            if (this.verboseLogging) {
                this.log.debug((Object)StringUtils.format((String)"Setting associated display name for node %s to '%s'", (Object[])new Object[]{nodeProperty.getInstanceNodeSessionIdString(), displayName}));
            }
            this.nodeIdentifierService.associateDisplayName(nodeProperty.getInstanceNodeSessionId(), displayName);
        }
    }

    private Map<String, String> checkForPropertiesToRepublishOrCancel(List<NodePropertyImpl> entries) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (NodePropertyImpl receivedProperty : entries) {
            if (!this.localNodeSessionId.isSameInstanceNodeSessionAs(receivedProperty.getInstanceNodeSessionId())) continue;
            String key = receivedProperty.getKey();
            NodeProperty existingProperty = this.locallyPublishedKnowledgeRegistry.getNodeProperty(this.localNodeSessionId, key);
            if (existingProperty == null) {
                this.log.debug((Object)("Received a node property for the local node with no local counterpart (a canceling update will be published): " + receivedProperty));
                result.put(key, null);
                continue;
            }
            if (existingProperty.getSequenceNo() >= receivedProperty.getSequenceNo()) continue;
            this.log.warn((Object)"Received a node property for the local node that is 'newer' than the actual local state; is there a node with the same id in the network? (attempting to re-publish the local value)");
            this.log.warn((Object)("Local property: " + existingProperty));
            this.log.warn((Object)("Received property: " + receivedProperty));
            result.put(key, existingProperty.getValue());
        }
        return result;
    }

    private void reportImmutableDeltaToListeners(final Collection<NodePropertyImpl> immutableDelta) {
        this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<RawNodePropertiesChangeListener>(){

            public void performCallback(RawNodePropertiesChangeListener listener) {
                listener.onRawNodePropertiesAddedOrModified(immutableDelta);
            }
        });
    }

    private void forwardIfNotEmpty(InstanceNodeSessionId sender, Collection<NodePropertyImpl> effectiveSubset) {
        if (!effectiveSubset.isEmpty()) {
            this.deltaBroadcastAggregator.enqueue((Object)new UpdateDeltaForBroadcasting(effectiveSubset, sender));
        } else {
            this.log.debug((Object)(this.localNodeSessionId + ": node property update did not result in a local change; not forwarding)"));
        }
    }

    @Deprecated
    private void broadcastToAllNeighbours(String updateType, Collection<NodePropertyImpl> entries, int batchId) {
        this.broadcastToAllNeighboursExcept(updateType, entries, null, batchId);
    }

    private void broadcastToAllNeighboursExcept(String updateType, Collection<NodePropertyImpl> entries, InstanceNodeSessionId exclusion, final int batchId) {
        this.log.debug((Object)("Broadcasting non-batched node properties update " + batchId));
        Set<MessageChannel> channels = this.connectionService.getAllOutgoingChannels();
        NetworkRequest request = null;
        boolean firstRecipient = true;
        for (final MessageChannel channel : channels) {
            InstanceNodeSessionId remoteNodeId = channel.getRemoteNodeInformation().getInstanceNodeSessionId();
            if (exclusion != null && remoteNodeId.equals(exclusion)) continue;
            if (firstRecipient) {
                request = this.constructNetworkRequest(updateType, entries);
                firstRecipient = false;
            } else {
                request = NetworkRequestFactory.cloneWithNewRequestId(request);
            }
            this.directMessagingSender.sendDirectMessageAsync(request, channel, new NetworkResponseHandler(){

                @Override
                public void onResponseAvailable(NetworkResponse response) {
                    if (!response.isSuccess()) {
                        NodePropertiesServiceImpl.this.log.warn((Object)StringUtils.format((String)"Failed to send node properties update %d to %s via channel %s: %s", (Object[])new Object[]{batchId, channel.getRemoteNodeInformation().getInstanceNodeSessionId(), channel.getChannelId(), response.getResultCode().toString()}));
                    }
                }
            });
        }
    }

    private void broadcastIndividualMergedUpdates(String updateType, List<UpdateDeltaForBroadcasting> batch, final int batchId) {
        Set<MessageChannel> channels = this.connectionService.getAllOutgoingChannels();
        HashMap channelToMergedUpdateMap = new HashMap();
        for (UpdateDeltaForBroadcasting delta : batch) {
            if (delta.properties.isEmpty()) {
                this.log.warn((Object)("Node properties batch update " + batchId + " contained an empty delta; ignoring"));
                continue;
            }
            for (MessageChannel channel : channels) {
                if (delta.recipientExclusion != null && channel.getRemoteNodeInformation().getInstanceNodeSessionId() == delta.recipientExclusion) continue;
                HashMap<String, NodePropertyImpl> mergeMapForSingleRecipient = (HashMap<String, NodePropertyImpl>)channelToMergedUpdateMap.get(channel);
                if (mergeMapForSingleRecipient == null) {
                    mergeMapForSingleRecipient = new HashMap<String, NodePropertyImpl>();
                    channelToMergedUpdateMap.put(channel, mergeMapForSingleRecipient);
                }
                for (NodePropertyImpl incomingPropertyState : delta.properties) {
                    String propertyKey = incomingPropertyState.getCompositeKey().getAsUniqueString();
                    NodePropertyImpl replacedPropertyState = mergeMapForSingleRecipient.put(propertyKey, incomingPropertyState);
                    if (replacedPropertyState == null || replacedPropertyState.getSequenceNo() <= incomingPropertyState.getSequenceNo()) continue;
                    mergeMapForSingleRecipient.put(propertyKey, replacedPropertyState);
                    this.log.debug((Object)StringUtils.format((String)"Prevented an outdated property value from overwriting a newer one in batch aggregation: prevented='%s', newer='%s'", (Object[])new Object[]{incomingPropertyState, replacedPropertyState}));
                }
            }
        }
        for (final MessageChannel channel : channels) {
            Map mergeMapForSingleRecipient = (Map)channelToMergedUpdateMap.get(channel);
            if (mergeMapForSingleRecipient == null) continue;
            if (mergeMapForSingleRecipient.isEmpty()) {
                this.log.warn((Object)("Unexpected state: empty map of merged node property deltas, not sending an update via " + channel));
                continue;
            }
            NetworkRequest request = this.constructNetworkRequest(updateType, mergeMapForSingleRecipient.values());
            if (this.verboseLogging) {
                this.log.debug((Object)StringUtils.format((String)"Sending aggregated node properties update %d to %s via channel %s", (Object[])new Object[]{batchId, channel.getRemoteNodeInformation().getInstanceNodeSessionId(), channel.getChannelId()}));
            }
            this.directMessagingSender.sendDirectMessageAsync(request, channel, new NetworkResponseHandler(){

                @Override
                public void onResponseAvailable(NetworkResponse response) {
                    if (!response.isSuccess()) {
                        NodePropertiesServiceImpl.this.log.warn((Object)StringUtils.format((String)"Failed to send aggregated node properties update %d to %s via channel %s: %s", (Object[])new Object[]{batchId, channel.getRemoteNodeInformation().getInstanceNodeSessionId(), channel.getChannelId(), response.getResultCode().toString()}));
                    }
                }
            });
        }
    }

    private NetworkRequest constructNetworkRequest(String updateType, Collection<NodePropertyImpl> entries) {
        byte[] contentBytes = this.constructMessageBody(updateType, entries);
        NetworkRequest request = NetworkRequestFactory.createNetworkRequest(contentBytes, "np", this.localNodeSessionId, null);
        return request;
    }

    private byte[] constructMessageBody(String updateType, Collection<NodePropertyImpl> entries) {
        ArrayList<String> stringParts = new ArrayList<String>();
        stringParts.add(updateType);
        for (NodePropertyImpl entry : entries) {
            String compactForm = entry.toCompactForm();
            stringParts.add(compactForm);
        }
        String body = StringUtils.escapeAndConcat((String[])stringParts.toArray(new String[stringParts.size()]));
        return MessageUtils.serializeSafeObject((Serializable)((Object)body));
    }

    private final class IncomingUpdate {
        private String[] rawParts;
        private String subtype;
        private boolean isInitialUpdate;
        private List<NodePropertyImpl> entries = new ArrayList<NodePropertyImpl>();

        IncomingUpdate(NetworkMessage request) {
            try {
                this.rawParts = this.tokenizeMessageBody(request);
            }
            catch (SerializationException e) {
                throw new IllegalArgumentException("Error deserializing node property update", e);
            }
            this.subtype = null;
            String[] stringArray = this.rawParts;
            int n = this.rawParts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (this.subtype == null) {
                    this.subtype = part;
                } else {
                    try {
                        NodePropertyImpl entry = new NodePropertyImpl(part, NodePropertiesServiceImpl.this.nodeIdentifierService);
                        if (entry.getInstanceNodeSessionIdString().startsWith(NodePropertiesServiceImpl.this.localInstanceNodeId)) {
                            NodePropertiesServiceImpl.this.log.debug((Object)("Ignoring incoming node property update for the local node: " + part));
                        } else {
                            this.entries.add(entry);
                        }
                    }
                    catch (IdentifierException identifierException) {
                        NodePropertiesServiceImpl.this.log.error((Object)StringUtils.format((String)"Ignoring a node property update from %s containing a malformed instance session id; content='%s'", (Object[])new Object[]{request.accessMetaData().getSender(), part}));
                    }
                }
                ++n2;
            }
            if (NodePropertiesServiceImpl.MESSAGE_SUBTYPE_INITIAL.equals(this.subtype)) {
                this.isInitialUpdate = true;
            } else if (NodePropertiesServiceImpl.MESSAGE_SUBTYPE_INCREMENTAL.equals(this.subtype)) {
                this.isInitialUpdate = false;
            } else {
                throw new IllegalArgumentException("Invalid node property update sub-type: " + this.subtype);
            }
        }

        private String[] tokenizeMessageBody(NetworkMessage request) throws SerializationException {
            String bodyString = (String)((Object)request.getDeserializedContent());
            if (bodyString == null) {
                throw new IllegalArgumentException("Received node property update with 'null' as content");
            }
            String[] parts = StringUtils.splitAndUnescape((String)bodyString);
            return parts;
        }
    }

    private class UpdateDeltaForBroadcasting {
        private final Collection<NodePropertyImpl> properties;
        private final InstanceNodeSessionId recipientExclusion;

        UpdateDeltaForBroadcasting(Collection<NodePropertyImpl> properties, InstanceNodeSessionId recipientExclusion) {
            this.properties = properties;
            this.recipientExclusion = recipientExclusion;
        }
    }
}

