/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.connection.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.connection.api.ConnectionSetup;
import de.rcenvironment.core.communication.connection.api.ConnectionSetupService;
import de.rcenvironment.core.communication.model.NetworkContactPoint;
import de.rcenvironment.core.communication.utils.NetworkContactPointUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectionSetupCommandPlugin
implements CommandPlugin {
    private static final String CMD_CN = "cn";
    private ConnectionSetupService connectionSetupService;

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_CN, "", false, "short form of \"cn list\"", new String[0]));
        contributions.add(new CommandDescription("cn add", "<target> [\"<description>\"]", false, "add a new network connection", new String[]{"(Example: cn add activemq-tcp:rceserver.example.com:20001 \"Our RCE Server\")"}));
        contributions.add(new CommandDescription("cn list", "", false, "lists all network connections, including ids and connection states", new String[0]));
        contributions.add(new CommandDescription("cn start", "<id>", false, "starts/connects a READY or DISCONNECTED connection (use \"cn list\" to get the id)", new String[0]));
        contributions.add(new CommandDescription("cn stop", "<id>", false, "stops/disconnects an ESTABLISHED connection (use \"cn list\" to get the id)", new String[0]));
        return contributions;
    }

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(CMD_CN);
        String subCmd = context.consumeNextToken();
        if (subCmd == null) {
            this.performList(context);
        } else {
            List parameters = context.consumeRemainingTokens();
            if ("add".equals(subCmd)) {
                this.performAdd(context, parameters);
            } else if ("list".equals(subCmd)) {
                this.performList(context);
            } else if ("start".equals(subCmd)) {
                this.performStart(context, parameters);
            } else if ("stop".equals(subCmd)) {
                this.performStop(context, parameters);
            } else {
                throw CommandException.unknownCommand((CommandContext)context);
            }
        }
    }

    public void bindConnectionSetupService(ConnectionSetupService newInstance) {
        this.connectionSetupService = newInstance;
    }

    private void performList(CommandContext context) {
        Collection<ConnectionSetup> setups = this.connectionSetupService.getAllConnectionSetups();
        for (ConnectionSetup setup : setups) {
            String optionalSuffix = "";
            String currentChannelId = setup.getCurrentChannelId();
            if (currentChannelId != null) {
                optionalSuffix = " [" + currentChannelId + "]";
            }
            context.println((Object)StringUtils.format((String)"  (%d) '%s' [%s] - %s%s", (Object[])new Object[]{setup.getId(), setup.getDisplayName(), setup.getNetworkContactPointString(), setup.getState(), optionalSuffix}));
        }
    }

    private void performAdd(CommandContext context, List<String> parameters) throws CommandException {
        NetworkContactPoint ncp;
        if (parameters.size() < 1 || parameters.size() > 2) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String contactPointStr = parameters.get(0);
        try {
            ncp = NetworkContactPointUtils.parseStringRepresentation(contactPointStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            context.println((Object)("Invalid target description: " + contactPointStr));
            return;
        }
        String displayName = parameters.size() == 2 ? parameters.get(1) : "<" + contactPointStr + ">";
        if (this.connectionSetupService.connectionAlreadyExists(ncp)) {
            context.println((Object)StringUtils.format((String)"Connection setup to host '%s:%d' already exists.", (Object[])new Object[]{ncp.getHost(), ncp.getPort()}));
            return;
        }
        ConnectionSetup setup = this.connectionSetupService.createConnectionSetup(ncp, displayName, true);
        context.println((Object)("Connection added, id=" + setup.getId()));
        this.performList(context);
    }

    private void performStart(CommandContext context, List<String> parameters) {
        long id;
        if (parameters.size() < 1) {
            context.println((Object)"Error: missing connection id");
            return;
        }
        try {
            id = Long.parseLong(parameters.get(0));
        }
        catch (NumberFormatException numberFormatException) {
            context.println((Object)"Error: invalid connection id");
            return;
        }
        ConnectionSetup setup = this.connectionSetupService.getConnectionSetupById(id);
        if (setup == null) {
            context.println((Object)"Error: unknown connection id");
            return;
        }
        setup.signalStartIntent();
    }

    private void performStop(CommandContext context, List<String> parameters) {
        long id;
        if (parameters.size() < 1) {
            context.println((Object)"Error: missing connection id");
            return;
        }
        try {
            id = Long.parseLong(parameters.get(0));
        }
        catch (NumberFormatException numberFormatException) {
            context.println((Object)"Error: invalid connection id");
            return;
        }
        ConnectionSetup setup = this.connectionSetupService.getConnectionSetupById(id);
        if (setup == null) {
            context.println((Object)"Error: unknown connection id");
            return;
        }
        setup.signalStopIntent();
    }
}

