/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.headless.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.execution.api.ConsoleRowUtils;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.model.configuration.api.PlaceholdersMetaDataDefinition;
import de.rcenvironment.core.component.workflow.execution.api.FinalWorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowDescriptionValidationResult;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionContextBuilder;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionHandle;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionUtils;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowPlaceholderHandler;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowStateNotificationSubscriber;
import de.rcenvironment.core.component.workflow.execution.headless.api.ConsoleRowSubscriber;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.api.HeadlessWorkflowExecutionService;
import de.rcenvironment.core.component.workflow.execution.headless.internal.ExtendedHeadlessWorkflowExecutionContext;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionVerificationRecorder;
import de.rcenvironment.core.component.workflow.execution.headless.internal.HeadlessWorkflowExecutionVerificationResult;
import de.rcenvironment.core.component.workflow.execution.spi.SingleWorkflowStateChangeListener;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.notification.DistributedNotificationService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class HeadlessWorkflowExecutionServiceImpl
implements HeadlessWorkflowExecutionService {
    private DistributedNotificationService notificationService;
    private WorkflowExecutionService workflowExecutionService;
    private DistributedComponentKnowledgeService compKnowledgeService;
    private PlatformService platformService;
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void validatePlaceholdersFile(File placeholdersFile) throws WorkflowFileException {
        this.verifyFileExistsAndIsReadable(placeholdersFile);
        this.parsePlaceholdersFile(placeholdersFile);
    }

    @Override
    public FinalWorkflowState executeWorkflow(ExtendedHeadlessWorkflowExecutionContext wfExeContext) throws WorkflowExecutionException {
        this.startHeadlessWorkflowExecution(wfExeContext);
        return this.waitForWorkflowTerminationAndCleanup(wfExeContext);
    }

    @Override
    public WorkflowExecutionInformation startHeadlessWorkflowExecution(HeadlessWorkflowExecutionContext wfExeContext) throws WorkflowExecutionException {
        ExtendedHeadlessWorkflowExecutionContext headlessWfExeCtx = (ExtendedHeadlessWorkflowExecutionContext)wfExeContext;
        return this.startHeadlessWorkflowExecutionInternal1(headlessWfExeCtx);
    }

    @Override
    public FinalWorkflowState waitForWorkflowTerminationAndCleanup(HeadlessWorkflowExecutionContext wfExeContext) throws WorkflowExecutionException {
        ExtendedHeadlessWorkflowExecutionContext headlessWfExeCtx = (ExtendedHeadlessWorkflowExecutionContext)wfExeContext;
        FinalWorkflowState finalState = this.waitForWorkflowExecutionTermination(headlessWfExeCtx);
        this.disposeOrDeleteWorkflowIfIntended(headlessWfExeCtx, finalState.equals((Object)FinalWorkflowState.FINISHED));
        headlessWfExeCtx.unsubscribeNotificationSubscribersQuietly(this.notificationService);
        return finalState;
    }

    private WorkflowExecutionInformation startHeadlessWorkflowExecutionInternal1(ExtendedHeadlessWorkflowExecutionContext headlessWfExeCtx) throws WorkflowExecutionException {
        WorkflowExecutionInformation wfExecInfo;
        headlessWfExeCtx.addOutput(null, StringUtils.format((String)"Loading: '%s'; log directory: %s (full path: %s)", (Object[])new Object[]{headlessWfExeCtx.getWorkflowFile().getName(), headlessWfExeCtx.getLogDirectory().getAbsolutePath(), headlessWfExeCtx.getWorkflowFile().getAbsolutePath()}));
        WorkflowDescription workflowDescription = this.loadWorkflowDescriptionAndPlaceholders(headlessWfExeCtx);
        try {
            wfExecInfo = this.startHeadlessWorkflowExecutionInternal2(workflowDescription, headlessWfExeCtx);
            headlessWfExeCtx.addOutput(headlessWfExeCtx.getWorkflowExecutionContext().getExecutionIdentifier(), StringUtils.format((String)"Executing: '%s'; id: %s (full path: %s)", (Object[])new Object[]{headlessWfExeCtx.getWorkflowFile().getName(), headlessWfExeCtx.getWorkflowExecutionContext().getExecutionIdentifier(), headlessWfExeCtx.getWorkflowFile().getAbsolutePath()}));
        }
        catch (WorkflowExecutionException e) {
            headlessWfExeCtx.getTextOutputReceiver().addOutput(StringUtils.format((String)"Failed: '%s'; %s (full path: %s) ", (Object[])new Object[]{headlessWfExeCtx.getWorkflowFile().getName(), e.getMessage(), headlessWfExeCtx.getWorkflowFile().getAbsolutePath()}));
            headlessWfExeCtx.closeResourcesQuietly();
            headlessWfExeCtx.unsubscribeNotificationSubscribersQuietly(this.notificationService);
            throw e;
        }
        return wfExecInfo;
    }

    private FinalWorkflowState waitForWorkflowExecutionTermination(ExtendedHeadlessWorkflowExecutionContext headlessWfExeCtx) throws WorkflowExecutionException {
        WorkflowState finalState = null;
        try {
            finalState = headlessWfExeCtx.waitForTermination();
        }
        catch (InterruptedException interruptedException) {
            throw new WorkflowExecutionException("Received interruption signal while waiting for workflow to terminate");
        }
        headlessWfExeCtx.addOutput(StringUtils.format((String)"%s: %s", (Object[])new Object[]{headlessWfExeCtx.getWorkflowExecutionContext().getExecutionIdentifier(), finalState.getDisplayName()}), StringUtils.format((String)"%s: '%s'(full path: %s)", (Object[])new Object[]{finalState.getDisplayName(), headlessWfExeCtx.getWorkflowFile().getName(), headlessWfExeCtx.getWorkflowFile().getAbsolutePath()}));
        headlessWfExeCtx.closeResourcesQuietly();
        switch (finalState) {
            case FINISHED: {
                return FinalWorkflowState.FINISHED;
            }
            case CANCELLED: {
                return FinalWorkflowState.CANCELLED;
            }
            case FAILED: {
                return FinalWorkflowState.FAILED;
            }
            case RESULTS_REJECTED: {
                return FinalWorkflowState.RESULTS_REJECTED;
            }
            case UNKNOWN: {
                throw new WorkflowExecutionException(StringUtils.format((String)"Final state of '%s' is %s. Most likely because the connection to the workflow host node was interupted. See logs for more details.", (Object[])new Object[]{headlessWfExeCtx.getWorkflowFile().getAbsolutePath(), finalState.getDisplayName()}));
            }
        }
        throw new WorkflowExecutionException(StringUtils.format((String)"Unexpected value '%s' for final state for '%s'", (Object[])new Object[]{finalState.getDisplayName(), headlessWfExeCtx.getWorkflowFile().getAbsolutePath()}));
    }

    private void afterWorkflowExecutionTerminated(ExtendedHeadlessWorkflowExecutionContext headlessWfExeCtx, boolean behavedAsExpected) throws WorkflowExecutionException {
        this.disposeOrDeleteWorkflowIfIntended(headlessWfExeCtx, behavedAsExpected);
        headlessWfExeCtx.unsubscribeNotificationSubscribersQuietly(this.notificationService);
    }

    private void disposeOrDeleteWorkflowIfIntended(ExtendedHeadlessWorkflowExecutionContext wfHeadlessExeCtx, boolean behavedAsExpected) {
        boolean delete;
        String wfExecutionId = wfHeadlessExeCtx.getWorkflowExecutionContext().getExecutionIdentifier();
        WorkflowExecutionHandle wfExecutionHandle = wfHeadlessExeCtx.getWorkflowExecutionContext().getWorkflowExecutionHandle();
        boolean dispose = wfHeadlessExeCtx.getDisposalBehavior() == HeadlessWorkflowExecutionService.DisposalBehavior.Always || behavedAsExpected && wfHeadlessExeCtx.getDisposalBehavior() == HeadlessWorkflowExecutionService.DisposalBehavior.OnExpected;
        boolean bl = delete = wfHeadlessExeCtx.getDeletionBehavior() == HeadlessWorkflowExecutionService.DeletionBehavior.Always || behavedAsExpected && wfHeadlessExeCtx.getDeletionBehavior() == HeadlessWorkflowExecutionService.DeletionBehavior.OnExpected;
        if (delete) {
            try {
                this.deleteFromDataManagement(wfExecutionHandle);
                this.dispose(wfExecutionHandle);
                wfHeadlessExeCtx.waitForDisposal();
                try {
                    FileUtils.deleteDirectory((File)wfHeadlessExeCtx.getLogDirectory());
                }
                catch (IOException e) {
                    this.log.error((Object)("Failed to delete log directory: " + wfHeadlessExeCtx.getLogDirectory()), (Throwable)e);
                }
            }
            catch (ExecutionControllerException | RemoteOperationException | RuntimeException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to delete workflow '%s' (%s) ", (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowExecutionContext().getInstanceName(), wfExecutionId}), e);
                wfHeadlessExeCtx.reportWorkflowDisposed(WorkflowState.FAILED);
            }
            catch (InterruptedException e) {
                this.log.error((Object)StringUtils.format((String)"Received interruption signal while waiting for disposeal of workflow '%s' (%s) ", (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowExecutionContext().getInstanceName(), wfExecutionId}), (Throwable)e);
            }
        } else if (dispose) {
            try {
                this.dispose(wfExecutionHandle);
                wfHeadlessExeCtx.waitForDisposal();
            }
            catch (ExecutionControllerException | RemoteOperationException | RuntimeException e) {
                this.log.error((Object)StringUtils.format((String)"Failed to dispose workflow '%s' (%s) ", (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowExecutionContext().getInstanceName(), wfExecutionId}), e);
            }
            catch (InterruptedException e) {
                this.log.error((Object)StringUtils.format((String)"Received interruption signal while waiting for disposeal of workflow '%s' (%s) ", (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowExecutionContext().getInstanceName(), wfExecutionId}), (Throwable)e);
            }
        }
    }

    @Override
    public HeadlessWorkflowExecutionVerificationResult executeWorkflowsAndVerify(Set<HeadlessWorkflowExecutionContext> headlessWfExeCtxs, HeadlessWorkflowExecutionVerificationRecorder wfVerificationResultReorder) {
        HashSet<ExtendedHeadlessWorkflowExecutionContext> extHeadlessWfExeCtxs = new HashSet<ExtendedHeadlessWorkflowExecutionContext>();
        HashSet<ExtendedHeadlessWorkflowExecutionContext> extHeadlessWfExeCtxsExpected = new HashSet<ExtendedHeadlessWorkflowExecutionContext>();
        for (HeadlessWorkflowExecutionContext headlessWfExeCtx : headlessWfExeCtxs) {
            ExtendedHeadlessWorkflowExecutionContext extHeadlessWfExeCtx = new ExtendedHeadlessWorkflowExecutionContext();
            extHeadlessWfExeCtx.setWfFile(headlessWfExeCtx.getWorkflowFile());
            extHeadlessWfExeCtx.setLogDirectory(headlessWfExeCtx.getLogDirectory());
            extHeadlessWfExeCtx.setPlaceholdersFile(headlessWfExeCtx.getPlaceholdersFile());
            extHeadlessWfExeCtx.setTextOutputReceiver(headlessWfExeCtx.getTextOutputReceiver());
            extHeadlessWfExeCtx.setIsCompactOutput(headlessWfExeCtx.isCompactOutput());
            extHeadlessWfExeCtx.setSingleConsoleRowsProcessor(headlessWfExeCtx.getSingleConsoleRowReceiver());
            extHeadlessWfExeCtx.setDisposeBehavior(headlessWfExeCtx.getDisposalBehavior());
            extHeadlessWfExeCtx.setDeletionBehavior(headlessWfExeCtx.getDeletionBehavior());
            extHeadlessWfExeCtx.setAbortIfWorkflowUpdateRequired(headlessWfExeCtx.shouldAbortIfWorkflowUpdateRequired());
            try {
                this.startHeadlessWorkflowExecutionInternal1(extHeadlessWfExeCtx);
            }
            catch (WorkflowExecutionException e) {
                wfVerificationResultReorder.addWorkflowError(headlessWfExeCtx.getWorkflowFile(), e.getMessage());
                this.log.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            extHeadlessWfExeCtxs.add(extHeadlessWfExeCtx);
        }
        for (ExtendedHeadlessWorkflowExecutionContext extHeadlessWfExeCtx : extHeadlessWfExeCtxs) {
            try {
                FinalWorkflowState finalState = this.waitForWorkflowExecutionTermination(extHeadlessWfExeCtx);
                boolean behavedAsExpected = false;
                try {
                    behavedAsExpected = wfVerificationResultReorder.addWorkflowExecutionResult(extHeadlessWfExeCtx.getWorkflowFile(), extHeadlessWfExeCtx.getLogFiles(), finalState, extHeadlessWfExeCtx.getExecutionDuration());
                }
                catch (IOException e) {
                    wfVerificationResultReorder.addWorkflowError(extHeadlessWfExeCtx.getWorkflowFile(), e.getMessage());
                }
                if (behavedAsExpected) {
                    extHeadlessWfExeCtxsExpected.add(extHeadlessWfExeCtx);
                }
                this.afterWorkflowExecutionTerminated(extHeadlessWfExeCtx, behavedAsExpected);
            }
            catch (WorkflowExecutionException e) {
                wfVerificationResultReorder.addWorkflowError(extHeadlessWfExeCtx.getWorkflowFile(), e.getMessage());
            }
        }
        return (HeadlessWorkflowExecutionVerificationResult)((Object)wfVerificationResultReorder);
    }

    private WorkflowDescription loadWorkflowDescriptionAndPlaceholders(ExtendedHeadlessWorkflowExecutionContext headlessWfExeCtx) throws WorkflowExecutionException {
        try {
            this.verifyFileExistsAndIsReadable(headlessWfExeCtx.getWorkflowFile());
            boolean abortIfWorkflowUpdateRequired = headlessWfExeCtx.shouldAbortIfWorkflowUpdateRequired();
            WorkflowDescription workflowDescription = this.loadWorkflowDescriptionFromFileConsideringUpdates(headlessWfExeCtx.getWorkflowFile(), new HeadlessWorkflowDescriptionLoaderCallback(headlessWfExeCtx.getTextOutputReceiver()), abortIfWorkflowUpdateRequired);
            if (headlessWfExeCtx.getPlaceholdersFile() != null) {
                this.verifyFileExistsAndIsReadable(headlessWfExeCtx.getPlaceholdersFile());
            }
            this.applyPlaceholdersAndVerify(workflowDescription, headlessWfExeCtx.getPlaceholdersFile());
            return workflowDescription;
        }
        catch (WorkflowFileException e) {
            throw new WorkflowExecutionException("Failed to execute workflow", e);
        }
    }

    private WorkflowExecutionInformation startHeadlessWorkflowExecutionInternal2(WorkflowDescription wfDescription, ExtendedHeadlessWorkflowExecutionContext wfHeadlessExeCtx) throws WorkflowExecutionException {
        WorkflowExecutionInformation wfExeInfo;
        this.setupLogDirectory(wfHeadlessExeCtx);
        WorkflowExecutionUtils.replaceNullNodeIdentifiersWithActualNodeIdentifier(wfDescription, this.platformService.getLocalDefaultLogicalNodeId(), this.compKnowledgeService.getCurrentSnapshot());
        WorkflowExecutionUtils.setNodeIdentifiersToTransientInCaseOfLocalOnes(wfDescription, this.platformService.getLocalDefaultLogicalNodeId());
        wfDescription.setName(WorkflowExecutionUtils.generateDefaultNameforExecutingWorkflow(wfHeadlessExeCtx.getWorkflowFile().getName(), wfDescription));
        wfDescription.setFileName(wfHeadlessExeCtx.getWorkflowFile().getName());
        if (!this.validateAvailabilityOfNodesAndComponentsFromLocalKnowledge(wfDescription).isSucceeded()) {
            throw new WorkflowExecutionException("Workflow description invalid: " + wfHeadlessExeCtx.getWorkflowFile().getAbsolutePath());
        }
        WorkflowExecutionContextBuilder wfExeCtxBuilder = new WorkflowExecutionContextBuilder(wfDescription);
        wfExeCtxBuilder.setInstanceName(wfDescription.getName());
        wfExeCtxBuilder.setNodeIdentifierStartedExecution(this.platformService.getLocalDefaultLogicalNodeId());
        if (wfDescription.getAdditionalInformation() != null && !wfDescription.getAdditionalInformation().isEmpty()) {
            wfExeCtxBuilder.setAdditionalInformationProvidedAtStart(wfDescription.getAdditionalInformation());
        }
        WorkflowExecutionContext wfExeCtx = wfExeCtxBuilder.build();
        wfHeadlessExeCtx.setWorkflowExecutionContext(wfExeCtx);
        WorkflowStateNotificationSubscriber wfStateChangeListener = this.createWorkflowStateChangeListener(wfHeadlessExeCtx);
        try {
            ExtendedHeadlessWorkflowExecutionContext.NotificationSubscription subscriberContext = new ExtendedHeadlessWorkflowExecutionContext.NotificationSubscription(wfHeadlessExeCtx);
            subscriberContext.subscriber = wfStateChangeListener;
            subscriberContext.notificationId = "rce.component.workflow.state:" + wfExeCtx.getExecutionIdentifier();
            subscriberContext.nodeId = wfExeCtx.getNodeId();
            this.notificationService.subscribe(subscriberContext.notificationId, subscriberContext.subscriber, subscriberContext.nodeId);
            wfHeadlessExeCtx.registerNotificationSubscriptionsToUnsubscribeOnFinish(subscriberContext);
        }
        catch (RemoteOperationException e) {
            String errorMessage = "Failed to execute workflow (error while subscribing for state changes)";
            this.log.error((Object)StringUtils.format((String)"%s: %s", (Object[])new Object[]{errorMessage, wfHeadlessExeCtx.getWorkflowFile().getAbsolutePath()}), (Throwable)e);
            throw new WorkflowExecutionException(errorMessage, (Exception)((Object)e));
        }
        ConsoleRowSubscriber consoleRowSubscriber = new ConsoleRowSubscriber(wfHeadlessExeCtx, wfHeadlessExeCtx.getLogDirectory());
        this.insertLogFileMetaInformation(consoleRowSubscriber, wfExeCtx);
        wfHeadlessExeCtx.registerResourceToCloseOnFinish(consoleRowSubscriber);
        try {
            ExtendedHeadlessWorkflowExecutionContext.NotificationSubscription subscriberContext = new ExtendedHeadlessWorkflowExecutionContext.NotificationSubscription(wfHeadlessExeCtx);
            subscriberContext.subscriber = consoleRowSubscriber;
            subscriberContext.notificationId = ConsoleRowUtils.composeConsoleNotificationId((LogicalNodeId)wfExeCtx.getNodeId(), (String)wfExeCtx.getExecutionIdentifier());
            subscriberContext.nodeId = wfExeCtx.getNodeId();
            this.notificationService.subscribe(subscriberContext.notificationId, subscriberContext.subscriber, subscriberContext.nodeId);
            wfHeadlessExeCtx.registerNotificationSubscriptionsToUnsubscribeOnFinish(subscriberContext);
        }
        catch (RemoteOperationException e) {
            this.log.error((Object)("Failed to subscribe for console row output: " + wfHeadlessExeCtx.getWorkflowFile().getAbsolutePath()), (Throwable)e);
        }
        try {
            wfExeInfo = this.startWorkflowExecution(wfExeCtx);
        }
        catch (RemoteOperationException e) {
            throw new WorkflowExecutionException("Failed to execute workflow", (Exception)((Object)e));
        }
        this.log.debug((Object)StringUtils.format((String)"Created workflow from file '%s' with name '%s', with id %s on node %s", (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowFile().getName(), wfExeInfo.getInstanceName(), wfExeInfo.getExecutionIdentifier(), wfExeInfo.getNodeId()}));
        return wfExeInfo;
    }

    private void insertLogFileMetaInformation(ConsoleRowSubscriber consoleRowSubscriber, WorkflowExecutionContext wfExeCtx) {
        consoleRowSubscriber.insertMetaInformation("Log file format 1.1");
        WorkflowDescription workflowDescription = wfExeCtx.getWorkflowDescription();
        consoleRowSubscriber.insertMetaInformation("Workflow run initiated from instance " + wfExeCtx.getNodeIdStartedExecution());
        consoleRowSubscriber.insertMetaInformation("Location of workflow controller: " + workflowDescription.getControllerNode());
        for (WorkflowNode wfNode : workflowDescription.getWorkflowNodes()) {
            consoleRowSubscriber.insertMetaInformation(StringUtils.format((String)"Location of workflow component \"%s\" [%s]: %s", (Object[])new Object[]{wfNode.getName(), wfNode.getIdentifier(), wfNode.getComponentDescription().getNode()}));
        }
    }

    private WorkflowStateNotificationSubscriber createWorkflowStateChangeListener(final ExtendedHeadlessWorkflowExecutionContext wfHeadlessExeCtx) {
        final String wfExecutionId = wfHeadlessExeCtx.getWorkflowExecutionContext().getExecutionIdentifier();
        WorkflowStateNotificationSubscriber workflowStateChangeListener = new WorkflowStateNotificationSubscriber(new SingleWorkflowStateChangeListener(){

            @Override
            public void onWorkflowStateChanged(WorkflowState newState) {
                HeadlessWorkflowExecutionServiceImpl.this.log.debug((Object)StringUtils.format((String)"Received state change event for workflow '%s' (%s): %s", (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowExecutionContext().getInstanceName(), wfExecutionId, newState.getDisplayName()}));
                switch (newState) {
                    case FINISHED: 
                    case CANCELLED: 
                    case FAILED: 
                    case RESULTS_REJECTED: {
                        wfHeadlessExeCtx.reportWorkflowTerminated(newState);
                        break;
                    }
                    case DISPOSED: {
                        wfHeadlessExeCtx.reportWorkflowDisposed(newState);
                        break;
                    }
                }
            }

            @Override
            public void onWorkflowNotAliveAnymore(String errorMessage) {
                wfHeadlessExeCtx.reportWorkflowNotAliveAnymore(errorMessage);
            }
        }, wfExecutionId);
        return workflowStateChangeListener;
    }

    private void applyPlaceholdersAndVerify(WorkflowDescription workflowDescription, File placeholdersFile) throws WorkflowExecutionException, WorkflowFileException {
        Map<String, Map<String, String>> placeholderValues;
        if (placeholdersFile != null) {
            placeholderValues = this.parsePlaceholdersFile(placeholdersFile);
            this.log.debug((Object)StringUtils.format((String)"Loaded placeholder values from %s: %s", (Object[])new Object[]{placeholdersFile.getAbsolutePath(), placeholderValues}));
        } else {
            placeholderValues = new HashMap<String, Map<String, String>>();
        }
        WorkflowPlaceholderHandler placeholderDescription = WorkflowPlaceholderHandler.createPlaceholderDescriptionFromWorkflowDescription(workflowDescription, "");
        Map<String, Map<String, String>> componentTypePlaceholders = placeholderDescription.getComponentTypePlaceholders();
        if (!componentTypePlaceholders.isEmpty()) {
            throw new WorkflowExecutionException("This workflow uses component *type* placeholders which are not supported in headless execution yet");
        }
        Map<String, Map<String, String>> componentInstancePlaceholders = placeholderDescription.getComponentInstancePlaceholders();
        TreeSet<String> missingPlaceholderValues = new TreeSet<String>();
        for (WorkflowNode wn : workflowDescription.getWorkflowNodes()) {
            Map<String, String> ciPlaceholders;
            if (!wn.isEnabled()) continue;
            String compInstanceId = wn.getIdentifier();
            String componentId = wn.getComponentDescription().getIdentifier();
            Map<String, String> ciPlaceholderValues = placeholderValues.get(this.createComponentInstancePlaceholderKey(wn));
            if (ciPlaceholderValues == null) {
                ciPlaceholderValues = placeholderValues.get(componentId);
            }
            if ((ciPlaceholders = componentInstancePlaceholders.get(compInstanceId)) != null) {
                Set<String> ciPlaceholderKeys;
                Set<String> missingCIPlaceholderKeys = ciPlaceholderKeys = ciPlaceholders.keySet();
                if (ciPlaceholderValues != null) {
                    missingCIPlaceholderKeys.removeAll(ciPlaceholderValues.keySet());
                }
                this.eliminateKnownIrrelevantPlaceholders(wn, missingCIPlaceholderKeys);
                for (String missingKey : missingCIPlaceholderKeys) {
                    missingPlaceholderValues.add(StringUtils.format((String)"\"%s\" -> \"%s\" (%s)", (Object[])new Object[]{componentId, missingKey, compInstanceId}));
                }
            }
            if (ciPlaceholderValues == null || ciPlaceholderValues.isEmpty()) continue;
            this.logPlaceholderValues(wn, ciPlaceholderValues);
            wn.getComponentDescription().getConfigurationDescription().setPlaceholders(ciPlaceholderValues);
        }
        if (!missingPlaceholderValues.isEmpty()) {
            throw new WorkflowExecutionException("The workflow requires additional placeholder values (listed as <component id>/<version> -> <placeholder key> (<instance id>)): " + missingPlaceholderValues);
        }
    }

    private void setupLogDirectory(ExtendedHeadlessWorkflowExecutionContext wfHeadlessExeCtx) throws WorkflowExecutionException {
        File logDirectory = wfHeadlessExeCtx.getLogDirectory();
        logDirectory.mkdirs();
        if (!logDirectory.isDirectory()) {
            throw new WorkflowExecutionException(StringUtils.format((String)("Failed to create log directory '%s' for workflow '%s'" + logDirectory.getAbsolutePath()), (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowFile().getAbsolutePath()}));
        }
        this.log.debug((Object)StringUtils.format((String)"Writing log files for workflow '%s' to: ", (Object[])new Object[]{wfHeadlessExeCtx.getWorkflowFile().getAbsolutePath(), logDirectory.getAbsolutePath()}));
    }

    private String createComponentInstancePlaceholderKey(WorkflowNode wn) {
        return String.valueOf(wn.getComponentDescription().getIdentifier()) + "/" + wn.getName();
    }

    private void logPlaceholderValues(WorkflowNode wn, Map<String, String> cPlaceholderValues) {
        PlaceholdersMetaDataDefinition placeholderMetaDataDefinition = wn.getComponentDescription().getConfigurationDescription().getComponentConfigurationDefinition().getPlaceholderMetaDataDefinition();
        HashMap<String, String> cPlaceholderValuesToLog = new HashMap<String, String>();
        for (String cPlaceholderKey : cPlaceholderValues.keySet()) {
            if (placeholderMetaDataDefinition.decode(cPlaceholderKey)) {
                cPlaceholderValuesToLog.put(cPlaceholderKey, "*****");
                continue;
            }
            cPlaceholderValuesToLog.put(cPlaceholderKey, cPlaceholderValues.get(cPlaceholderKey));
        }
        this.log.debug((Object)StringUtils.format((String)"Applying %d placeholder value(s) to workflow node %s: %s", (Object[])new Object[]{cPlaceholderValues.size(), wn, cPlaceholderValuesToLog}));
    }

    private void eliminateKnownIrrelevantPlaceholders(WorkflowNode wn, Set<String> missingCIPlaceholderKeys) {
        Iterator<String> phKeysIterator = missingCIPlaceholderKeys.iterator();
        while (phKeysIterator.hasNext()) {
            String phKey = phKeysIterator.next();
            if (WorkflowPlaceholderHandler.isActivePlaceholder(phKey, wn.getComponentDescription().getConfigurationDescription())) continue;
            phKeysIterator.remove();
        }
    }

    private Map<String, Map<String, String>> parsePlaceholdersFile(File placeholdersFile) throws WorkflowFileException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        try {
            return (Map)mapper.readValue(placeholdersFile, (TypeReference)new TypeReference<HashMap<String, Map<String, String>>>(){});
        }
        catch (IOException e) {
            throw new WorkflowFileException(StringUtils.format((String)"Failed to parse placeholders file: %s", (Object[])new Object[]{placeholdersFile.getAbsolutePath()}), e);
        }
    }

    private void verifyFileExistsAndIsReadable(File file) throws WorkflowFileException {
        if (!file.isFile()) {
            throw new WorkflowFileException(StringUtils.format((String)"File doesn't exis: %s", (Object[])new Object[]{file.getAbsolutePath()}));
        }
        if (!file.canRead()) {
            throw new WorkflowFileException(StringUtils.format((String)"File can not be read: %s", (Object[])new Object[]{file.getAbsolutePath()}));
        }
    }

    @Override
    public WorkflowDescriptionValidationResult validateAvailabilityOfNodesAndComponentsFromLocalKnowledge(WorkflowDescription workflowDescription) {
        return this.workflowExecutionService.validateAvailabilityOfNodesAndComponentsFromLocalKnowledge(workflowDescription);
    }

    @Override
    public Map<String, String> validateRemoteWorkflowControllerVisibilityOfComponents(WorkflowDescription wfDescription) {
        return this.workflowExecutionService.validateRemoteWorkflowControllerVisibilityOfComponents(wfDescription);
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        return this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, callback);
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFileConsideringUpdates(File wfFile, WorkflowDescriptionLoaderCallback callback, boolean abortIfWorkflowUpdateRequired) throws WorkflowFileException {
        return this.workflowExecutionService.loadWorkflowDescriptionFromFileConsideringUpdates(wfFile, callback, abortIfWorkflowUpdateRequired);
    }

    @Override
    public WorkflowDescription loadWorkflowDescriptionFromFile(File wfFile, WorkflowDescriptionLoaderCallback callback) throws WorkflowFileException {
        return this.workflowExecutionService.loadWorkflowDescriptionFromFile(wfFile, callback);
    }

    @Override
    public WorkflowExecutionInformation startWorkflowExecution(WorkflowExecutionContext executionContext) throws WorkflowExecutionException, RemoteOperationException {
        return this.workflowExecutionService.startWorkflowExecution(executionContext);
    }

    @Override
    public void cancel(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.workflowExecutionService.cancel(handle);
    }

    @Override
    public void pause(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.workflowExecutionService.pause(handle);
    }

    @Override
    public void resume(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.workflowExecutionService.resume(handle);
    }

    @Override
    public void dispose(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        this.workflowExecutionService.dispose(handle);
    }

    @Override
    public void deleteFromDataManagement(WorkflowExecutionHandle handle) throws ExecutionControllerException {
        this.workflowExecutionService.deleteFromDataManagement(handle);
    }

    @Override
    public WorkflowState getWorkflowState(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        return this.workflowExecutionService.getWorkflowState(handle);
    }

    @Override
    public Long getWorkflowDataManagementId(WorkflowExecutionHandle handle) throws ExecutionControllerException, RemoteOperationException {
        return this.workflowExecutionService.getWorkflowDataManagementId(handle);
    }

    @Override
    public Set<WorkflowExecutionInformation> getLocalWorkflowExecutionInformations() {
        return this.workflowExecutionService.getLocalWorkflowExecutionInformations();
    }

    @Override
    public Set<WorkflowExecutionInformation> getWorkflowExecutionInformations() {
        return this.workflowExecutionService.getWorkflowExecutionInformations();
    }

    @Override
    public Set<WorkflowExecutionInformation> getWorkflowExecutionInformations(boolean forceRefresh) {
        return this.workflowExecutionService.getWorkflowExecutionInformations(forceRefresh);
    }

    @Reference
    public void bindDistributedNotificationService(DistributedNotificationService newService) {
        this.notificationService = newService;
    }

    @Reference
    public void bindWorkflowExecutionService(WorkflowExecutionService newService) {
        this.workflowExecutionService = newService;
    }

    @Reference
    public void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    @Reference
    public void bindDistributedComponentKnowledgeService(DistributedComponentKnowledgeService newService) {
        this.compKnowledgeService = newService;
    }
}

