/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.api.NodeIdentifierService;
import de.rcenvironment.core.communication.channel.MessageChannelService;
import de.rcenvironment.core.communication.common.IdentifierException;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.common.NetworkGraph;
import de.rcenvironment.core.communication.common.NetworkGraphLink;
import de.rcenvironment.core.communication.common.NodeIdentifierContextHolder;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.configuration.NodeConfigurationService;
import de.rcenvironment.core.communication.messaging.direct.api.DirectMessagingSender;
import de.rcenvironment.core.communication.model.InitialNodeInformation;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.NetworkResponse;
import de.rcenvironment.core.communication.model.NetworkResponseHandler;
import de.rcenvironment.core.communication.model.internal.NetworkGraphImpl;
import de.rcenvironment.core.communication.model.internal.NetworkGraphLinkImpl;
import de.rcenvironment.core.communication.protocol.MessageMetaData;
import de.rcenvironment.core.communication.protocol.NetworkRequestFactory;
import de.rcenvironment.core.communication.protocol.NetworkResponseFactory;
import de.rcenvironment.core.communication.routing.InstanceRestartAndPresenceService;
import de.rcenvironment.core.communication.routing.InstanceSessionNetworkStatus;
import de.rcenvironment.core.communication.routing.MessageRoutingService;
import de.rcenvironment.core.communication.routing.NetworkRoutingService;
import de.rcenvironment.core.communication.routing.internal.LinkStateRoutingProtocolManager;
import de.rcenvironment.core.communication.routing.internal.NetworkFormatter;
import de.rcenvironment.core.communication.routing.internal.NetworkTopologyChangeTracker;
import de.rcenvironment.core.communication.routing.internal.TopologyMap;
import de.rcenvironment.core.communication.routing.internal.WaitForResponseBlocker;
import de.rcenvironment.core.communication.routing.internal.v2.Link;
import de.rcenvironment.core.communication.routing.internal.v2.LinkState;
import de.rcenvironment.core.communication.routing.internal.v2.LinkStateKnowledgeChangeListener;
import de.rcenvironment.core.communication.routing.internal.v2.NoRouteToNodeException;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListenerAdapter;
import de.rcenvironment.core.toolkitbridge.transitional.StatsCounter;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkRoutingServiceImpl
implements NetworkRoutingService,
MessageRoutingService,
InstanceRestartAndPresenceService,
AdditionalServicesProvider {
    private InitialNodeInformation ownNodeInformation;
    private MessageChannelService messageChannelService;
    private DirectMessagingSender directMessagingSender;
    private NodeConfigurationService nodeConfigurationService;
    private LinkStateRoutingProtocolManager protocolManager;
    private volatile NetworkGraphImpl cachedRawNetworkGraph;
    private volatile NetworkGraphImpl cachedReachableNetworkGraph;
    private InstanceNodeSessionId localInstanceSessionId;
    private TopologyMap topologyMap;
    private final NetworkTopologyChangeTracker topologyChangeTracker = new NetworkTopologyChangeTracker();
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final boolean forceLocalRPCSerialization = System.getProperty("rce.internal.forceLocalRPCSerialization") != null;
    private final Log log = LogFactory.getLog(this.getClass());
    private int routedRequestTimeoutMsec;
    private int forwardingTimeoutMsec;
    private NodeIdentifierService nodeIdentifierService;

    public void activate() {
        this.ownNodeInformation = this.nodeConfigurationService.getInitialNodeInformation();
        this.routedRequestTimeoutMsec = this.nodeConfigurationService.getRequestTimeoutMsec();
        this.forwardingTimeoutMsec = this.nodeConfigurationService.getForwardingTimeoutMsec();
        this.localInstanceSessionId = this.ownNodeInformation.getInstanceNodeSessionId();
        NetworkGraphImpl initialRawNetworkGraph = new NetworkGraphImpl(this.localInstanceSessionId);
        this.updateFromRawNetworkGraph(initialRawNetworkGraph);
        this.topologyChangeTracker.updateReachableNetwork(this.cachedReachableNetworkGraph);
        this.messageChannelService.setForwardingService(this);
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> result = new ArrayList<AdditionalServiceDeclaration>();
        result.add(new AdditionalServiceDeclaration(LinkStateKnowledgeChangeListener.class, (Object)new LinkStateKnowledgeChangeTracker()));
        return result;
    }

    @Override
    public NetworkResponse performRoutedRequest(byte[] payload, String messageType, InstanceNodeSessionId receiver) {
        NodeIdentifierService previousService = NodeIdentifierContextHolder.setDeserializationServiceForCurrentThread(this.nodeIdentifierService);
        try {
            NetworkResponse networkResponse = this.performRoutedRequest(payload, messageType, receiver, this.routedRequestTimeoutMsec);
            return networkResponse;
        }
        finally {
            NodeIdentifierContextHolder.setDeserializationServiceForCurrentThread(previousService);
        }
    }

    @Override
    public NetworkResponse performRoutedRequest(byte[] payload, String messageType, InstanceNodeSessionId receiver, int timeoutMsec) {
        NetworkRequest request = NetworkRequestFactory.createNetworkRequest(payload, messageType, this.localInstanceSessionId, receiver);
        if (this.forceLocalRPCSerialization && receiver.equals(this.localInstanceSessionId)) {
            return this.messageChannelService.handleLocalForcedSerializationRPC(request, this.localInstanceSessionId);
        }
        return this.sendToNextHopAndAwaitResponse(request, timeoutMsec);
    }

    @Override
    public NetworkResponse forwardAndAwait(NetworkRequest forwardingRequest) {
        return this.forwardToNextHop(forwardingRequest);
    }

    @Override
    public List<? extends NetworkGraphLink> getRouteTo(InstanceNodeSessionId destination) {
        return this.cachedReachableNetworkGraph.getRoutingInformation().getRouteTo(destination);
    }

    @Override
    public synchronized NetworkGraph getRawNetworkGraph() {
        return this.cachedRawNetworkGraph;
    }

    @Override
    public synchronized NetworkGraph getReachableNetworkGraph() {
        return this.cachedReachableNetworkGraph;
    }

    @Override
    public LinkStateRoutingProtocolManager getProtocolManager() {
        return this.protocolManager;
    }

    public void bindMessageChannelService(MessageChannelService service) {
        if (this.messageChannelService != null) {
            throw new IllegalStateException();
        }
        this.messageChannelService = service;
        this.directMessagingSender = service;
    }

    public void bindNodeConfigurationService(NodeConfigurationService service) {
        if (this.nodeConfigurationService != null) {
            throw new IllegalStateException();
        }
        this.nodeConfigurationService = service;
        this.nodeIdentifierService = this.nodeConfigurationService.getNodeIdentifierService();
    }

    public void addNetworkTopologyChangeListener(NetworkTopologyChangeListener listener) {
        this.topologyChangeTracker.addListener(listener);
    }

    public void removeNetworkTopologyChangeListener(NetworkTopologyChangeListener listener) {
        this.topologyChangeTracker.removeListener(listener);
    }

    @Override
    public String getFormattedNetworkInformation(String type) {
        if ("info".equals(type)) {
            return NetworkFormatter.networkGraphToConsoleInfo(this.cachedReachableNetworkGraph);
        }
        if ("graphviz".equals(type)) {
            return NetworkFormatter.networkGraphToGraphviz(this.cachedReachableNetworkGraph, true);
        }
        if ("graphviz-all".equals(type)) {
            return NetworkFormatter.networkGraphToGraphviz(this.cachedRawNetworkGraph, true);
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    @Override
    public InstanceSessionNetworkStatus queryInstanceSessionNetworkStatus(InstanceNodeSessionId lookupId) {
        return this.topologyChangeTracker.queryInstanceSessionNetworkStatus(lookupId);
    }

    protected synchronized void updateFromRawNetworkGraph(NetworkGraphImpl rawNetworkGraph) {
        this.cachedRawNetworkGraph = rawNetworkGraph;
        this.cachedReachableNetworkGraph = rawNetworkGraph.reduceToReachableGraph();
        if (this.verboseLogging) {
            this.log.debug((Object)StringUtils.format((String)"Updating %s with a raw graph of %d nodes and %d edges resulted in a reachable graph of %d nodes and %d edges", (Object[])new Object[]{this.localInstanceSessionId, rawNetworkGraph.getNodeCount(), rawNetworkGraph.getLinkCount(), this.cachedReachableNetworkGraph.getNodeCount(), this.cachedReachableNetworkGraph.getLinkCount()}));
        }
        StatsCounter.count((String)"Network topology/routing", (String)"Network graph changes");
        if (this.topologyChangeTracker.updateReachableNetwork(this.cachedReachableNetworkGraph)) {
            StatsCounter.count((String)"Network topology/routing", (String)"Set of reachable nodes changes");
        } else if (this.verboseLogging) {
            this.log.debug((Object)"Ignoring low-level topology change event, as it had no effect on the set of reachable nodes");
        }
    }

    private NetworkResponse forwardToNextHop(NetworkRequest forwardingRequest) {
        MessageMetaData metadata = forwardingRequest.accessMetaData();
        String requestId = forwardingRequest.getRequestId();
        String localNodeIdString = this.localInstanceSessionId.getInstanceNodeSessionIdString();
        String sender = metadata.getSenderIdString();
        String receiver = metadata.getFinalRecipientIdString();
        NetworkResponse response = this.sendToNextHopAndAwaitResponse(forwardingRequest, this.forwardingTimeoutMsec);
        if (response == null) {
            throw new IllegalStateException(StringUtils.format((String)"NULL response after forwarding message from %s to %s at %s (ReqId=%s)", (Object[])new Object[]{sender, receiver, localNodeIdString, requestId}));
        }
        return response;
    }

    private NetworkResponse sendToNextHopAndAwaitResponse(NetworkRequest request, int timeoutMsec) {
        WaitForResponseBlocker responseBlocker = new WaitForResponseBlocker(request, this.localInstanceSessionId);
        this.sendToNextHopAsync(request, responseBlocker);
        return responseBlocker.await(timeoutMsec);
    }

    private void sendToNextHopAsync(NetworkRequest request, NetworkResponseHandler responseHandler) {
        NetworkGraphLink nextLink;
        InstanceNodeSessionId receiver = request.accessMetaData().getFinalRecipient();
        try {
            nextLink = this.cachedReachableNetworkGraph.getRoutingInformation().getNextLinkTowards(receiver);
        }
        catch (NoRouteToNodeException noRouteToNodeException) {
            NetworkResponse response;
            InstanceNodeSessionId sender = request.accessMetaData().getSender();
            this.log.debug((Object)StringUtils.format((String)"Found no route for a request from %s to %s (type=%s, trace=%s)", (Object[])new Object[]{sender, receiver, request.getMessageType(), request.accessMetaData().getTrace()}));
            InstanceSessionNetworkStatus instanceSessionState = this.topologyChangeTracker.queryInstanceSessionNetworkStatus(receiver);
            InstanceSessionNetworkStatus.State state = instanceSessionState.getState();
            switch (state) {
                case NOT_PRESENT: {
                    if (this.localInstanceSessionId.equals(sender)) {
                        response = NetworkResponseFactory.generateResponseForNoRouteAtSender(request, this.localInstanceSessionId);
                        break;
                    }
                    response = NetworkResponseFactory.generateResponseForNoRouteWhileForwarding(request, this.localInstanceSessionId);
                    break;
                }
                case PRESENT: {
                    this.log.warn((Object)"Unusual situation: a network request failed because no route to the target node was found, but it is considered visible in the current network");
                    if (this.localInstanceSessionId.equals(sender)) {
                        response = NetworkResponseFactory.generateResponseForNoRouteAtSender(request, this.localInstanceSessionId);
                        break;
                    }
                    response = NetworkResponseFactory.generateResponseForNoRouteWhileForwarding(request, this.localInstanceSessionId);
                    break;
                }
                case PRESENT_WITH_DIFFERENT_SESSION: {
                    this.log.warn((Object)("Attempting for forward a network message to " + receiver + ", but the remote node was restarted; its new session id is " + instanceSessionState.getOtherId()));
                    response = NetworkResponseFactory.generateResponseForTargetNodeWasRestarted(request, this.localInstanceSessionId);
                    break;
                }
                case ID_COLLISION: {
                    this.log.error((Object)("There is more than one node with the same instance id within the network; this is not allowed. A typical cause for this is when entire profiles are copied (including their internal storage), and the copies are being used at the same time. Node 1: " + instanceSessionState.getQueriedId() + ", Node 2: " + instanceSessionState.getOtherId()));
                    response = NetworkResponseFactory.generateResponseForInstanceIdCollision(request, this.localInstanceSessionId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            responseHandler.onResponseAvailable(response);
            return;
        }
        this.sendDirectMessageAsync(request, nextLink, responseHandler);
    }

    private void sendDirectMessageAsync(NetworkRequest request, NetworkGraphLink link, final NetworkResponseHandler outerResponseHander) {
        if (outerResponseHander == null) {
            throw new IllegalArgumentException("Outer response handler must not be null");
        }
        NetworkResponseHandler responseHandler = new NetworkResponseHandler(){

            @Override
            public void onResponseAvailable(NetworkResponse response) {
                outerResponseHander.onResponseAvailable(response);
            }
        };
        this.directMessagingSender.sendDirectMessageAsync(request, link.getLinkId(), responseHandler);
    }

    private final class LinkStateKnowledgeChangeTracker
    implements LinkStateKnowledgeChangeListener {
        private LinkStateKnowledgeChangeTracker() {
        }

        @Override
        public void onLinkStateKnowledgeChanged(Map<InstanceNodeSessionId, LinkState> knowledge) {
            if (NetworkRoutingServiceImpl.this.verboseLogging) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(StringUtils.format((String)"New link state knowledge of %s (%d entries):", (Object[])new Object[]{NetworkRoutingServiceImpl.this.localInstanceSessionId, knowledge.size()}));
                for (Map.Entry<InstanceNodeSessionId, LinkState> entry : knowledge.entrySet()) {
                    buffer.append(StringUtils.format((String)"\n  Link state for %s: %s", (Object[])new Object[]{entry.getKey(), entry.getValue()}));
                }
                NetworkRoutingServiceImpl.this.log.debug((Object)buffer.toString());
            }
            if (knowledge.size() == 0) {
                return;
            }
            if (NetworkRoutingServiceImpl.this.localInstanceSessionId == null) {
                throw new IllegalStateException();
            }
            NetworkGraphImpl rawGraph = new NetworkGraphImpl(NetworkRoutingServiceImpl.this.localInstanceSessionId);
            Set<InstanceNodeSessionId> nodeIdsWithLinkState = knowledge.keySet();
            for (InstanceNodeSessionId nodeId : nodeIdsWithLinkState) {
                if (nodeId == null) {
                    throw new IllegalArgumentException("Map contained 'null' node id");
                }
                this.addNode(rawGraph, nodeId);
            }
            int expectedGraphSize = knowledge.size();
            if (!knowledge.containsKey(NetworkRoutingServiceImpl.this.localInstanceSessionId)) {
                ++expectedGraphSize;
            }
            if (rawGraph.getNodeCount() != expectedGraphSize) {
                throw new IllegalStateException(StringUtils.format((String)"Graph with %d nodes constructed, but expectes size was %d", (Object[])new Object[]{rawGraph.getNodeCount(), NetworkRoutingServiceImpl.this.localInstanceSessionId}));
            }
            int totalLinks = 0;
            for (Map.Entry<InstanceNodeSessionId, LinkState> entry : knowledge.entrySet()) {
                InstanceNodeSessionId sourceNodeId = entry.getKey();
                LinkState linkState = entry.getValue();
                List<Link> links = linkState.getLinks();
                this.addLinks(rawGraph, sourceNodeId, links);
                totalLinks += linkState.getLinks().size();
            }
            if (rawGraph.getLinkCount() != totalLinks) {
                throw new IllegalStateException();
            }
            NetworkRoutingServiceImpl.this.updateFromRawNetworkGraph(rawGraph);
        }

        private void addNode(NetworkGraphImpl rawGraph, InstanceNodeSessionId nodeId) {
            rawGraph.addNode(nodeId);
        }

        private void addLinks(NetworkGraphImpl rawGraph, InstanceNodeSessionId sourceNodeId, List<Link> links) {
            for (Link link : links) {
                InstanceNodeSessionId targetNodeId;
                try {
                    targetNodeId = NetworkRoutingServiceImpl.this.nodeIdentifierService.parseInstanceNodeSessionIdString(link.getNodeIdString());
                }
                catch (IdentifierException e) {
                    throw NodeIdentifierUtils.wrapIdentifierException(e);
                }
                rawGraph.addLink(new NetworkGraphLinkImpl(link.getLinkId(), sourceNodeId, targetNodeId));
            }
        }

        @Override
        public void onLinkStatesUpdated(Map<InstanceNodeSessionId, LinkState> delta) {
            if (NetworkRoutingServiceImpl.this.verboseLogging) {
                NetworkRoutingServiceImpl.this.log.debug((Object)("Updated link states for " + delta.size() + " nodes: " + delta.keySet()));
            }
        }

        @Override
        public void onLocalLinkStateUpdated(LinkState linkState) {
            if (NetworkRoutingServiceImpl.this.verboseLogging) {
                NetworkRoutingServiceImpl.this.log.debug((Object)("Local link state updated (for " + NetworkRoutingServiceImpl.this.localInstanceSessionId + "): " + linkState));
            }
        }
    }

    private class LowLevelNetworkTopologyChangeHandler
    extends NetworkTopologyChangeListenerAdapter {
        private LowLevelNetworkTopologyChangeHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNetworkTopologyChanged() {
            TopologyMap topologyMap = NetworkRoutingServiceImpl.this.topologyMap;
            synchronized (topologyMap) {
                NetworkRoutingServiceImpl.this.log.debug((Object)StringUtils.format((String)"Low-level topology change detected; the topology map of %s now contains %d node(s) and %d connection(s)", (Object[])new Object[]{NetworkRoutingServiceImpl.this.localInstanceSessionId, NetworkRoutingServiceImpl.this.topologyMap.getNodeCount(), NetworkRoutingServiceImpl.this.topologyMap.getLinkCount()}));
                NetworkGraphImpl cfr_ignored_0 = (NetworkGraphImpl)NetworkRoutingServiceImpl.this.topologyMap.toRawNetworkGraph();
            }
        }
    }
}

