/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import de.rcenvironment.core.component.model.configuration.api.PlaceholdersMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class PlaceholderSortUtils {
    private PlaceholderSortUtils() {
    }

    public static List<String> sortInstancesWithPlaceholderByName(List<String> instancesWithPlaceholder, WorkflowDescription workflowDescription) {
        LinkedList<String> sortedList = new LinkedList<String>();
        for (String identifier : instancesWithPlaceholder) {
            String componentName = workflowDescription.getWorkflowNode(identifier).getName();
            int i = 0;
            while (i < sortedList.size() && workflowDescription.getWorkflowNode((String)sortedList.get(i)).getName().compareToIgnoreCase(componentName) < 0) {
                ++i;
            }
            sortedList.add(i, identifier);
        }
        return sortedList;
    }

    public static List<String> getPlaceholderOrder(Set<String> placeholderNameKeysOfComponentID, PlaceholdersMetaDataDefinition metaData) {
        HashMap<Integer, ArrayList<String>> prioLists = new HashMap<Integer, ArrayList<String>>();
        if (placeholderNameKeysOfComponentID != null) {
            for (String componentPlaceholder : placeholderNameKeysOfComponentID) {
                int prio = metaData.getGuiPosition(componentPlaceholder);
                ArrayList<String> prioList = (ArrayList<String>)prioLists.get(prio);
                if (prioList == null) {
                    prioList = new ArrayList<String>();
                    prioLists.put(prio, prioList);
                }
                prioList.add(componentPlaceholder);
            }
        } else {
            prioLists = null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (prioLists != null && !prioLists.isEmpty()) {
            ArrayList prioCategories = new ArrayList(prioLists.keySet());
            Collections.sort(prioCategories);
            for (Integer i : prioCategories) {
                List current = (List)prioLists.get(i);
                Collections.sort(current);
                result.addAll(current);
            }
        }
        return result;
    }
}

