/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import com.jcraft.jsch.JSchException;
import de.rcenvironment.core.instancemanagement.InstanceManagementService;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.core.utils.ssh.jsch.SshParameterException;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ExternalServiceHolder;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;

public abstract class AbstractStepDefinitionBase {
    protected final TestScenarioExecutionContext executionContext;
    protected final TextOutputReceiver outputReceiver;
    protected final InstanceManagementService instanceManagementService;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final Map<String, ManagedInstance> instancesById;
    protected ManagedInstance lastInstanceWithSingleCommandExecution;

    public AbstractStepDefinitionBase(TestScenarioExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.outputReceiver = executionContext.getOutputReceiver();
        this.instancesById = executionContext.getSharedInstancesByIdMap();
        this.instanceManagementService = ExternalServiceHolder.getInstanceManagementService();
    }

    protected final void printToCommandConsole(String text) {
        this.outputReceiver.addOutput(text);
    }

    protected final void assertPropertyOfTextOutput(ManagedInstance instance, String negationFlag, String useRegexpMarker, String substring, String output, String outputType) {
        boolean useRegexp;
        boolean expectedPresence = negationFlag == null;
        boolean bl = useRegexp = useRegexpMarker != null;
        if (!useRegexp) {
            useRegexpMarker = "";
        }
        boolean found = useRegexp ? Pattern.compile(substring, 8).matcher(output).find() : output.contains(substring);
        if (expectedPresence && !found) {
            Assert.fail((String)StringUtils.format((String)"The %s of instance \"%s\" did not contain %s\"%s\";\n  saving the examined output as %s for inspection", (Object[])new Object[]{outputType, instance, useRegexpMarker, substring, this.writeOutputToTempFile(output)}));
        }
        if (!expectedPresence && found) {
            Assert.fail((String)StringUtils.format((String)"The %s of instance \"%s\" contained %s\"%s\" although it should not;\n  saving the examined output as %s for inspection", (Object[])new Object[]{outputType, instance, useRegexpMarker, substring, this.writeOutputToTempFile(output)}));
        }
        if (expectedPresence) {
            this.printToCommandConsole(StringUtils.format((String)"  The %s of instance \"%s\" contained the expected text \"%s\"", (Object[])new Object[]{outputType, instance, substring}));
        } else {
            this.printToCommandConsole(StringUtils.format((String)"  The %s of instance \"%s\" did not contain text \"%s\" (as expected)", (Object[])new Object[]{outputType, instance, substring}));
        }
    }

    protected final String executeCommandOnInstance(ManagedInstance instance, String commandString, boolean isMainAction) {
        String instanceId = instance.getId();
        String logPattern = isMainAction ? "Executing command \"%s\" on instance \"%s\"" : "  (Executing command \"%s\" on instance \"%s\")";
        String startInfoText = StringUtils.format((String)logPattern, (Object[])new Object[]{commandString, instanceId});
        this.printToCommandConsole(startInfoText);
        this.log.debug((Object)startInfoText);
        CapturingTextOutReceiver commandOutputReceiver = new CapturingTextOutReceiver();
        try {
            int numAttempts = 0;
            while (numAttempts < 3) {
                try {
                    this.instanceManagementService.executeCommandOnInstance(instanceId, commandString, (TextOutputReceiver)commandOutputReceiver);
                    break;
                }
                catch (JSchException e) {
                    if (!e.toString().contains("Connection refused: connect")) {
                        throw e;
                    }
                    ++numAttempts;
                }
            }
            if (numAttempts > 1) {
                String retrySuffix = " after retrying the SSH connection for " + (numAttempts - 1) + " times)";
                this.printToCommandConsole(StringUtils.format((String)"  (Executed command \"%s\" on instance \"%s\"%s", (Object[])new Object[]{commandString, instanceId, retrySuffix}));
            }
            String commandOutput = commandOutputReceiver.getBufferedOutput();
            instance.setLastCommandOutput(commandOutput);
            this.log.debug((Object)StringUtils.format((String)"Finished execution of command \"%s\" on instance \"%s\"", (Object[])new Object[]{commandString, instanceId}));
            return commandOutput;
        }
        catch (JSchException | SshParameterException | IOException | InterruptedException e) {
            Assert.fail((String)StringUtils.format((String)"Failed to execute command \"%s\" on instance \"%s\": %s", (Object[])new Object[]{commandString, instanceId, e.toString()}));
            return null;
        }
    }

    protected final ManagedInstance resolveInstance(String instanceId) {
        return this.instancesById.get(instanceId);
    }

    protected final List<String> parseInstanceList(String instanceList) {
        return Arrays.asList(instanceList.trim().split("\\s*,\\s*"));
    }

    protected final String writeOutputToTempFile(String output) {
        try {
            File tempFile = File.createTempFile("bdd_test_failure_data", ".txt");
            FileUtils.write((File)tempFile, (CharSequence)output);
            return tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected error writing temp file: " + e.toString()));
            return null;
        }
    }
}

