/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.util;

import com.googlecode.lanterna.gui.Action;
import com.googlecode.lanterna.input.Key;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class ShortcutHelper {
    private final Map<Key.Kind, Action> specialKeysShortcut = new EnumMap<Key.Kind, Action>(Key.Kind.class);
    private final Map<NormalKeyShortcut, Action> normalKeysShortcut = new HashMap<NormalKeyShortcut, Action>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShortcut(Key.Kind kindOfKey, Action action) {
        if (kindOfKey == Key.Kind.NormalKey) {
            throw new IllegalArgumentException("Can't bind a normal key shortcut using this method, please use addShortcut(char, boolean, boolean, Action) instead");
        }
        if (kindOfKey == null || action == null) {
            throw new IllegalArgumentException("Called addShortcut with either a null kind or null action");
        }
        Map<Key.Kind, Action> map = this.specialKeysShortcut;
        synchronized (map) {
            this.specialKeysShortcut.put(kindOfKey, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShortcut(char character, boolean withCtrl, boolean withAlt, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Called addShortcut with a null action");
        }
        Map<NormalKeyShortcut, Action> map = this.normalKeysShortcut;
        synchronized (map) {
            this.normalKeysShortcut.put(new NormalKeyShortcut(character, withCtrl, withAlt), action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerShortcut(Key key) {
        if (key.getKind() == Key.Kind.NormalKey) {
            NormalKeyShortcut asShortcutKey = new NormalKeyShortcut(key.getCharacter(), key.isCtrlPressed(), key.isAltPressed());
            Map<NormalKeyShortcut, Action> map = this.normalKeysShortcut;
            synchronized (map) {
                if (this.normalKeysShortcut.containsKey(asShortcutKey)) {
                    this.normalKeysShortcut.get(asShortcutKey).doAction();
                    return true;
                }
                return false;
            }
        }
        Map<Key.Kind, Action> map = this.specialKeysShortcut;
        synchronized (map) {
            if (this.specialKeysShortcut.containsKey((Object)key.getKind())) {
                this.specialKeysShortcut.get((Object)key.getKind()).doAction();
                return true;
            }
            return false;
        }
    }

    private static class NormalKeyShortcut {
        private final char character;
        private final boolean withCtrl;
        private final boolean withAlt;

        public NormalKeyShortcut(char character, boolean withCtrl, boolean withAlt) {
            this.character = character;
            this.withCtrl = withCtrl;
            this.withAlt = withAlt;
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + this.character;
            hash = 71 * hash + (this.withCtrl ? 1 : 0);
            hash = 71 * hash + (this.withAlt ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NormalKeyShortcut other = (NormalKeyShortcut)obj;
            if (this.character != other.character) {
                return false;
            }
            if (this.withCtrl != other.withCtrl) {
                return false;
            }
            return this.withAlt == other.withAlt;
        }

        public String toString() {
            return (this.withCtrl ? "ctrl + " : "") + (this.withAlt ? "alt + " : "") + this.character;
        }
    }
}

