/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.nodeproperties.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.nodeproperties.NodeProperty;
import de.rcenvironment.core.communication.nodeproperties.spi.NodePropertiesChangeListener;
import de.rcenvironment.core.communication.nodeproperties.spi.RawNodePropertiesChangeListener;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListenerAdapter;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.service.AdditionalServiceDeclaration;
import de.rcenvironment.core.utils.common.service.AdditionalServicesProvider;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.utils.common.AutoCreationMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodePropertiesStateServiceImpl
implements AdditionalServicesProvider {
    private static final Set<NodeProperty> IMMUTABLE_EMPTY_PROPERTY_SET = Collections.unmodifiableSet(new HashSet());
    private final AutoCreationMap<InstanceNodeSessionId, Map<String, NodeProperty>> propertyObjectMapsByNode = new AutoCreationMap<InstanceNodeSessionId, Map<String, NodeProperty>>(){

        protected Map<String, NodeProperty> createNewEntry(InstanceNodeSessionId key) {
            return new HashMap<String, NodeProperty>();
        }
    };
    private final Map<InstanceNodeSessionId, Map<String, String>> immutableValueMapsOfNodes = new HashMap<InstanceNodeSessionId, Map<String, String>>();
    private final Map<InstanceNodeSessionId, Map<String, String>> immutableValueMapsOfReachableNodes = new HashMap<InstanceNodeSessionId, Map<String, String>>();
    private Set<InstanceNodeSessionId> reachableNodes = new HashSet<InstanceNodeSessionId>();
    private final Set<NodeProperty> reachableProperties = new HashSet<NodeProperty>();
    private final AsyncOrderedCallbackManager<NodePropertiesChangeListener> callbackManager;
    private final boolean verboseLogging = DebugSettings.getVerboseLoggingEnabled(this.getClass());
    private final Log log = LogFactory.getLog(this.getClass());

    public NodePropertiesStateServiceImpl() {
        this.callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    }

    public Collection<AdditionalServiceDeclaration> defineAdditionalServices() {
        ArrayList<AdditionalServiceDeclaration> result = new ArrayList<AdditionalServiceDeclaration>();
        result.add(new AdditionalServiceDeclaration(RawNodePropertiesChangeListener.class, (Object)new RawNodePropertiesChangeListener(){

            @Override
            public void onRawNodePropertiesAddedOrModified(Collection<? extends NodeProperty> newProperties) {
                NodePropertiesStateServiceImpl.this.updateOnRawPropertiesAddedOrModified(newProperties);
            }
        }));
        result.add(new AdditionalServiceDeclaration(NetworkTopologyChangeListener.class, (Object)new NetworkTopologyChangeListenerAdapter(){

            @Override
            public void onReachableNodesChanged(Set<InstanceNodeSessionId> newReachableNodes, Set<InstanceNodeSessionId> addedNodes, Set<InstanceNodeSessionId> removedNodes) {
                NodePropertiesStateServiceImpl.this.updateOnReachableNodesChanged(newReachableNodes, addedNodes, removedNodes);
            }
        }));
        return result;
    }

    public synchronized void addNodePropertiesChangeListener(NodePropertiesChangeListener listener) {
        final HashSet<NodeProperty> reachablePropertiesCopy = new HashSet<NodeProperty>(this.reachableProperties);
        final Map<InstanceNodeSessionId, Map<String, String>> valueMapsDeltaCopy = Collections.unmodifiableMap(this.immutableValueMapsOfReachableNodes);
        this.callbackManager.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<NodePropertiesChangeListener>(){

            public void performCallback(NodePropertiesChangeListener listener) {
                listener.onReachableNodePropertiesChanged(reachablePropertiesCopy, IMMUTABLE_EMPTY_PROPERTY_SET, IMMUTABLE_EMPTY_PROPERTY_SET);
                listener.onNodePropertyMapsOfNodesChanged(valueMapsDeltaCopy);
            }
        });
    }

    public void removeNodePropertiesChangeListener(NodePropertiesChangeListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    private synchronized void updateOnRawPropertiesAddedOrModified(Collection<? extends NodeProperty> newOrUpdatedProperties) {
        HashSet<NodeProperty> addedProperties = new HashSet<NodeProperty>();
        HashSet<NodeProperty> updatedProperties = new HashSet<NodeProperty>();
        HashSet<NodeProperty> removedProperties = new HashSet<NodeProperty>();
        HashSet<InstanceNodeSessionId> valueMapsToUpdate = new HashSet<InstanceNodeSessionId>();
        for (NodeProperty nodeProperty : newOrUpdatedProperties) {
            InstanceNodeSessionId nodeId = nodeProperty.getInstanceNodeSessionId();
            Map propertyObjectMap = (Map)this.propertyObjectMapsByNode.get((Object)nodeId);
            boolean isReachableNode = this.reachableNodes.contains(nodeId);
            valueMapsToUpdate.add(nodeId);
            if (nodeProperty.getValue() != null) {
                boolean wasPresent;
                NodeProperty replacedPropertyInstance = propertyObjectMap.put(nodeProperty.getKey(), nodeProperty);
                boolean bl = wasPresent = replacedPropertyInstance != null;
                if (!isReachableNode) continue;
                this.reachableProperties.add(nodeProperty);
                if (wasPresent) {
                    updatedProperties.add(nodeProperty);
                    continue;
                }
                addedProperties.add(nodeProperty);
                continue;
            }
            propertyObjectMap.remove(nodeProperty.getKey());
            if (isReachableNode) {
                removedProperties.add(nodeProperty);
                this.reachableProperties.remove(nodeProperty);
            }
            propertyObjectMap.remove(nodeProperty.getKey());
        }
        if (!(addedProperties.isEmpty() && updatedProperties.isEmpty() && removedProperties.isEmpty())) {
            final Set set = Collections.unmodifiableSet(addedProperties);
            final Set updatedPropertiesCopy = Collections.unmodifiableSet(updatedProperties);
            final Set removedPropertiesCopy = Collections.unmodifiableSet(removedProperties);
            if (this.verboseLogging) {
                this.log.debug((Object)StringUtils.format((String)"Reporting node property state change: %d properties added, %d updated, %d removed", (Object[])new Object[]{set.size(), updatedPropertiesCopy.size(), removedPropertiesCopy.size()}));
            }
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<NodePropertiesChangeListener>(){

                public void performCallback(NodePropertiesChangeListener listener) {
                    listener.onReachableNodePropertiesChanged(set, updatedPropertiesCopy, removedPropertiesCopy);
                }
            });
        }
        HashMap<InstanceNodeSessionId, Map<String, String>> hashMap = new HashMap<InstanceNodeSessionId, Map<String, String>>();
        for (InstanceNodeSessionId nodeId : valueMapsToUpdate) {
            Map<String, String> valueMap = this.createImmutableValueMapForNode(nodeId);
            if (this.reachableNodes.contains(nodeId)) {
                hashMap.put(nodeId, valueMap);
                this.immutableValueMapsOfReachableNodes.put(nodeId, valueMap);
            }
            this.immutableValueMapsOfNodes.put(nodeId, valueMap);
        }
        if (!hashMap.isEmpty()) {
            final Map valueMapsDeltaCopy = Collections.unmodifiableMap(hashMap);
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<NodePropertiesChangeListener>(){

                public void performCallback(NodePropertiesChangeListener listener) {
                    listener.onNodePropertyMapsOfNodesChanged(valueMapsDeltaCopy);
                }
            });
        }
    }

    private synchronized void updateOnReachableNodesChanged(Set<InstanceNodeSessionId> newReachableNodes, Set<InstanceNodeSessionId> addedNodes, Set<InstanceNodeSessionId> removedNodes) {
        HashMap<InstanceNodeSessionId, Map<String, String>> valueMapsDelta = new HashMap<InstanceNodeSessionId, Map<String, String>>();
        ArrayList disconnectedProperties = new ArrayList();
        for (InstanceNodeSessionId nodeId : removedNodes) {
            Map nodePropertyMap = (Map)this.propertyObjectMapsByNode.get((Object)nodeId);
            if (nodePropertyMap != null) {
                disconnectedProperties.addAll(nodePropertyMap.values());
            }
            valueMapsDelta.put(nodeId, null);
            this.immutableValueMapsOfReachableNodes.remove(nodeId);
        }
        ArrayList reconnectedProperties = new ArrayList();
        for (InstanceNodeSessionId nodeId : addedNodes) {
            Map nodePropertyMap = (Map)this.propertyObjectMapsByNode.get((Object)nodeId);
            if (nodePropertyMap != null) {
                reconnectedProperties.addAll(nodePropertyMap.values());
            }
            Map<String, String> immutableValueMap = this.immutableValueMapsOfNodes.get(nodeId);
            valueMapsDelta.put(nodeId, immutableValueMap);
            this.immutableValueMapsOfReachableNodes.put(nodeId, immutableValueMap);
        }
        if (!disconnectedProperties.isEmpty() || !reconnectedProperties.isEmpty()) {
            if (this.verboseLogging) {
                this.log.debug((Object)StringUtils.format((String)"Reporting node property state change after topology change: %d properties disconnected, %d reconnected", (Object[])new Object[]{disconnectedProperties.size(), reconnectedProperties.size()}));
            }
            final Collection disconnectedPropertiesCopy = Collections.unmodifiableCollection(disconnectedProperties);
            final Collection reconnectedPropertiesCopy = Collections.unmodifiableCollection(reconnectedProperties);
            final Collection updatedPropertiesDummy = Collections.unmodifiableCollection(new ArrayList());
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<NodePropertiesChangeListener>(){

                public void performCallback(NodePropertiesChangeListener listener) {
                    listener.onReachableNodePropertiesChanged(reconnectedPropertiesCopy, updatedPropertiesDummy, disconnectedPropertiesCopy);
                }
            });
        }
        if (!valueMapsDelta.isEmpty()) {
            final Map valueMapsDeltaCopy = Collections.unmodifiableMap(valueMapsDelta);
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<NodePropertiesChangeListener>(){

                public void performCallback(NodePropertiesChangeListener listener) {
                    listener.onNodePropertyMapsOfNodesChanged(valueMapsDeltaCopy);
                }
            });
        }
        this.reachableProperties.addAll(reconnectedProperties);
        this.reachableProperties.removeAll(disconnectedProperties);
        this.reachableNodes = newReachableNodes;
    }

    private Map<String, String> createImmutableValueMapForNode(InstanceNodeSessionId nodeId) {
        Map propertyObjectMap = (Map)this.propertyObjectMapsByNode.get((Object)nodeId);
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (NodeProperty property : propertyObjectMap.values()) {
            valueMap.put(property.getKey(), property.getValue());
        }
        return Collections.unmodifiableMap(valueMap);
    }
}

