/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.execute;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorPalette {
    private static ColorPalette instance = new ColorPalette();
    private final RGB warningRGB = new RGB(255, 0, 0);
    private final RGB firstRowRGB = new RGB(255, 255, 240);
    private final RGB secondRowRGB = new RGB(255, 255, 220);
    private final RGB blackRGB = new RGB(0, 0, 0);
    private boolean colorsDisposed = true;
    private Color warningRED;
    private Color firstRow;
    private Color secondRow;
    private Color comboBlack;

    private ColorPalette() {
        this.initColors();
    }

    private void initColors() {
        this.warningRED = new Color((Device)Display.getCurrent(), this.warningRGB);
        this.firstRow = new Color((Device)Display.getCurrent(), this.firstRowRGB);
        this.secondRow = new Color((Device)Display.getCurrent(), this.secondRowRGB);
        this.comboBlack = new Color((Device)Display.getCurrent(), this.blackRGB);
        this.colorsDisposed = false;
    }

    public static ColorPalette getInstance() {
        return instance;
    }

    public void disposeColors() {
        if (!this.colorsDisposed) {
            this.colorsDisposed = true;
            this.warningRED.dispose();
            this.firstRow.dispose();
            this.secondRow.dispose();
            this.comboBlack.dispose();
        }
    }

    public void loadColors() {
        if (this.colorsDisposed) {
            this.initColors();
        }
    }

    public Color getFirstRowColor() {
        return this.firstRow;
    }

    public Color getSecondRowColor() {
        return this.secondRow;
    }

    public Color getBlackColor() {
        return this.comboBlack;
    }

    public Color getWarningColor() {
        return this.warningRED;
    }
}

