/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.gui.communication.views.contributors.AbstractNetworkConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.ConnectionSettings;
import org.eclipse.swt.widgets.Shell;

public class EditNetworkConnectionDialog
extends AbstractNetworkConnectionDialog {
    private static final String COLON = ":";
    private static final String DIALOG_TITLE = "Edit Connection";
    private static final String HINT = "Note: The connection will not be saved.\nTo create permanent connections, edit the configuration files.\nChanges will be applied after restarting the connection.";

    public EditNetworkConnectionDialog(Shell parentShell, String connectionName, String networkContactPointID) {
        super(parentShell, connectionName, networkContactPointID);
        if (this.networkContactPointID.startsWith("activemq-tcp:")) {
            this.networkContactPointID = this.networkContactPointID.replace("activemq-tcp:", "");
        }
        this.host = this.networkContactPointID.substring(0, this.networkContactPointID.indexOf(COLON));
        if (this.networkContactPointID.contains("(")) {
            int index = this.networkContactPointID.indexOf("(");
            String settings = this.networkContactPointID.substring(index);
            settings = settings.replaceAll("[()]", "");
            this.setSettingsText(settings);
            this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1, index);
            String network = this.networkContactPointID.substring(0, index);
            if (this.connectionName.equals(network)) {
                this.activateDefaultName();
            } else {
                this.deactivateDefaultName();
            }
        } else {
            this.port = this.networkContactPointID.substring(this.networkContactPointID.indexOf(COLON) + 1);
            if (this.connectionName.equals(this.networkContactPointID)) {
                this.activateDefaultName();
            } else {
                this.deactivateDefaultName();
            }
        }
        this.hint = HINT;
    }

    private void setSettingsText(String settings) {
        ConnectionSettings set = new ConnectionSettings();
        try {
            String numberOnly = settings.replaceAll("[^0-9,.]", "");
            if (numberOnly.charAt(numberOnly.length() - 1) == ',') {
                numberOnly = numberOnly.substring(0, numberOnly.length() - 1);
            }
            if (numberOnly.startsWith(",")) {
                numberOnly = numberOnly.substring(1);
            }
            int indexFirstCom = numberOnly.indexOf(",");
            int indexSecondCom = numberOnly.indexOf(",", numberOnly.indexOf(",") + 1);
            String multi = numberOnly.substring(0, indexFirstCom);
            multi = multi.replaceAll("[^0-9.]", "");
            String initialDelay = numberOnly.substring(indexFirstCom, indexSecondCom);
            initialDelay = initialDelay.replaceAll("[^0-9]", "");
            String maxDelay = numberOnly.substring(indexSecondCom);
            maxDelay = maxDelay.replaceAll("[^0-9]", "");
            this.settingsText = set.createStringForsettings(Integer.parseInt(initialDelay), Integer.parseInt(maxDelay), Double.parseDouble(multi));
        }
        catch (NumberFormatException numberFormatException) {
            this.settingsText = set.createStringForsettings(5, 300, 1.5);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }
}

